/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.scan.branch;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.picocontainer.annotations.Nullable;
import org.picocontainer.injectors.ProviderAdapter;
import org.sonar.api.batch.bootstrap.ProjectKey;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.api.utils.log.Profiler;
import org.sonar.scanner.bootstrap.GlobalConfiguration;
import org.sonar.scanner.repository.settings.SettingsLoader;
import org.sonar.scanner.scan.branch.BranchConfiguration;
import org.sonar.scanner.scan.branch.BranchConfigurationLoader;
import org.sonar.scanner.scan.branch.DefaultBranchConfiguration;
import org.sonar.scanner.scan.branch.ProjectBranches;

public class BranchConfigurationProvider
extends ProviderAdapter {
    private static final Logger LOG = Loggers.get(BranchConfigurationProvider.class);
    private static final String LOG_MSG = "Load branch configuration";
    private BranchConfiguration branchConfiguration = null;

    public BranchConfiguration provide(@Nullable BranchConfigurationLoader loader, GlobalConfiguration globalConfiguration, ProjectKey projectKey, SettingsLoader settingsLoader, ProjectBranches branches) {
        if (this.branchConfiguration == null) {
            if (loader == null) {
                this.branchConfiguration = new DefaultBranchConfiguration();
            } else {
                Profiler profiler = Profiler.create((Logger)LOG).startInfo(LOG_MSG);
                Supplier<Map<String, String>> settingsSupplier = BranchConfigurationProvider.createSettingsSupplier(globalConfiguration, projectKey, settingsLoader);
                this.branchConfiguration = loader.load(globalConfiguration.getProperties(), settingsSupplier, branches);
                profiler.stopInfo();
            }
        }
        return this.branchConfiguration;
    }

    private static Supplier<Map<String, String>> createSettingsSupplier(GlobalConfiguration globalConfiguration, ProjectKey projectKey, SettingsLoader settingsLoader) {
        return () -> {
            HashMap<String, String> settings = new HashMap<String, String>();
            settings.putAll(globalConfiguration.getProperties());
            settings.putAll(settingsLoader.load(projectKey.get()));
            return settings;
        };
    }
}

