/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.platform;

import java.io.File;
import java.util.Date;
import javax.annotation.CheckForNull;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.SonarRuntime;
import org.sonar.api.batch.ScannerSide;
import org.sonar.api.config.Settings;
import org.sonar.api.platform.Server;
import org.sonar.api.utils.DateUtils;
import org.sonar.scanner.bootstrap.ScannerWsClient;

@ScannerSide
public class DefaultServer
extends Server {
    private final Settings settings;
    private final ScannerWsClient client;
    private final SonarRuntime runtime;

    public DefaultServer(Settings settings, ScannerWsClient client, SonarRuntime runtime) {
        this.settings = settings;
        this.client = client;
        this.runtime = runtime;
    }

    public String getId() {
        return this.settings.getString("sonar.core.id");
    }

    public String getVersion() {
        return this.runtime.getApiVersion().toString();
    }

    public Date getStartedAt() {
        String dateString = this.settings.getString("sonar.core.startTime");
        return DateUtils.parseDateTime((String)dateString);
    }

    public File getRootDir() {
        return null;
    }

    @CheckForNull
    public File getDeployDir() {
        return null;
    }

    public String getContextPath() {
        return null;
    }

    public String getPublicRootUrl() {
        String baseUrl = StringUtils.trimToEmpty((String)this.settings.getString("sonar.core.serverBaseURL"));
        if (baseUrl.isEmpty()) {
            baseUrl = this.client.baseUrl();
        }
        return StringUtils.removeEnd((String)baseUrl, (String)"/");
    }

    public boolean isDev() {
        return false;
    }

    public boolean isSecured() {
        return false;
    }

    public String getURL() {
        return StringUtils.removeEnd((String)this.client.baseUrl(), (String)"/");
    }

    public String getPermanentServerId() {
        return this.settings.getString("sonar.server_id");
    }
}

