/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.issue.tracking;

import org.sonar.api.batch.InstantiationStrategy;
import org.sonar.api.batch.ScannerSide;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputModule;
import org.sonar.api.batch.fs.internal.DefaultInputComponent;
import org.sonar.api.batch.fs.internal.DefaultInputModule;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.api.utils.log.Profiler;
import org.sonar.core.component.ComponentKeys;
import org.sonar.scanner.issue.tracking.ServerIssueValueCoder;
import org.sonar.scanner.protocol.input.ScannerInput;
import org.sonar.scanner.repository.ServerIssuesLoader;
import org.sonar.scanner.scan.filesystem.InputComponentStore;
import org.sonar.scanner.storage.Storage;
import org.sonar.scanner.storage.Storages;

@InstantiationStrategy(value="PER_BATCH")
@ScannerSide
public class ServerIssueRepository {
    private static final Logger LOG = Loggers.get(ServerIssueRepository.class);
    private static final String LOG_MSG = "Load server issues";
    private final Storages caches;
    private Storage<ScannerInput.ServerIssue> issuesCache;
    private final ServerIssuesLoader previousIssuesLoader;
    private final InputComponentStore componentStore;

    public ServerIssueRepository(Storages caches, ServerIssuesLoader previousIssuesLoader, InputComponentStore componentStore) {
        this.caches = caches;
        this.previousIssuesLoader = previousIssuesLoader;
        this.componentStore = componentStore;
    }

    public void load() {
        Profiler profiler = Profiler.create((Logger)LOG).startInfo(LOG_MSG);
        this.issuesCache = this.caches.createCache("previousIssues");
        this.caches.registerValueCoder(ScannerInput.ServerIssue.class, new ServerIssueValueCoder());
        DefaultInputModule root = (DefaultInputModule)this.componentStore.root();
        this.previousIssuesLoader.load(root.getKeyWithBranch(), this::store);
        profiler.stopInfo();
    }

    public Iterable<ScannerInput.ServerIssue> byComponent(InputComponent component) {
        return this.issuesCache.values(((DefaultInputComponent)component).batchId());
    }

    private void store(ScannerInput.ServerIssue issue) {
        String componentKeyWithoutBranch;
        DefaultInputComponent r;
        String moduleKeyWithBranch = issue.getModuleKey();
        InputModule module = this.componentStore.getModule(moduleKeyWithBranch);
        if (module != null && (r = (DefaultInputComponent)this.componentStore.getByKey(componentKeyWithoutBranch = ComponentKeys.createEffectiveKey((String)module.key(), (String)(issue.hasPath() ? issue.getPath() : null)))) != null) {
            this.issuesCache.put(r.batchId(), issue.getKey(), issue);
            return;
        }
        this.issuesCache.put(0, issue.getKey(), issue);
    }

    public Iterable<ScannerInput.ServerIssue> issuesOnMissingComponents() {
        return this.issuesCache.values(0);
    }
}

