/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.issue.tracking;

import com.google.common.base.Splitter;
import com.google.common.collect.Iterators;
import java.io.IOException;
import java.io.Reader;
import org.apache.commons.io.IOUtils;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.api.utils.log.Profiler;
import org.sonar.scanner.bootstrap.ScannerWsClient;
import org.sonar.scanner.issue.tracking.ServerLineHashesLoader;
import org.sonar.scanner.util.ScannerUtils;
import org.sonarqube.ws.client.GetRequest;
import org.sonarqube.ws.client.WsRequest;

public class DefaultServerLineHashesLoader
implements ServerLineHashesLoader {
    private ScannerWsClient wsClient;

    public DefaultServerLineHashesLoader(ScannerWsClient wsClient) {
        this.wsClient = wsClient;
    }

    @Override
    public String[] getLineHashes(String fileKey) {
        String hashesFromWs = this.loadHashesFromWs(fileKey);
        return (String[])Iterators.toArray(Splitter.on((char)'\n').split((CharSequence)hashesFromWs).iterator(), String.class);
    }

    private String loadHashesFromWs(String fileKey) {
        Profiler profiler = Profiler.createIfDebug((Logger)Loggers.get(this.getClass())).addContext("file", (Object)fileKey).startDebug("Load line hashes");
        GetRequest getRequest = new GetRequest("/api/sources/hash?key=" + ScannerUtils.encodeForUrl(fileKey));
        Reader reader = this.wsClient.call((WsRequest)getRequest).contentReader();
        try {
            String string = IOUtils.toString((Reader)reader);
            return string;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        finally {
            profiler.stopDebug();
        }
    }
}

