/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.issue;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import org.sonar.api.issue.Issue;
import org.sonar.api.issue.IssueComment;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.utils.Duration;
import org.sonar.scanner.issue.tracking.TrackedIssue;

public class TrackedIssueAdapter
implements Issue {
    private TrackedIssue issue;

    public TrackedIssueAdapter(TrackedIssue issue) {
        this.issue = issue;
    }

    public String key() {
        return this.issue.key();
    }

    public String componentKey() {
        return this.issue.componentKey();
    }

    public RuleKey ruleKey() {
        return this.issue.getRuleKey();
    }

    public String severity() {
        return this.issue.severity();
    }

    public String message() {
        return this.issue.getMessage();
    }

    public Integer line() {
        return this.issue.startLine();
    }

    @Deprecated
    public Double effortToFix() {
        return this.gap();
    }

    public Double gap() {
        return this.issue.gap();
    }

    public String status() {
        return this.issue.status();
    }

    public String resolution() {
        return this.issue.resolution();
    }

    @Deprecated
    @CheckForNull
    public String reporter() {
        return null;
    }

    public String assignee() {
        return this.issue.assignee();
    }

    public boolean isNew() {
        return this.issue.isNew();
    }

    public boolean isCopied() {
        return false;
    }

    public Map<String, String> attributes() {
        return new HashMap<String, String>();
    }

    public Date creationDate() {
        return this.issue.getCreationDate();
    }

    public String language() {
        return null;
    }

    public Date updateDate() {
        return null;
    }

    public Date closeDate() {
        return null;
    }

    public String attribute(String key) {
        return this.attributes().get(key);
    }

    public String authorLogin() {
        return null;
    }

    public String actionPlanKey() {
        return null;
    }

    public List<IssueComment> comments() {
        return new ArrayList<IssueComment>();
    }

    @Deprecated
    public Duration debt() {
        return null;
    }

    public Duration effort() {
        return null;
    }

    public String projectKey() {
        return null;
    }

    public String projectUuid() {
        return null;
    }

    public String componentUuid() {
        return null;
    }

    public Collection<String> tags() {
        return new ArrayList<String>();
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof Issue)) {
            return false;
        }
        Issue that = (Issue)o;
        return !(this.issue.key() == null ? that.key() != null : !this.issue.key().equals(that.key()));
    }

    public int hashCode() {
        return this.issue.key() != null ? this.issue.key().hashCode() : 0;
    }
}

