/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.cpd;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.internal.DefaultInputComponent;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.duplications.block.Block;
import org.sonar.duplications.detector.suffixtree.SuffixTreeCloneDetectionAlgorithm;
import org.sonar.duplications.index.CloneGroup;
import org.sonar.duplications.index.CloneIndex;
import org.sonar.duplications.index.ClonePart;
import org.sonar.duplications.index.PackedMemoryCloneIndex;
import org.sonar.scanner.cpd.CpdSettings;
import org.sonar.scanner.cpd.DuplicationPredicates;
import org.sonar.scanner.cpd.index.SonarCpdBlockIndex;
import org.sonar.scanner.protocol.output.ScannerReport;
import org.sonar.scanner.report.ReportPublisher;
import org.sonar.scanner.scan.branch.BranchConfiguration;
import org.sonar.scanner.scan.filesystem.InputComponentStore;
import org.sonar.scanner.util.ProgressReport;

public class CpdExecutor {
    private static final Logger LOG = Loggers.get(CpdExecutor.class);
    private static final int TIMEOUT = 300000;
    static final int MAX_CLONE_GROUP_PER_FILE = 100;
    static final int MAX_CLONE_PART_PER_GROUP = 100;
    private final SonarCpdBlockIndex index;
    private final ReportPublisher publisher;
    private final InputComponentStore componentStore;
    private final ProgressReport progressReport;
    private final CpdSettings settings;
    private final BranchConfiguration branchConfiguration;
    private int count;
    private int total;

    public CpdExecutor(CpdSettings settings, SonarCpdBlockIndex index, ReportPublisher publisher, InputComponentStore inputComponentCache, BranchConfiguration branchConfiguration) {
        this.settings = settings;
        this.index = index;
        this.publisher = publisher;
        this.componentStore = inputComponentCache;
        this.branchConfiguration = branchConfiguration;
        this.progressReport = new ProgressReport("CPD computation", TimeUnit.SECONDS.toMillis(10L));
    }

    public void execute() {
        if (this.branchConfiguration.isShortLivingBranch()) {
            LOG.info("Skipping CPD calculation for short living branch");
            return;
        }
        this.execute(300000L);
    }

    @VisibleForTesting
    void execute(long timeout) {
        this.total = this.index.noResources();
        int filesWithoutBlocks = this.index.noIndexedFiles() - this.total;
        if (filesWithoutBlocks > 0) {
            LOG.info("{} {} had no CPD blocks", (Object)filesWithoutBlocks, (Object)CpdExecutor.pluralize(filesWithoutBlocks));
        }
        this.progressReport.start(String.format("Calculating CPD for %d %s", this.total, CpdExecutor.pluralize(this.total)));
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        try {
            Iterator<PackedMemoryCloneIndex.ResourceBlocks> it = this.index.iterator();
            while (it.hasNext()) {
                PackedMemoryCloneIndex.ResourceBlocks resourceBlocks = it.next();
                this.runCpdAnalysis(executorService, resourceBlocks.resourceId(), resourceBlocks.blocks(), timeout);
                ++this.count;
            }
            this.progressReport.stop("CPD calculation finished");
        }
        catch (Exception e) {
            this.progressReport.stop("");
            throw e;
        }
        finally {
            executorService.shutdown();
        }
    }

    private static String pluralize(int files) {
        return files == 1 ? "file" : "files";
    }

    @VisibleForTesting
    void runCpdAnalysis(ExecutorService executorService, String componentKey, Collection<Block> fileBlocks, long timeout) {
        List filtered;
        List duplications;
        DefaultInputComponent component = (DefaultInputComponent)this.componentStore.getByKey(componentKey);
        if (component == null) {
            LOG.error("Resource not found in component store: {}. Skipping CPD computation for it", (Object)componentKey);
            return;
        }
        InputFile inputFile = (InputFile)component;
        LOG.debug("Detection of duplications for {}", (Object)inputFile.absolutePath());
        this.progressReport.message(String.format("%d/%d - current file: %s", this.count, this.total, inputFile.absolutePath()));
        Future<List> futureResult = executorService.submit(() -> SuffixTreeCloneDetectionAlgorithm.detect((CloneIndex)this.index, (Collection)fileBlocks));
        try {
            duplications = futureResult.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            LOG.warn("Timeout during detection of duplications for " + inputFile.absolutePath());
            futureResult.cancel(true);
            return;
        }
        catch (Exception e) {
            throw new IllegalStateException("Fail during detection of duplication for " + inputFile.absolutePath(), e);
        }
        if (!"java".equalsIgnoreCase(inputFile.language())) {
            int minTokens = this.settings.getMinimumTokens(inputFile.language());
            Predicate<CloneGroup> minimumTokensPredicate = DuplicationPredicates.numberOfUnitsNotLessThan(minTokens);
            filtered = FluentIterable.from((Iterable)duplications).filter(minimumTokensPredicate).toList();
        } else {
            filtered = duplications;
        }
        this.saveDuplications(component, filtered);
    }

    @VisibleForTesting
    final void saveDuplications(final DefaultInputComponent component, List<CloneGroup> duplications) {
        if (duplications.size() > 100) {
            LOG.warn("Too many duplication groups on file " + component + ". Keep only the first " + 100 + " groups.");
        }
        FluentIterable reportDuplications = FluentIterable.from(duplications).limit(100).transform((Function)new Function<CloneGroup, ScannerReport.Duplication>(){
            private final ScannerReport.Duplication.Builder dupBuilder = ScannerReport.Duplication.newBuilder();
            private final ScannerReport.Duplicate.Builder blockBuilder = ScannerReport.Duplicate.newBuilder();

            public ScannerReport.Duplication apply(CloneGroup input) {
                return CpdExecutor.this.toReportDuplication((InputComponent)component, this.dupBuilder, this.blockBuilder, input);
            }
        });
        this.publisher.getWriter().writeComponentDuplications(component.batchId(), (Iterable)reportDuplications);
    }

    private ScannerReport.Duplication toReportDuplication(InputComponent component, ScannerReport.Duplication.Builder dupBuilder, ScannerReport.Duplicate.Builder blockBuilder, CloneGroup input) {
        dupBuilder.clear();
        ClonePart originBlock = input.getOriginPart();
        blockBuilder.clear();
        dupBuilder.setOriginPosition(ScannerReport.TextRange.newBuilder().setStartLine(originBlock.getStartLine()).setEndLine(originBlock.getEndLine()).build());
        int clonePartCount = 0;
        for (ClonePart duplicate : input.getCloneParts()) {
            if (duplicate.equals((Object)originBlock)) continue;
            if (++clonePartCount > 100) {
                LOG.warn("Too many duplication references on file " + component + " for block at line " + originBlock.getStartLine() + ". Keep only the first " + 100 + " references.");
                break;
            }
            blockBuilder.clear();
            String componentKey = duplicate.getResourceId();
            if (!component.key().equals(componentKey)) {
                DefaultInputComponent sameProjectComponent = (DefaultInputComponent)this.componentStore.getByKey(componentKey);
                blockBuilder.setOtherFileRef(sameProjectComponent.batchId());
            }
            dupBuilder.addDuplicate(blockBuilder.setRange(ScannerReport.TextRange.newBuilder().setStartLine(duplicate.getStartLine()).setEndLine(duplicate.getEndLine()).build()).build());
        }
        return dupBuilder.build();
    }
}

