/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.scanner.bootstrap;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.config.Encryption;
import org.sonar.api.config.PropertyDefinitions;
import org.sonar.scanner.bootstrap.DroppedPropertyChecker;
import org.sonar.scanner.bootstrap.GlobalAnalysisMode;
import org.sonar.scanner.config.DefaultConfiguration;

@Immutable
public class GlobalConfiguration
extends DefaultConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(GlobalConfiguration.class);
    private static final String JDBC_SPECIFIC_MESSAGE = "It will be ignored. There is no longer any DB connection to the SQ database.";
    private static final Map<String, String> DROPPED_PROPERTIES = ImmutableMap.of((Object)"sonar.jdbc.url", (Object)"It will be ignored. There is no longer any DB connection to the SQ database.", (Object)"sonar.jdbc.username", (Object)"It will be ignored. There is no longer any DB connection to the SQ database.", (Object)"sonar.jdbc.password", (Object)"It will be ignored. There is no longer any DB connection to the SQ database.");
    private final Map<String, String> serverSideSettings;

    public GlobalConfiguration(PropertyDefinitions propertyDefinitions, Encryption encryption, GlobalAnalysisMode mode, Map<String, String> settings, Map<String, String> serverSideSettings) {
        super(propertyDefinitions, encryption, mode, settings);
        this.serverSideSettings = GlobalConfiguration.unmodifiableMapWithTrimmedValues(propertyDefinitions, serverSideSettings);
        this.get("sonar.server_id").ifPresent(v -> LOG.info("Server id: {}", v));
        new DroppedPropertyChecker(this.getProperties(), DROPPED_PROPERTIES).checkDroppedProperties();
    }

    public Map<String, String> getServerSideSettings() {
        return this.serverSideSettings;
    }
}

