/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.fs.internal;

import java.io.File;
import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.concurrent.Immutable;
import org.sonar.api.batch.bootstrap.ProjectDefinition;
import org.sonar.api.batch.fs.InputModule;
import org.sonar.api.batch.fs.internal.DefaultInputComponent;
import org.sonar.api.batch.fs.internal.TestInputFileBuilder;

@Immutable
public class DefaultInputModule
extends DefaultInputComponent
implements InputModule {
    private final Path baseDir;
    private final Path workDir;
    private final String name;
    private final String version;
    private final String originalName;
    private final String originalVersion;
    private final String description;
    private final String keyWithBranch;
    private final String branch;
    private final List<String> sources;
    private final List<String> tests;
    private final Map<String, String> properties;
    private final String moduleKey;
    private final ProjectDefinition definition;

    public DefaultInputModule(ProjectDefinition definition) {
        this(definition, TestInputFileBuilder.nextBatchId());
    }

    public DefaultInputModule(ProjectDefinition definition, int batchId) {
        super(batchId);
        this.baseDir = DefaultInputModule.initBaseDir(definition);
        this.workDir = DefaultInputModule.initWorkingDir(definition);
        this.name = definition.getName();
        this.originalName = definition.getOriginalName();
        this.version = definition.getVersion();
        this.originalVersion = definition.getOriginalVersion();
        this.description = definition.getDescription();
        this.keyWithBranch = definition.getKeyWithBranch();
        this.branch = definition.getBranch();
        this.sources = Collections.unmodifiableList(new ArrayList<String>(definition.sources()));
        this.tests = Collections.unmodifiableList(new ArrayList<String>(definition.tests()));
        this.properties = Collections.unmodifiableMap(new HashMap<String, String>(definition.properties()));
        this.definition = definition;
        this.moduleKey = definition.getKey();
    }

    private static Path initBaseDir(ProjectDefinition module) {
        Path result;
        try {
            result = module.getBaseDir().toPath().toRealPath(LinkOption.NOFOLLOW_LINKS);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to resolve module baseDir", e);
        }
        return result;
    }

    private static Path initWorkingDir(ProjectDefinition module) {
        File workingDirAsFile = module.getWorkDir();
        return workingDirAsFile.getAbsoluteFile().toPath().normalize();
    }

    @Override
    public String key() {
        return this.moduleKey;
    }

    @Override
    public boolean isFile() {
        return false;
    }

    public ProjectDefinition definition() {
        return this.definition;
    }

    public Path getBaseDir() {
        return this.baseDir;
    }

    public Path getWorkDir() {
        return this.workDir;
    }

    public String getKeyWithBranch() {
        return this.keyWithBranch;
    }

    @CheckForNull
    public String getBranch() {
        return this.branch;
    }

    public Map<String, String> properties() {
        return this.properties;
    }

    @CheckForNull
    public String getOriginalVersion() {
        return this.originalVersion;
    }

    public String getVersion() {
        return this.version;
    }

    @CheckForNull
    public String getOriginalName() {
        return this.originalName;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public List<String> sources() {
        return this.sources;
    }

    public List<String> tests() {
        return this.tests;
    }
}

