/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.sensor.highlighting.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.TextRange;
import org.sonar.api.batch.fs.internal.DefaultInputFile;
import org.sonar.api.batch.sensor.highlighting.NewHighlighting;
import org.sonar.api.batch.sensor.highlighting.TypeOfText;
import org.sonar.api.batch.sensor.highlighting.internal.SyntaxHighlightingRule;
import org.sonar.api.batch.sensor.internal.DefaultStorable;
import org.sonar.api.batch.sensor.internal.SensorStorage;
import org.sonar.api.utils.Preconditions;

public class DefaultHighlighting
extends DefaultStorable
implements NewHighlighting {
    private final List<SyntaxHighlightingRule> syntaxHighlightingRules = new ArrayList<SyntaxHighlightingRule>();
    private DefaultInputFile inputFile;

    public DefaultHighlighting(SensorStorage storage) {
        super(storage);
    }

    public List<SyntaxHighlightingRule> getSyntaxHighlightingRuleSet() {
        return this.syntaxHighlightingRules;
    }

    private void checkOverlappingBoundaries() {
        if (this.syntaxHighlightingRules.size() > 1) {
            Iterator<SyntaxHighlightingRule> it = this.syntaxHighlightingRules.iterator();
            SyntaxHighlightingRule previous = it.next();
            while (it.hasNext()) {
                SyntaxHighlightingRule current = it.next();
                if (previous.range().end().compareTo((Object)current.range().start()) > 0 && previous.range().end().compareTo((Object)current.range().end()) < 0) {
                    String errorMsg = String.format("Cannot register highlighting rule for characters at %s as it overlaps at least one existing rule", current.range());
                    throw new IllegalStateException(errorMsg);
                }
                previous = current;
            }
        }
    }

    public DefaultHighlighting onFile(InputFile inputFile) {
        Objects.requireNonNull(inputFile, "file can't be null");
        this.inputFile = (DefaultInputFile)inputFile;
        return this;
    }

    public InputFile inputFile() {
        return this.inputFile;
    }

    public DefaultHighlighting highlight(int startOffset, int endOffset, TypeOfText typeOfText) {
        TextRange newRange;
        this.checkInputFileNotNull();
        try {
            newRange = this.inputFile.newRange(startOffset, endOffset);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to highlight file " + this.inputFile, e);
        }
        return this.highlight(newRange, typeOfText);
    }

    public DefaultHighlighting highlight(int startLine, int startLineOffset, int endLine, int endLineOffset, TypeOfText typeOfText) {
        TextRange newRange;
        this.checkInputFileNotNull();
        try {
            newRange = this.inputFile.newRange(startLine, startLineOffset, endLine, endLineOffset);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to highlight file " + this.inputFile, e);
        }
        return this.highlight(newRange, typeOfText);
    }

    public DefaultHighlighting highlight(TextRange range, TypeOfText typeOfText) {
        SyntaxHighlightingRule syntaxHighlightingRule = SyntaxHighlightingRule.create(range, typeOfText);
        this.syntaxHighlightingRules.add(syntaxHighlightingRule);
        return this;
    }

    @Override
    protected void doSave() {
        this.checkInputFileNotNull();
        Collections.sort(this.syntaxHighlightingRules, (left, right) -> {
            int result = left.range().start().compareTo((Object)right.range().start());
            if (result == 0) {
                result = right.range().end().compareTo((Object)left.range().end());
            }
            return result;
        });
        this.checkOverlappingBoundaries();
        this.storage.store((NewHighlighting)this);
    }

    private void checkInputFileNotNull() {
        Preconditions.checkState((this.inputFile != null ? 1 : 0) != 0, (String)"Call onFile() first");
    }
}

