/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.sensor.internal;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.config.Configuration;

public class DefaultSensorDescriptor
implements SensorDescriptor {
    public static final Set<String> HARDCODED_INDEPENDENT_FILE_SENSORS = Collections.unmodifiableSet(Stream.of("CSS Metrics", "CSS Rules", "HTML", "XML Sensor").collect(Collectors.toSet()));
    private String name;
    private String[] languages = new String[0];
    private InputFile.Type type = null;
    private String[] ruleRepositories = new String[0];
    private boolean global = false;
    private Predicate<Configuration> configurationPredicate;
    private boolean processesFilesIndependently = false;

    public String name() {
        return this.name;
    }

    public Collection<String> languages() {
        return Arrays.asList(this.languages);
    }

    @Nullable
    public InputFile.Type type() {
        return this.type;
    }

    public Collection<String> ruleRepositories() {
        return Arrays.asList(this.ruleRepositories);
    }

    public Predicate<Configuration> configurationPredicate() {
        return this.configurationPredicate;
    }

    public boolean isGlobal() {
        return this.global;
    }

    public boolean isProcessesFilesIndependently() {
        return this.processesFilesIndependently;
    }

    public DefaultSensorDescriptor name(String name) {
        if (HARDCODED_INDEPENDENT_FILE_SENSORS.contains(name)) {
            this.processesFilesIndependently = true;
        }
        this.name = name;
        return this;
    }

    public DefaultSensorDescriptor onlyOnLanguage(String languageKey) {
        return this.onlyOnLanguages(languageKey);
    }

    public DefaultSensorDescriptor onlyOnLanguages(String ... languageKeys) {
        this.languages = languageKeys;
        return this;
    }

    public DefaultSensorDescriptor onlyOnFileType(InputFile.Type type) {
        this.type = type;
        return this;
    }

    public DefaultSensorDescriptor createIssuesForRuleRepository(String ... repositoryKey) {
        return this.createIssuesForRuleRepositories(repositoryKey);
    }

    public DefaultSensorDescriptor createIssuesForRuleRepositories(String ... repositoryKeys) {
        this.ruleRepositories = repositoryKeys;
        return this;
    }

    public SensorDescriptor global() {
        this.global = true;
        return this;
    }

    public SensorDescriptor onlyWhenConfiguration(Predicate<Configuration> configurationPredicate) {
        this.configurationPredicate = configurationPredicate;
        return this;
    }

    public SensorDescriptor processesFilesIndependently() {
        this.processesFilesIndependently = true;
        return this;
    }
}

