/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.fs.internal;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.bootstrap.ProjectDefinition;
import org.sonar.api.batch.fs.internal.DefaultInputComponent;

@Immutable
public abstract class AbstractProjectOrModule
extends DefaultInputComponent {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractProjectOrModule.class);
    private final Path baseDir;
    private final Path workDir;
    private final String name;
    private final String originalName;
    private final String description;
    private final Map<String, String> properties;
    private final String key;
    private final ProjectDefinition definition;
    private final Charset encoding;

    public AbstractProjectOrModule(ProjectDefinition definition, int scannerComponentId) {
        super(scannerComponentId);
        this.baseDir = AbstractProjectOrModule.initBaseDir(definition);
        this.workDir = AbstractProjectOrModule.initWorkingDir(definition);
        this.name = definition.getName();
        this.originalName = definition.getOriginalName();
        this.description = definition.getDescription();
        this.properties = Collections.unmodifiableMap(new HashMap(definition.properties()));
        this.definition = definition;
        this.key = definition.getKey();
        this.encoding = AbstractProjectOrModule.initEncoding(definition);
    }

    private static Charset initEncoding(ProjectDefinition module) {
        String encodingStr = (String)module.properties().get("sonar.sourceEncoding");
        Charset result = StringUtils.isNotEmpty((String)encodingStr) ? Charset.forName(StringUtils.trim((String)encodingStr)) : Charset.defaultCharset();
        return result;
    }

    private static Path initBaseDir(ProjectDefinition module) {
        Path result;
        try {
            result = module.getBaseDir().toPath().toRealPath(LinkOption.NOFOLLOW_LINKS);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to resolve module baseDir", e);
        }
        return result;
    }

    private static Path initWorkingDir(ProjectDefinition module) {
        File workingDirAsFile = module.getWorkDir();
        Path workingDir = workingDirAsFile.getAbsoluteFile().toPath().normalize();
        if (SystemUtils.IS_OS_WINDOWS) {
            try {
                Files.createDirectories(workingDir, new FileAttribute[0]);
                Files.setAttribute(workingDir, "dos:hidden", true, LinkOption.NOFOLLOW_LINKS);
            }
            catch (IOException e) {
                LOGGER.warn("Failed to set working directory hidden: {}", (Object)e.getMessage());
            }
        }
        return workingDir;
    }

    public String key() {
        return this.key;
    }

    public boolean isFile() {
        return false;
    }

    public ProjectDefinition definition() {
        return this.definition;
    }

    public Path getBaseDir() {
        return this.baseDir;
    }

    public Path getWorkDir() {
        return this.workDir;
    }

    public Map<String, String> properties() {
        return this.properties;
    }

    @CheckForNull
    public String getOriginalName() {
        return this.originalName;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Charset getEncoding() {
        return this.encoding;
    }
}

