/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.util;

import java.security.SecureRandom;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.codec.binary.Base64;
import org.sonar.core.util.MacAddressProvider;
import org.sonar.core.util.UuidFactory;

public enum UuidFactoryImpl implements UuidFactory
{
    INSTANCE;

    private final AtomicInteger sequenceNumber = new AtomicInteger(new SecureRandom().nextInt());
    private long lastTimestamp = 0L;
    private final byte[] secureMungedAddress = MacAddressProvider.getSecureMungedAddress();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String create() {
        int sequenceId = this.sequenceNumber.incrementAndGet() & 0xFFFFFF;
        long timestamp = System.currentTimeMillis();
        UuidFactoryImpl uuidFactoryImpl = this;
        synchronized (uuidFactoryImpl) {
            timestamp = Math.max(this.lastTimestamp, timestamp);
            if (sequenceId == 0) {
                ++timestamp;
            }
            this.lastTimestamp = timestamp;
        }
        byte[] uuidBytes = new byte[15];
        UuidFactoryImpl.putLong(uuidBytes, timestamp, 0, 6);
        System.arraycopy(this.secureMungedAddress, 0, uuidBytes, 6, this.secureMungedAddress.length);
        UuidFactoryImpl.putLong(uuidBytes, sequenceId, 12, 3);
        return Base64.encodeBase64URLSafeString(uuidBytes);
    }

    private static void putLong(byte[] array, long l, int pos, int numberOfLongBytes) {
        for (int i = 0; i < numberOfLongBytes; ++i) {
            array[pos + numberOfLongBytes - i - 1] = (byte)(l >>> i * 8);
        }
    }
}

