/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.issue.tracking;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import org.sonar.core.issue.tracking.BlockHashSequence;
import org.sonar.core.issue.tracking.Input;
import org.sonar.core.issue.tracking.LineHashSequence;
import org.sonar.core.issue.tracking.Trackable;
import org.sonar.core.issue.tracking.Tracking;

class BlockRecognizer<RAW extends Trackable, BASE extends Trackable> {
    BlockRecognizer() {
    }

    void match(Input<RAW> rawInput, Input<BASE> baseInput, Tracking<RAW, BASE> tracking) {
        HashOccurrence hashOccurrence;
        int hash;
        BlockHashSequence rawHashSequence = rawInput.getBlockHashSequence();
        BlockHashSequence baseHashSequence = baseInput.getBlockHashSequence();
        Multimap<Integer, RAW> rawsByLine = BlockRecognizer.groupByLine(tracking.getUnmatchedRaws(), rawHashSequence);
        Multimap<Integer, BASE> basesByLine = BlockRecognizer.groupByLine(tracking.getUnmatchedBases(), baseHashSequence);
        HashMap<Integer, HashOccurrence> occurrencesByHash = new HashMap<Integer, HashOccurrence>();
        for (Integer line : basesByLine.keySet()) {
            hash = baseHashSequence.getBlockHashForLine(line);
            hashOccurrence = (HashOccurrence)occurrencesByHash.get(hash);
            if (hashOccurrence == null) {
                hashOccurrence = new HashOccurrence();
                hashOccurrence.baseLine = line;
                hashOccurrence.baseCount = 1;
                occurrencesByHash.put(hash, hashOccurrence);
                continue;
            }
            ++hashOccurrence.baseCount;
        }
        for (Integer line : rawsByLine.keySet()) {
            hash = rawHashSequence.getBlockHashForLine(line);
            hashOccurrence = (HashOccurrence)occurrencesByHash.get(hash);
            if (hashOccurrence == null) continue;
            hashOccurrence.rawLine = line;
            ++hashOccurrence.rawCount;
        }
        for (HashOccurrence hashOccurrence2 : occurrencesByHash.values()) {
            if (hashOccurrence2.baseCount != 1 || hashOccurrence2.rawCount != 1) continue;
            this.map(rawsByLine.get((Object)hashOccurrence2.rawLine), basesByLine.get((Object)hashOccurrence2.baseLine), tracking);
            basesByLine.removeAll((Object)hashOccurrence2.baseLine);
            rawsByLine.removeAll((Object)hashOccurrence2.rawLine);
        }
        if (basesByLine.keySet().size() * rawsByLine.keySet().size() < 250000) {
            ArrayList possibleLinePairs = Lists.newArrayList();
            for (Integer baseLine : basesByLine.keySet()) {
                for (Integer rawLine : rawsByLine.keySet()) {
                    int weight = BlockRecognizer.lengthOfMaximalBlock(baseInput.getLineHashSequence(), baseLine, rawInput.getLineHashSequence(), rawLine);
                    possibleLinePairs.add(new LinePair(baseLine, rawLine, weight));
                }
            }
            Collections.sort(possibleLinePairs, LinePairComparator.INSTANCE);
            for (LinePair linePair : possibleLinePairs) {
                this.map(rawsByLine.get((Object)linePair.rawLine), basesByLine.get((Object)linePair.baseLine), tracking);
            }
        }
    }

    static int lengthOfMaximalBlock(LineHashSequence hashesA, int startLineA, LineHashSequence hashesB, int startLineB) {
        if (!hashesA.getHashForLine(startLineA).equals(hashesB.getHashForLine(startLineB))) {
            return 0;
        }
        int length = 0;
        int ai = startLineA;
        int bi = startLineB;
        while (ai <= hashesA.length() && bi <= hashesB.length() && hashesA.getHashForLine(ai).equals(hashesB.getHashForLine(bi))) {
            ++ai;
            ++bi;
            ++length;
        }
        ai = startLineA;
        bi = startLineB;
        while (ai > 0 && bi > 0 && hashesA.getHashForLine(ai).equals(hashesB.getHashForLine(bi))) {
            --ai;
            --bi;
            ++length;
        }
        return length - 1;
    }

    private void map(Collection<RAW> raws, Collection<BASE> bases, Tracking<RAW, BASE> result) {
        block0: for (Trackable raw : raws) {
            for (Trackable base : bases) {
                if (!result.containsUnmatchedBase(base) || !base.getRuleKey().equals(raw.getRuleKey())) continue;
                result.match(raw, base);
                continue block0;
            }
        }
    }

    private static <T extends Trackable> Multimap<Integer, T> groupByLine(Iterable<T> trackables, BlockHashSequence hashSequence) {
        LinkedHashMultimap result = LinkedHashMultimap.create();
        for (Trackable trackable : trackables) {
            Integer line = trackable.getLine();
            if (!hashSequence.hasLine(line)) continue;
            result.put((Object)line, (Object)trackable);
        }
        return result;
    }

    private static enum LinePairComparator implements Comparator<LinePair>
    {
        INSTANCE;


        @Override
        public int compare(LinePair o1, LinePair o2) {
            int weightDiff = o2.weight - o1.weight;
            if (weightDiff != 0) {
                return weightDiff;
            }
            return Math.abs(o1.baseLine - o1.rawLine) - Math.abs(o2.baseLine - o2.rawLine);
        }
    }

    private static class HashOccurrence {
        int baseLine;
        int rawLine;
        int baseCount;
        int rawCount;

        private HashOccurrence() {
        }
    }

    private static class LinePair {
        int baseLine;
        int rawLine;
        int weight;

        public LinePair(int baseLine, int rawLine, int weight) {
            this.baseLine = baseLine;
            this.rawLine = rawLine;
            this.weight = weight;
        }
    }
}

