/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.protocol.viewer;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.Scanner;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.sonar.batch.protocol.output.BatchReport;
import org.sonar.batch.protocol.output.BatchReportReader;
import org.sonar.batch.protocol.output.FileStructure;
import org.sonar.batch.protocol.viewer.TextLineNumber;
import org.sonar.core.util.CloseableIterator;

public class ViewerApplication {
    private JFrame frame;
    private BatchReportReader reader;
    private BatchReport.Metadata metadata;
    private SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
    private JTree componentTree;
    private JSplitPane splitPane;
    private JTabbedPane tabbedPane;
    private JScrollPane treeScrollPane;
    private JScrollPane componentDetailsTab;
    private JScrollPane highlightingTab;
    private JEditorPane componentEditor;
    private JEditorPane highlightingEditor;
    private JScrollPane sourceTab;
    private JEditorPane sourceEditor;
    private JScrollPane coverageTab;
    private JEditorPane coverageEditor;
    private TextLineNumber textLineNumber;
    private JScrollPane duplicationTab;
    private JEditorPane duplicationEditor;

    public ViewerApplication() {
        this.initialize();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    ViewerApplication window = new ViewerApplication();
                    window.frame.setVisible(true);
                    window.loadReport();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void loadReport() {
        JFileChooser fc = new JFileChooser();
        fc.setDialogTitle("Choose scanner report directory");
        fc.setFileSelectionMode(1);
        fc.setFileHidingEnabled(false);
        fc.setApproveButtonText("Open scanner report");
        int returnVal = fc.showOpenDialog(this.frame);
        if (returnVal == 0) {
            File file = fc.getSelectedFile();
            try {
                this.loadReport(file);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this.frame, e.getMessage(), "Error", 0);
                this.exit();
            }
        } else {
            this.exit();
        }
    }

    private void exit() {
        this.frame.setVisible(false);
        this.frame.dispose();
    }

    private void loadReport(File file) {
        this.reader = new BatchReportReader(file);
        this.metadata = this.reader.readMetadata();
        this.updateTitle();
        this.loadComponents();
    }

    private void loadComponents() {
        int rootComponentRef = this.metadata.getRootComponentRef();
        BatchReport.Component component = this.reader.readComponent(rootComponentRef);
        DefaultMutableTreeNode project = ViewerApplication.createNode(component);
        this.loadChildren(component, project);
        this.getComponentTree().setModel(new DefaultTreeModel(project));
    }

    private static DefaultMutableTreeNode createNode(BatchReport.Component component) {
        return new DefaultMutableTreeNode(component){

            @Override
            public String toString() {
                return ViewerApplication.getNodeName((BatchReport.Component)this.getUserObject());
            }
        };
    }

    private static String getNodeName(BatchReport.Component component) {
        switch (component.getType()) {
            case PROJECT: 
            case MODULE: {
                return component.getName();
            }
            case DIRECTORY: 
            case FILE: {
                return component.getPath();
            }
        }
        throw new IllegalArgumentException("Unknow component type: " + component.getType());
    }

    private void loadChildren(BatchReport.Component parentComponent, DefaultMutableTreeNode parentNode) {
        for (int ref : parentComponent.getChildRefList()) {
            BatchReport.Component child = this.reader.readComponent(ref);
            DefaultMutableTreeNode childNode = ViewerApplication.createNode(child);
            parentNode.add(childNode);
            this.loadChildren(child, childNode);
        }
    }

    private void updateTitle() {
        this.frame.setTitle(this.metadata.getProjectKey() + (this.metadata.hasBranch() ? " (" + this.metadata.getBranch() + ")" : "") + " " + this.sdf.format(new Date(this.metadata.getAnalysisDate())));
    }

    private void updateDetails(BatchReport.Component component) {
        this.componentEditor.setText(component.toString());
        this.updateHighlighting(component);
        this.updateSource(component);
        this.updateCoverage(component);
        this.updateDuplications(component);
    }

    private void updateDuplications(BatchReport.Component component) {
        this.duplicationEditor.setText("");
        if (this.reader.hasCoverage(component.getRef())) {
            try (CloseableIterator<BatchReport.Duplication> it = this.reader.readComponentDuplications(component.getRef());){
                while (it.hasNext()) {
                    BatchReport.Duplication dup = it.next();
                    this.duplicationEditor.getDocument().insertString(this.duplicationEditor.getDocument().getEndPosition().getOffset(), dup.toString() + "\n", null);
                }
            }
            catch (Exception e) {
                throw new IllegalStateException("Can't read duplications for " + ViewerApplication.getNodeName(component), e);
            }
        }
    }

    private void updateCoverage(BatchReport.Component component) {
        this.coverageEditor.setText("");
        try (CloseableIterator<BatchReport.Coverage> it = this.reader.readComponentCoverage(component.getRef());){
            while (it.hasNext()) {
                BatchReport.Coverage coverage = it.next();
                this.coverageEditor.getDocument().insertString(this.coverageEditor.getDocument().getEndPosition().getOffset(), coverage.toString() + "\n", null);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Can't read code coverage for " + ViewerApplication.getNodeName(component), e);
        }
    }

    private void updateSource(BatchReport.Component component) {
        File sourceFile = this.reader.getFileStructure().fileFor(FileStructure.Domain.SOURCE, component.getRef());
        this.sourceEditor.setText("");
        if (sourceFile.exists()) {
            try (Scanner s = new Scanner(sourceFile, StandardCharsets.UTF_8.name()).useDelimiter("\\Z");){
                if (s.hasNext()) {
                    this.sourceEditor.setText(s.next());
                }
            }
            catch (IOException ex) {
                StringWriter errors = new StringWriter();
                ex.printStackTrace(new PrintWriter(errors));
                this.sourceEditor.setText(errors.toString());
            }
        }
    }

    private void updateHighlighting(BatchReport.Component component) {
        this.highlightingEditor.setText("");
        try (CloseableIterator<BatchReport.SyntaxHighlighting> it = this.reader.readComponentSyntaxHighlighting(component.getRef());){
            while (it.hasNext()) {
                BatchReport.SyntaxHighlighting rule = it.next();
                this.highlightingEditor.getDocument().insertString(this.highlightingEditor.getDocument().getEndPosition().getOffset(), rule.toString() + "\n", null);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Can't read syntax highlighting for " + ViewerApplication.getNodeName(component), e);
        }
    }

    private void initialize() {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.frame = new JFrame();
        this.frame.setDefaultCloseOperation(3);
        this.splitPane = new JSplitPane();
        this.frame.getContentPane().add((Component)this.splitPane, "Center");
        this.tabbedPane = new JTabbedPane(1);
        this.tabbedPane.setPreferredSize(new Dimension(500, 7));
        this.splitPane.setRightComponent(this.tabbedPane);
        this.componentDetailsTab = new JScrollPane();
        this.tabbedPane.addTab("Component details", null, this.componentDetailsTab, null);
        this.componentEditor = new JEditorPane();
        this.componentDetailsTab.setViewportView(this.componentEditor);
        this.sourceTab = new JScrollPane();
        this.tabbedPane.addTab("Source", null, this.sourceTab, null);
        this.sourceEditor = ViewerApplication.createSourceEditor();
        this.sourceEditor.setEditable(false);
        this.sourceTab.setViewportView(this.sourceEditor);
        this.textLineNumber = this.createTextLineNumber();
        this.sourceTab.setRowHeaderView(this.textLineNumber);
        this.highlightingTab = new JScrollPane();
        this.tabbedPane.addTab("Highlighting", null, this.highlightingTab, null);
        this.highlightingEditor = new JEditorPane();
        this.highlightingTab.setViewportView(this.highlightingEditor);
        this.coverageTab = new JScrollPane();
        this.tabbedPane.addTab("Coverage", null, this.coverageTab, null);
        this.coverageEditor = new JEditorPane();
        this.coverageTab.setViewportView(this.coverageEditor);
        this.duplicationTab = new JScrollPane();
        this.tabbedPane.addTab("Duplications", null, this.duplicationTab, null);
        this.duplicationEditor = new JEditorPane();
        this.duplicationTab.setViewportView(this.duplicationEditor);
        this.treeScrollPane = new JScrollPane();
        this.treeScrollPane.setPreferredSize(new Dimension(200, 400));
        this.splitPane.setLeftComponent(this.treeScrollPane);
        this.componentTree = new JTree();
        this.componentTree.setModel(new DefaultTreeModel(new DefaultMutableTreeNode("empty"){}));
        this.treeScrollPane.setViewportView(this.componentTree);
        this.componentTree.getSelectionModel().setSelectionMode(1);
        this.componentTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)ViewerApplication.this.componentTree.getLastSelectedPathComponent();
                if (node == null) {
                    return;
                }
                ViewerApplication.this.frame.setCursor(new Cursor(3));
                ViewerApplication.this.updateDetails((BatchReport.Component)node.getUserObject());
                ViewerApplication.this.frame.setCursor(new Cursor(0));
            }
        });
        this.frame.pack();
    }

    public JTree getComponentTree() {
        return this.componentTree;
    }

    public static JPanel createComponentPanel() {
        JPanel panel = new JPanel();
        return panel;
    }

    protected JEditorPane getComponentEditor() {
        return this.componentEditor;
    }

    public static JEditorPane createSourceEditor() {
        JEditorPane editorPane = new JEditorPane();
        return editorPane;
    }

    public TextLineNumber createTextLineNumber() {
        TextLineNumber textLineNumber = new TextLineNumber(this.sourceEditor);
        return textLineNumber;
    }
}

