/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.util;

import com.google.common.annotations.VisibleForTesting;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.security.SecureRandom;
import java.util.Enumeration;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;

class MacAddressProvider {
    private static final Logger LOGGER = Loggers.get(MacAddressProvider.class);
    public static final int BYTE_SIZE = 6;

    private MacAddressProvider() {
    }

    public static byte[] getSecureMungedAddress() {
        byte[] address = null;
        try {
            address = MacAddressProvider.getMacAddress();
        }
        catch (SocketException se) {
            LOGGER.warn("Unable to get mac address, will use a dummy address", se);
        }
        if (!MacAddressProvider.isValidAddress(address)) {
            LOGGER.warn("Unable to get a valid mac address, will use a dummy address");
            address = MacAddressProvider.constructDummyMulticastAddress();
        }
        byte[] mungedBytes = new byte[6];
        new SecureRandom().nextBytes(mungedBytes);
        for (int i = 0; i < 6; ++i) {
            int n = i;
            mungedBytes[n] = (byte)(mungedBytes[n] ^ address[i]);
        }
        return mungedBytes;
    }

    private static boolean isValidAddress(@Nullable byte[] address) {
        if (address == null || address.length != 6) {
            return false;
        }
        for (byte b : address) {
            if (b == 0) continue;
            return true;
        }
        return false;
    }

    @CheckForNull
    private static byte[] getMacAddress() throws SocketException {
        Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
        if (en != null) {
            while (en.hasMoreElements()) {
                byte[] address;
                NetworkInterface nint = en.nextElement();
                if (nint.isLoopback() || !MacAddressProvider.isValidAddress(address = nint.getHardwareAddress())) continue;
                return address;
            }
        }
        return null;
    }

    @VisibleForTesting
    static byte[] constructDummyMulticastAddress() {
        byte[] dummy = new byte[6];
        new SecureRandom().nextBytes(dummy);
        dummy[0] = (byte)(dummy[0] | 1);
        return dummy;
    }
}

