/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.issue.workflow;

import java.util.List;
import org.picocontainer.Startable;
import org.sonar.api.issue.Issue;
import org.sonar.api.issue.condition.HasResolution;
import org.sonar.api.issue.condition.NotCondition;
import org.sonar.api.server.ServerSide;
import org.sonar.core.issue.DefaultIssue;
import org.sonar.core.issue.IssueChangeContext;
import org.sonar.core.issue.IssueUpdater;
import org.sonar.core.issue.workflow.FunctionExecutor;
import org.sonar.core.issue.workflow.IsBeingClosed;
import org.sonar.core.issue.workflow.IsManual;
import org.sonar.core.issue.workflow.OrCondition;
import org.sonar.core.issue.workflow.SetCloseDate;
import org.sonar.core.issue.workflow.SetClosed;
import org.sonar.core.issue.workflow.SetResolution;
import org.sonar.core.issue.workflow.State;
import org.sonar.core.issue.workflow.StateMachine;
import org.sonar.core.issue.workflow.Transition;
import org.sonar.core.issue.workflow.UnsetAssignee;

@ServerSide
public class IssueWorkflow
implements Startable {
    private final FunctionExecutor functionExecutor;
    private final IssueUpdater updater;
    private StateMachine machine;

    public IssueWorkflow(FunctionExecutor functionExecutor, IssueUpdater updater) {
        this.functionExecutor = functionExecutor;
        this.updater = updater;
    }

    @Override
    public void start() {
        StateMachine.Builder builder = StateMachine.builder().states("OPEN", "CONFIRMED", "REOPENED", "RESOLVED", "CLOSED");
        this.buildManualTransitions(builder);
        this.buildAutomaticTransitions(builder);
        this.machine = builder.build();
    }

    private void buildManualTransitions(StateMachine.Builder builder) {
        builder.transition(Transition.builder("confirm").from("OPEN").to("CONFIRMED").functions(new SetResolution(null)).build()).transition(Transition.builder("confirm").from("REOPENED").to("CONFIRMED").functions(new SetResolution(null)).build()).transition(Transition.builder("unconfirm").from("CONFIRMED").to("REOPENED").functions(new SetResolution(null)).build()).transition(Transition.builder("resolve").from("OPEN").to("RESOLVED").functions(new SetResolution("FIXED")).build()).transition(Transition.builder("resolve").from("REOPENED").to("RESOLVED").functions(new SetResolution("FIXED")).build()).transition(Transition.builder("resolve").from("CONFIRMED").to("RESOLVED").functions(new SetResolution("FIXED")).build()).transition(Transition.builder("reopen").from("RESOLVED").to("REOPENED").functions(new SetResolution(null)).build()).transition(Transition.builder("reopen").conditions(IsManual.INSTANCE).from("CLOSED").to("REOPENED").functions(new SetResolution(null), new SetCloseDate(false)).build()).transition(Transition.builder("falsepositive").from("OPEN").to("RESOLVED").functions(new SetResolution("FALSE-POSITIVE"), UnsetAssignee.INSTANCE).requiredProjectPermission("issueadmin").build()).transition(Transition.builder("falsepositive").from("REOPENED").to("RESOLVED").functions(new SetResolution("FALSE-POSITIVE"), UnsetAssignee.INSTANCE).requiredProjectPermission("issueadmin").build()).transition(Transition.builder("falsepositive").from("CONFIRMED").to("RESOLVED").functions(new SetResolution("FALSE-POSITIVE"), UnsetAssignee.INSTANCE).requiredProjectPermission("issueadmin").build()).transition(Transition.builder("wontfix").from("OPEN").to("RESOLVED").functions(new SetResolution("WONTFIX"), UnsetAssignee.INSTANCE).requiredProjectPermission("issueadmin").build()).transition(Transition.builder("wontfix").from("REOPENED").to("RESOLVED").functions(new SetResolution("WONTFIX"), UnsetAssignee.INSTANCE).requiredProjectPermission("issueadmin").build()).transition(Transition.builder("wontfix").from("CONFIRMED").to("RESOLVED").functions(new SetResolution("WONTFIX"), UnsetAssignee.INSTANCE).requiredProjectPermission("issueadmin").build());
    }

    private void buildAutomaticTransitions(StateMachine.Builder builder) {
        builder.transition(Transition.builder("automaticclose").from("OPEN").to("CLOSED").conditions(IsBeingClosed.INSTANCE).functions(SetClosed.INSTANCE, new SetCloseDate(true)).automatic().build()).transition(Transition.builder("automaticclose").from("REOPENED").to("CLOSED").conditions(IsBeingClosed.INSTANCE).functions(SetClosed.INSTANCE, new SetCloseDate(true)).automatic().build()).transition(Transition.builder("automaticclose").from("CONFIRMED").to("CLOSED").conditions(IsBeingClosed.INSTANCE).functions(SetClosed.INSTANCE, new SetCloseDate(true)).automatic().build()).transition(Transition.builder("automaticclose").from("RESOLVED").to("CLOSED").conditions(new OrCondition(IsBeingClosed.INSTANCE, IsManual.INSTANCE)).functions(SetClosed.INSTANCE, new SetCloseDate(true)).automatic().build()).transition(Transition.builder("automaticreopen").from("RESOLVED").to("REOPENED").conditions(new NotCondition(IsBeingClosed.INSTANCE), new HasResolution("FIXED", new String[0]), new NotCondition(IsManual.INSTANCE)).functions(new SetResolution(null), new SetCloseDate(false)).automatic().build());
    }

    @Override
    public void stop() {
    }

    public boolean doTransition(DefaultIssue issue, String transitionKey, IssueChangeContext issueChangeContext) {
        Transition transition = this.stateOf(issue).transition(transitionKey);
        if (transition != null && !transition.automatic()) {
            this.functionExecutor.execute(transition.functions(), issue, issueChangeContext);
            this.updater.setStatus(issue, transition.to(), issueChangeContext);
            return true;
        }
        return false;
    }

    public List<Transition> outTransitions(Issue issue) {
        State state = this.machine.state(issue.status());
        if (state == null) {
            throw new IllegalArgumentException("Unknown status: " + issue.status());
        }
        return state.outManualTransitions(issue);
    }

    public void doAutomaticTransition(DefaultIssue issue, IssueChangeContext issueChangeContext) {
        Transition transition = this.stateOf(issue).outAutomaticTransition(issue);
        if (transition != null) {
            this.functionExecutor.execute(transition.functions(), issue, issueChangeContext);
            this.updater.setStatus(issue, transition.to(), issueChangeContext);
        }
    }

    public List<String> statusKeys() {
        return this.machine.stateKeys();
    }

    private State stateOf(DefaultIssue issue) {
        State state = this.machine.state(issue.status());
        if (state == null) {
            throw new IllegalStateException("Unknown status: " + issue.status() + " [issue=" + issue.key() + "]");
        }
        return state;
    }

    StateMachine machine() {
        return this.machine;
    }
}

