/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.config;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.sonar.api.PropertyType;
import org.sonar.api.config.PropertyDefinition;
import org.sonar.core.config.DebtProperties;
import org.sonar.core.config.ExclusionProperties;
import org.sonar.core.config.IssueExclusionProperties;
import org.sonar.core.config.PurgeProperties;
import org.sonar.core.config.SecurityProperties;

public class CorePropertyDefinitions {
    public static final String TIMEMACHINE_PERIOD_PREFIX = "sonar.timemachine.period";
    public static final String TIMEMACHINE_MODE_PREVIOUS_ANALYSIS = "previous_analysis";
    public static final String TIMEMACHINE_MODE_DATE = "date";
    public static final String TIMEMACHINE_MODE_VERSION = "version";
    public static final String TIMEMACHINE_MODE_DAYS = "days";
    public static final String TIMEMACHINE_MODE_PREVIOUS_VERSION = "previous_version";
    private static final String TIMEMACHINE_DEFAULT_PERIOD_1 = "previous_version";
    private static final String TIMEMACHINE_DEFAULT_PERIOD_2 = "previous_analysis";
    private static final String TIMEMACHINE_DEFAULT_PERIOD_3 = "30";
    private static final String TIMEMACHINE_DEFAULT_PERIOD_4 = "";
    private static final String TIMEMACHINE_DEFAULT_PERIOD_5 = "";

    private CorePropertyDefinitions() {
    }

    public static List<PropertyDefinition> all() {
        ArrayList defs = Lists.newArrayList();
        defs.addAll(IssueExclusionProperties.all());
        defs.addAll(ExclusionProperties.all());
        defs.addAll(SecurityProperties.all());
        defs.addAll(DebtProperties.all());
        defs.addAll(PurgeProperties.all());
        defs.addAll(ImmutableList.of((Object)PropertyDefinition.builder("sonar.core.serverBaseURL").name("Server base URL").description("HTTP URL of this SonarQube server, such as <i>http://yourhost.yourdomain/sonar</i>. This value is used i.e. to create links in emails.").category("general").defaultValue("http://localhost:9000").build(), (Object)PropertyDefinition.builder("sonar.links.homepage").name("Project Home Page").description("HTTP URL of the home page of the project.").hidden().build(), (Object)PropertyDefinition.builder("sonar.links.ci").name("CI server").description("HTTP URL of the continuous integration server.").category("general").build(), (Object)PropertyDefinition.builder("sonar.links.issue").name("Issue Tracker").description("HTTP URL of the issue tracker.").category("general").hidden().build(), (Object)PropertyDefinition.builder("sonar.links.scm").name("SCM server").description("HTTP URL of the server which hosts the sources of the project.").category("general").build(), (Object)PropertyDefinition.builder("sonar.links.scm_dev").name("SCM connection for developers").description("HTTP URL used by developers to connect to the SCM server for the project.").category("general").hidden().build(), (Object)PropertyDefinition.builder("sonar.analysis.mode").name("Analysis mode").type(PropertyType.SINGLE_SELECT_LIST).options(Arrays.asList("analysis", "preview", "incremental")).category("general").defaultValue("analysis").hidden().build(), (Object)PropertyDefinition.builder("sonar.preview.includePlugins").name("Plugins accepted for Preview mode").description("Comma-separated list of plugin keys. Those plugins will be used during preview analyses.").category("general").defaultValue("").build(), (Object)PropertyDefinition.builder("sonar.preview.excludePlugins").name("Plugins excluded for Preview mode").description("Comma-separated list of plugin keys. Those plugins will not be used during preview analyses.").category("general").defaultValue("buildstability,devcockpit,pdfreport,report,views,jira,buildbreaker,scmstats").build(), (Object)PropertyDefinition.builder("sonar.security.realm").name("Security Realm").hidden().build(), (Object)PropertyDefinition.builder("sonar.security.savePassword").name("Save external password").hidden().build(), (Object)PropertyDefinition.builder("sonar.authenticator.downcase").name("Downcase login").description("Downcase login during user authentication, typically for Active Directory").type(PropertyType.BOOLEAN).defaultValue(String.valueOf(false)).hidden().build(), (Object[])new PropertyDefinition[]{PropertyDefinition.builder("sonar.authenticator.createUsers").name("Create user accounts").description("Create accounts when authenticating users via an external system").type(PropertyType.BOOLEAN).defaultValue(String.valueOf(true)).hidden().build(), PropertyDefinition.builder("sonar.authenticator.ignoreStartupFailure").name("Ignore failures during authenticator startup").type(PropertyType.BOOLEAN).defaultValue(String.valueOf(false)).hidden().build(), PropertyDefinition.builder("sonar.enableFileVariation").name("Enable file variation").hidden().type(PropertyType.BOOLEAN).defaultValue(String.valueOf(false)).build(), PropertyDefinition.builder("sonar.security.localUsers").name("Local/technical users").description("Comma separated list of user logins that will always be authenticated using SonarQube database. When using the LDAP plugin, for these accounts, the user attributes (name, email, ...) are not re-synchronized").type(PropertyType.STRING).multiValues(true).defaultValue("admin").build(), PropertyDefinition.builder("sonar.scm.disabled").name("Disable the SCM Sensor").description("Disable the retrieval of blame information from Source Control Manager").category("scm").type(PropertyType.BOOLEAN).onQualifiers("TRK", new String[0]).defaultValue(String.valueOf(false)).build(), PropertyDefinition.builder("sonar.scm.provider").name("Key of the SCM provider for this project").description("Force the provider to be used to get SCM information for this project. By default auto-detection is done. Example: svn, git.").category("scm").onlyOnQualifiers("TRK", new String[0]).build(), PropertyDefinition.builder("sonar.lf.logoUrl").deprecatedKey("sonar.branding.image").name("Logo URL").description("URL to logo image. Any standard format is accepted.").category("general").subCategory("looknfeel").build(), PropertyDefinition.builder("sonar.lf.logoWidthPx").deprecatedKey("sonar.branding.image.width").name("Width of image in pixels").description("Width in pixels, given that the height of the the image is constrained to 30px").category("general").subCategory("looknfeel").build(), PropertyDefinition.builder("sonar.lf.enableGravatar").name("Enable support of gravatars").description("Gravatars are profile pictures of users based on their email.").type(PropertyType.BOOLEAN).defaultValue(String.valueOf(true)).category("general").subCategory("looknfeel").build(), PropertyDefinition.builder("sonar.lf.gravatarServerUrl").name("Gravatar URL").description("Optional URL of custom Gravatar service. Accepted variables are {EMAIL_MD5} for MD5 hash of email and {SIZE} for the picture size in pixels.").defaultValue("https://secure.gravatar.com/avatar/{EMAIL_MD5}.jpg?s={SIZE}&d=identicon").category("general").subCategory("looknfeel").build(), PropertyDefinition.builder("sonar.issues.defaultAssigneeLogin").name("Default Assignee").description("New issues will be assigned to this user each time it is not possible to determine the user who is the author of the issue.").category("general").subCategory("issues").onQualifiers("TRK", new String[0]).type(PropertyType.USER_LOGIN).build(), PropertyDefinition.builder("sonar.violationLocale").defaultValue("en").name("Locale used for issue messages").description("Deprecated property. Keep default value for backward compatibility.").hidden().build(), PropertyDefinition.builder("sonar.timemachine.period1").name("Leak Period").description("Period used to compare measures and track new issues. Values are : <ul class='bullet'><li>Number of days before analysis, for example 5.</li><li>A custom date. Format is yyyy-MM-dd, for example 2010-12-25</li><li>'previous_analysis' to compare to previous analysis</li><li>'previous_version' to compare to the previous version in the project history</li><li>A version, for example '1.2' or 'BASELINE'</li></ul><p>When specifying a number of days or a date, the snapshot selected for comparison is  the first one available inside the corresponding time range. </p><p>Changing this property only takes effect after subsequent project inspections.<p/>").defaultValue("previous_version").category("general").subCategory("differentialViews").onQualifiers("TRK", "VW").build(), PropertyDefinition.builder("sonar.timemachine.period2").name("Period 2").description("See the property 'Leak Period'").defaultValue("previous_analysis").category("general").subCategory("differentialViews").build(), PropertyDefinition.builder("sonar.timemachine.period3").name("Period 3").description("See the property 'Leak Period'").defaultValue(TIMEMACHINE_DEFAULT_PERIOD_3).category("general").subCategory("differentialViews").build(), PropertyDefinition.builder("sonar.timemachine.period4").name("Period 4").description("Period used to compare measures and track new issues. This property is specific to the project. Values are : <ul class='bullet'><li>Number of days before analysis, for example 5.</li><li>A custom date. Format is yyyy-MM-dd, for example 2010-12-25</li><li>'previous_analysis' to compare to previous analysis</li><li>'previous_version' to compare to the previous version in the project history</li><li>A version, for example '1.2' or 'BASELINE'</li></ul><p>When specifying a number of days or a date, the snapshot selected for comparison is the first one available inside the corresponding time range. </p><p>Changing this property only takes effect after subsequent project inspections.<p/>").defaultValue("").onlyOnQualifiers("TRK", new String[0]).category("general").subCategory("differentialViews").build(), PropertyDefinition.builder("sonar.timemachine.period5").name("Period 5").description("See the property 'Period 4'").defaultValue("").onlyOnQualifiers("TRK", new String[0]).category("general").subCategory("differentialViews").build(), PropertyDefinition.builder("sonar.cpd.cross_project").defaultValue(Boolean.toString(false)).name("Cross project duplication detection").description("By default, SonarQube detects duplications at sub-project level. This means that a block duplicated on two sub-projects of the same project won't be reported. Setting this parameter to \"true\" allows to detect duplicates across sub-projects and more generally across projects. Note that activating this property will slightly increase each SonarQube analysis time.").onQualifiers("TRK", new String[0]).category("general").subCategory("duplications").type(PropertyType.BOOLEAN).build(), PropertyDefinition.builder("sonar.cpd.exclusions").defaultValue("").name("Duplication Exclusions").description("Patterns used to exclude some source files from the duplication detection mechanism. See below to know how to use wildcards to specify this property.").onQualifiers("TRK", "BRC").category("exclusions").subCategory("duplications").multiValues(true).build()}));
        return defs;
    }
}

