/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.graph;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.sonar.graph.Cycle;
import org.sonar.graph.Edge;
import org.sonar.graph.FeedbackCycle;
import org.sonar.graph.FeedbackEdge;

public class MinimumFeedbackEdgeSetSolver {
    private final List<FeedbackCycle> feedbackCycles;
    private Set<FeedbackEdge> feedbackEdges;
    private int minimumFeedbackEdgesWeight = Integer.MAX_VALUE;
    private final int cyclesNumber;
    private final int maxNumberCyclesForSearchingMinimumFeedback;
    private static final int DEFAULT_MAXIMUM_NUMBER_OF_LOOPS = 1000000;
    private static final int MAXIMUM_NUMBER_OF_CYCLE_THAT_CAN_BE_HANDLED = 1500;
    private final int maximumNumberOfLoops;
    private int numberOfLoops = 0;

    public int getNumberOfLoops() {
        return this.numberOfLoops;
    }

    public MinimumFeedbackEdgeSetSolver(Set<Cycle> cycles, int maxCycles) {
        this(cycles, 1000000, maxCycles);
    }

    public MinimumFeedbackEdgeSetSolver(Set<Cycle> cycles) {
        this(cycles, 1000000, 1500);
    }

    public MinimumFeedbackEdgeSetSolver(Set<Cycle> cycles, int maximumNumberOfLoops, int maxNumberCyclesForSearchingMinimumFeedback) {
        this.maximumNumberOfLoops = maximumNumberOfLoops;
        this.feedbackCycles = FeedbackCycle.buildFeedbackCycles(cycles);
        this.cyclesNumber = cycles.size();
        this.maxNumberCyclesForSearchingMinimumFeedback = maxNumberCyclesForSearchingMinimumFeedback;
        this.run();
    }

    public int getWeightOfFeedbackEdgeSet() {
        return this.minimumFeedbackEdgesWeight;
    }

    public Set<Edge> getEdges() {
        LinkedHashSet<Edge> edges = new LinkedHashSet<Edge>();
        for (FeedbackEdge fe : this.feedbackEdges) {
            edges.add(fe.getEdge());
        }
        return edges;
    }

    private void run() {
        LinkedHashSet<FeedbackEdge> pendingFeedbackEdges = new LinkedHashSet<FeedbackEdge>();
        if (this.cyclesNumber < this.maxNumberCyclesForSearchingMinimumFeedback) {
            this.searchFeedbackEdges(0, 0, pendingFeedbackEdges);
        } else {
            this.lightResearchForFeedbackEdges();
        }
    }

    private void lightResearchForFeedbackEdges() {
        this.feedbackEdges = new LinkedHashSet<FeedbackEdge>();
        for (FeedbackCycle cycle : this.feedbackCycles) {
            Iterator<FeedbackEdge> i$ = cycle.iterator();
            if (!i$.hasNext()) continue;
            FeedbackEdge edge = i$.next();
            this.feedbackEdges.add(edge);
        }
        this.minimumFeedbackEdgesWeight = 0;
        for (FeedbackEdge edge : this.feedbackEdges) {
            this.minimumFeedbackEdgesWeight += edge.getWeight();
        }
    }

    private void searchFeedbackEdges(int level, int pendingWeight, Set<FeedbackEdge> pendingFeedbackEdges) {
        if (this.numberOfLoops++ > this.maximumNumberOfLoops) {
            return;
        }
        if (pendingWeight >= this.minimumFeedbackEdgesWeight) {
            return;
        }
        if (level == this.cyclesNumber) {
            this.minimumFeedbackEdgesWeight = pendingWeight;
            this.feedbackEdges = new LinkedHashSet<FeedbackEdge>(pendingFeedbackEdges);
            return;
        }
        FeedbackCycle feedbackCycle = this.feedbackCycles.get(level);
        if (this.doesFeedbackEdgesContainAnEdgeOfTheCycle(pendingFeedbackEdges, feedbackCycle)) {
            this.searchFeedbackEdges(level + 1, pendingWeight, pendingFeedbackEdges);
        } else {
            boolean hasAnEdgeWithOccurrenceOfOneBeenUsed = false;
            for (FeedbackEdge feedbackEdge : feedbackCycle) {
                if (feedbackEdge.getOccurences() == 1) {
                    if (hasAnEdgeWithOccurrenceOfOneBeenUsed) continue;
                    hasAnEdgeWithOccurrenceOfOneBeenUsed = true;
                }
                int edgeWeight = this.addNewEdge(feedbackEdge, pendingFeedbackEdges);
                this.searchFeedbackEdges(level + 1, pendingWeight += edgeWeight, pendingFeedbackEdges);
                pendingWeight -= edgeWeight;
                pendingFeedbackEdges.remove(feedbackEdge);
            }
        }
    }

    private boolean doesFeedbackEdgesContainAnEdgeOfTheCycle(Set<FeedbackEdge> pendingFeedbackEdges, FeedbackCycle cycle) {
        boolean contains = false;
        for (FeedbackEdge feedbackEdge : cycle) {
            if (!pendingFeedbackEdges.contains(feedbackEdge)) continue;
            contains = true;
            break;
        }
        return contains;
    }

    private int addNewEdge(FeedbackEdge feedbackEdge, Set<FeedbackEdge> pendingFeedbackEdges) {
        pendingFeedbackEdges.add(feedbackEdge);
        return feedbackEdge.getWeight();
    }
}

