/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.issue.tracking;

import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.FluentIterable;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.batch.BatchSide;
import org.sonar.api.batch.InstantiationStrategy;
import org.sonar.api.rule.RuleKey;
import org.sonar.core.issue.tracking.BlockRecognizer;
import org.sonar.core.issue.tracking.Input;
import org.sonar.core.issue.tracking.Trackable;
import org.sonar.core.issue.tracking.Tracking;

@InstantiationStrategy(value="PER_BATCH")
@BatchSide
public class Tracker<RAW extends Trackable, BASE extends Trackable> {
    public Tracking<RAW, BASE> track(Input<RAW> rawInput, Input<BASE> baseInput) {
        Tracking<RAW, BASE> tracking = new Tracking<RAW, BASE>(rawInput, baseInput);
        this.relocateManualIssues(rawInput, baseInput, tracking);
        this.match(tracking, LineAndLineHashKeyFactory.INSTANCE);
        this.detectCodeMoves(rawInput, baseInput, tracking);
        this.match(tracking, LineHashAndMessageKeyFactory.INSTANCE);
        this.match(tracking, LineAndMessageKeyFactory.INSTANCE);
        this.match(tracking, LineHashKeyFactory.INSTANCE);
        return tracking;
    }

    private void detectCodeMoves(Input<RAW> rawInput, Input<BASE> baseInput, Tracking<RAW, BASE> tracking) {
        if (!tracking.isComplete()) {
            new BlockRecognizer<RAW, BASE>().match(rawInput, baseInput, tracking);
        }
    }

    private void match(Tracking<RAW, BASE> tracking, SearchKeyFactory factory) {
        if (tracking.isComplete()) {
            return;
        }
        ArrayListMultimap baseSearch = ArrayListMultimap.create();
        for (Trackable base : tracking.getUnmatchedBases()) {
            baseSearch.put((Object)factory.create(base), (Object)base);
        }
        for (Trackable raw : tracking.getUnmatchedRaws()) {
            SearchKey rawKey = factory.create(raw);
            Collection bases = baseSearch.get((Object)rawKey);
            if (bases.isEmpty()) continue;
            Trackable match = (Trackable)bases.iterator().next();
            tracking.match(raw, match);
            baseSearch.remove((Object)rawKey, (Object)match);
        }
    }

    private void relocateManualIssues(Input<RAW> rawInput, Input<BASE> baseInput, Tracking<RAW, BASE> tracking) {
        FluentIterable manualIssues = FluentIterable.from(tracking.getUnmatchedBases()).filter((Predicate)IsManual.INSTANCE);
        for (Trackable base : manualIssues) {
            if (base.getLine() == null) {
                tracking.keepManualIssueOpen(base, null);
                continue;
            }
            String baseHash = base.getLineHash();
            if (Strings.isNullOrEmpty((String)baseHash)) {
                baseHash = baseInput.getLineHashSequence().getHashForLine(base.getLine());
            }
            if (Strings.isNullOrEmpty((String)baseHash)) continue;
            Set<Integer> rawLines = rawInput.getLineHashSequence().getLinesForHash(baseHash);
            if (rawLines.size() == 1) {
                tracking.keepManualIssueOpen(base, rawLines.iterator().next());
                continue;
            }
            if (!rawLines.isEmpty() || !rawInput.getLineHashSequence().hasLine(base.getLine())) continue;
            tracking.keepManualIssueOpen(base, base.getLine());
        }
    }

    private static enum LineHashKeyFactory implements SearchKeyFactory
    {
        INSTANCE;


        @Override
        public SearchKey create(Trackable t) {
            return new LineHashKey(t);
        }
    }

    private static class LineHashKey
    implements SearchKey {
        private final RuleKey ruleKey;
        private final String lineHash;

        LineHashKey(Trackable trackable) {
            this.ruleKey = trackable.getRuleKey();
            this.lineHash = StringUtils.defaultString(trackable.getLineHash(), "");
        }

        public boolean equals(@Nonnull Object o) {
            if (this == o) {
                return true;
            }
            LineHashKey that = (LineHashKey)o;
            return this.lineHash.equals(that.lineHash) && this.ruleKey.equals(that.ruleKey);
        }

        public int hashCode() {
            int result = this.ruleKey.hashCode();
            result = 31 * result + this.lineHash.hashCode();
            return result;
        }
    }

    private static enum LineAndMessageKeyFactory implements SearchKeyFactory
    {
        INSTANCE;


        @Override
        public SearchKey create(Trackable t) {
            return new LineAndMessageKey(t);
        }
    }

    private static class LineAndMessageKey
    implements SearchKey {
        private final RuleKey ruleKey;
        private final String message;
        private final Integer line;

        LineAndMessageKey(Trackable trackable) {
            this.ruleKey = trackable.getRuleKey();
            this.message = trackable.getMessage();
            this.line = trackable.getLine();
        }

        public boolean equals(@Nonnull Object o) {
            if (this == o) {
                return true;
            }
            LineAndMessageKey that = (LineAndMessageKey)o;
            return Objects.equals(this.line, that.line) && this.message.equals(that.message) && this.ruleKey.equals(that.ruleKey);
        }

        public int hashCode() {
            int result = this.ruleKey.hashCode();
            result = 31 * result + this.message.hashCode();
            result = 31 * result + (this.line != null ? this.line.hashCode() : 0);
            return result;
        }
    }

    private static enum LineHashAndMessageKeyFactory implements SearchKeyFactory
    {
        INSTANCE;


        @Override
        public SearchKey create(Trackable t) {
            return new LineHashAndMessageKey(t);
        }
    }

    private static class LineHashAndMessageKey
    implements SearchKey {
        private final RuleKey ruleKey;
        private final String message;
        private final String lineHash;

        LineHashAndMessageKey(Trackable trackable) {
            this.ruleKey = trackable.getRuleKey();
            this.message = trackable.getMessage();
            this.lineHash = StringUtils.defaultString(trackable.getLineHash(), "");
        }

        public boolean equals(@Nonnull Object o) {
            if (this == o) {
                return true;
            }
            LineHashAndMessageKey that = (LineHashAndMessageKey)o;
            return this.lineHash.equals(that.lineHash) && this.message.equals(that.message) && this.ruleKey.equals(that.ruleKey);
        }

        public int hashCode() {
            int result = this.ruleKey.hashCode();
            result = 31 * result + this.message.hashCode();
            result = 31 * result + this.lineHash.hashCode();
            return result;
        }
    }

    private static enum LineAndLineHashKeyFactory implements SearchKeyFactory
    {
        INSTANCE;


        @Override
        public SearchKey create(Trackable t) {
            return new LineAndLineHashKey(t);
        }
    }

    private static class LineAndLineHashKey
    implements SearchKey {
        private final RuleKey ruleKey;
        private final String lineHash;
        private final Integer line;

        LineAndLineHashKey(Trackable trackable) {
            this.ruleKey = trackable.getRuleKey();
            this.line = trackable.getLine();
            this.lineHash = StringUtils.defaultString(trackable.getLineHash(), "");
        }

        public boolean equals(@Nonnull Object o) {
            if (this == o) {
                return true;
            }
            LineAndLineHashKey that = (LineAndLineHashKey)o;
            return Objects.equals(this.line, that.line) && this.lineHash.equals(that.lineHash) && this.ruleKey.equals(that.ruleKey);
        }

        public int hashCode() {
            int result = this.ruleKey.hashCode();
            result = 31 * result + this.lineHash.hashCode();
            result = 31 * result + (this.line != null ? this.line.hashCode() : 0);
            return result;
        }
    }

    private static interface SearchKeyFactory {
        public SearchKey create(Trackable var1);
    }

    private static interface SearchKey {
    }

    private static enum IsManual implements Predicate<Trackable>
    {
        INSTANCE;


        public boolean apply(Trackable input) {
            return input.getRuleKey().isManual();
        }
    }
}

