/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.internal.apachecommons.collections;

import org.sonar.api.internal.apachecommons.collections.ArrayStack;
import org.sonar.api.internal.apachecommons.collections.Buffer;
import org.sonar.api.internal.apachecommons.collections.Predicate;
import org.sonar.api.internal.apachecommons.collections.Transformer;
import org.sonar.api.internal.apachecommons.collections.buffer.BlockingBuffer;
import org.sonar.api.internal.apachecommons.collections.buffer.BoundedBuffer;
import org.sonar.api.internal.apachecommons.collections.buffer.PredicatedBuffer;
import org.sonar.api.internal.apachecommons.collections.buffer.SynchronizedBuffer;
import org.sonar.api.internal.apachecommons.collections.buffer.TransformedBuffer;
import org.sonar.api.internal.apachecommons.collections.buffer.TypedBuffer;
import org.sonar.api.internal.apachecommons.collections.buffer.UnmodifiableBuffer;

public class BufferUtils {
    public static final Buffer EMPTY_BUFFER = UnmodifiableBuffer.decorate(new ArrayStack(1));

    public static Buffer synchronizedBuffer(Buffer buffer) {
        return SynchronizedBuffer.decorate(buffer);
    }

    public static Buffer blockingBuffer(Buffer buffer) {
        return BlockingBuffer.decorate(buffer);
    }

    public static Buffer blockingBuffer(Buffer buffer, long timeoutMillis) {
        return BlockingBuffer.decorate(buffer, timeoutMillis);
    }

    public static Buffer boundedBuffer(Buffer buffer, int maximumSize) {
        return BoundedBuffer.decorate(buffer, maximumSize);
    }

    public static Buffer boundedBuffer(Buffer buffer, int maximumSize, long timeoutMillis) {
        return BoundedBuffer.decorate(buffer, maximumSize, timeoutMillis);
    }

    public static Buffer unmodifiableBuffer(Buffer buffer) {
        return UnmodifiableBuffer.decorate(buffer);
    }

    public static Buffer predicatedBuffer(Buffer buffer, Predicate predicate) {
        return PredicatedBuffer.decorate(buffer, predicate);
    }

    public static Buffer typedBuffer(Buffer buffer, Class type) {
        return TypedBuffer.decorate(buffer, type);
    }

    public static Buffer transformedBuffer(Buffer buffer, Transformer transformer) {
        return TransformedBuffer.decorate(buffer, transformer);
    }
}

