/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.core.issue.workflow;

import javax.annotation.Nullable;
import org.sonar.api.batch.BatchSide;
import org.sonar.api.issue.Issue;
import org.sonar.api.server.ServerSide;
import org.sonar.api.user.User;
import org.sonar.core.issue.DefaultIssue;
import org.sonar.core.issue.IssueChangeContext;
import org.sonar.core.issue.IssueUpdater;
import org.sonar.core.issue.workflow.Function;

@BatchSide
@ServerSide
public class FunctionExecutor {
    private final IssueUpdater updater;

    public FunctionExecutor(IssueUpdater updater) {
        this.updater = updater;
    }

    public void execute(Function[] functions, DefaultIssue issue, IssueChangeContext changeContext) {
        if (functions.length > 0) {
            FunctionContext functionContext = new FunctionContext(this.updater, issue, changeContext);
            for (Function function : functions) {
                function.execute(functionContext);
            }
        }
    }

    static class FunctionContext
    implements Function.Context {
        private final IssueUpdater updater;
        private final DefaultIssue issue;
        private final IssueChangeContext changeContext;

        FunctionContext(IssueUpdater updater, DefaultIssue issue, IssueChangeContext changeContext) {
            this.updater = updater;
            this.issue = issue;
            this.changeContext = changeContext;
        }

        @Override
        public Issue issue() {
            return this.issue;
        }

        @Override
        public Function.Context setAssignee(@Nullable User user) {
            this.updater.assign(this.issue, user, this.changeContext);
            return this;
        }

        @Override
        public Function.Context setResolution(@Nullable String s) {
            this.updater.setResolution(this.issue, s, this.changeContext);
            return this;
        }

        @Override
        public Function.Context setCloseDate(boolean b) {
            this.updater.setCloseDate(this.issue, b ? this.changeContext.date() : null, this.changeContext);
            return this;
        }

        @Override
        public Function.Context setLine(@Nullable Integer line) {
            this.updater.setLine(this.issue, line);
            return this;
        }
    }
}

