/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.server.authentication;

import javax.annotation.concurrent.Immutable;
import org.sonar.api.internal.apachecommons.lang.StringUtils;
import org.sonar.api.internal.google.common.base.Preconditions;

@Immutable
public final class Display {
    private final String iconPath;
    private final String backgroundColor;

    private Display(Builder builder) {
        this.iconPath = builder.iconPath;
        this.backgroundColor = builder.backgroundColor;
    }

    public String getIconPath() {
        return this.iconPath;
    }

    public String getBackgroundColor() {
        return this.backgroundColor;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String iconPath;
        private String backgroundColor = "#236a97";

        private Builder() {
        }

        public Builder setIconPath(String iconPath) {
            this.iconPath = iconPath;
            return this;
        }

        public Builder setBackgroundColor(String backgroundColor) {
            this.backgroundColor = backgroundColor;
            return this;
        }

        public Display build() {
            Preconditions.checkArgument(StringUtils.isNotBlank(this.iconPath), "Icon path must not be blank");
            this.validateBackgroundColor();
            return new Display(this);
        }

        private void validateBackgroundColor() {
            Preconditions.checkArgument(StringUtils.isNotBlank(this.backgroundColor), "Background color must not be blank");
            Preconditions.checkArgument(this.backgroundColor.length() == 7 && this.backgroundColor.startsWith("#"), "Background color must begin with a sharp followed by 6 characters");
        }
    }
}

