/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.sensor.coverage.internal;

import java.util.Collections;
import java.util.SortedMap;
import javax.annotation.Nullable;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.internal.DefaultInputFile;
import org.sonar.api.batch.sensor.coverage.CoverageType;
import org.sonar.api.batch.sensor.coverage.NewCoverage;
import org.sonar.api.batch.sensor.internal.DefaultStorable;
import org.sonar.api.batch.sensor.internal.SensorStorage;
import org.sonar.api.internal.google.common.base.Preconditions;
import org.sonar.api.internal.google.common.collect.Maps;

public class DefaultCoverage
extends DefaultStorable
implements NewCoverage {
    private DefaultInputFile inputFile;
    private CoverageType type;
    private int totalCoveredLines = 0;
    private int totalConditions = 0;
    private int totalCoveredConditions = 0;
    private SortedMap<Integer, Integer> hitsByLine = Maps.newTreeMap();
    private SortedMap<Integer, Integer> conditionsByLine = Maps.newTreeMap();
    private SortedMap<Integer, Integer> coveredConditionsByLine = Maps.newTreeMap();

    public DefaultCoverage() {
    }

    public DefaultCoverage(@Nullable SensorStorage storage) {
        super(storage);
    }

    @Override
    public DefaultCoverage onFile(InputFile inputFile) {
        this.inputFile = (DefaultInputFile)inputFile;
        return this;
    }

    public InputFile inputFile() {
        return this.inputFile;
    }

    @Override
    public NewCoverage ofType(CoverageType type) {
        this.validateFile();
        Preconditions.checkNotNull(type, "type can't be null");
        this.type = type;
        return this;
    }

    public CoverageType type() {
        return this.type;
    }

    @Override
    public NewCoverage lineHits(int line, int hits) {
        this.validateFile();
        this.validateLine(line);
        if (!this.hitsByLine.containsKey(line)) {
            this.hitsByLine.put(line, hits);
            if (hits > 0) {
                ++this.totalCoveredLines;
            }
        }
        return this;
    }

    private void validateLine(int line) {
        Preconditions.checkState(line <= this.inputFile.lines(), String.format("Line %d is out of range in the file %s (lines: %d)", line, this.inputFile.relativePath(), this.inputFile.lines()));
        Preconditions.checkState(line > 0, "Line number must be strictly positive: " + line);
    }

    private void validateLines() {
        for (int l : this.hitsByLine.keySet()) {
            this.validateLine(l);
        }
        for (int l : this.conditionsByLine.keySet()) {
            this.validateLine(l);
        }
        for (int l : this.coveredConditionsByLine.keySet()) {
            this.validateLine(l);
        }
    }

    private void validateFile() {
        Preconditions.checkNotNull(this.inputFile, "Call onFile() first");
    }

    @Override
    public NewCoverage conditions(int line, int conditions, int coveredConditions) {
        this.validateFile();
        this.validateLine(line);
        if (conditions > 0 && !this.conditionsByLine.containsKey(line)) {
            this.totalConditions += conditions;
            this.totalCoveredConditions += coveredConditions;
            this.conditionsByLine.put(line, conditions);
            this.coveredConditionsByLine.put(line, coveredConditions);
        }
        return this;
    }

    public int coveredLines() {
        return this.totalCoveredLines;
    }

    public int linesToCover() {
        return this.hitsByLine.size();
    }

    public int conditions() {
        return this.totalConditions;
    }

    public int coveredConditions() {
        return this.totalCoveredConditions;
    }

    public SortedMap<Integer, Integer> hitsByLine() {
        return Collections.unmodifiableSortedMap(this.hitsByLine);
    }

    public SortedMap<Integer, Integer> conditionsByLine() {
        return Collections.unmodifiableSortedMap(this.conditionsByLine);
    }

    public SortedMap<Integer, Integer> coveredConditionsByLine() {
        return Collections.unmodifiableSortedMap(this.coveredConditionsByLine);
    }

    @Override
    public void doSave() {
        this.validateFile();
        Preconditions.checkNotNull(this.type, "Call ofType() first");
        this.validateLines();
        this.storage.store(this);
    }
}

