/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.graph;

import org.sonar.api.internal.apachecommons.lang.builder.ToStringBuilder;
import org.sonar.graph.Edge;

public class StringEdge
implements Edge<String> {
    private final String from;
    private final String to;
    private int weight;

    public StringEdge(String from, String to) {
        this.from = from;
        this.to = to;
        this.weight = 1;
    }

    public StringEdge(String from, String to, int weight) {
        this(from, to);
        this.weight = weight;
    }

    @Override
    public String getFrom() {
        return this.from;
    }

    @Override
    public String getTo() {
        return this.to;
    }

    @Override
    public int getWeight() {
        return this.weight;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof StringEdge)) {
            return false;
        }
        StringEdge edge = (StringEdge)obj;
        return this.from.equals(edge.from) && this.to.equals(edge.to);
    }

    public int hashCode() {
        return 3 * this.from.hashCode() + this.to.hashCode();
    }

    public String toString() {
        return new ToStringBuilder(this).append("from", this.from).append("to", this.to).toString();
    }
}

