/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.runner.api;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import org.sonar.runner.api.Utils;
import org.sonar.runner.cache.Logger;

class Dirs {
    private final Logger logger;

    Dirs(Logger logger) {
        this.logger = logger;
    }

    void init(Properties p) {
        boolean onProject = Utils.taskRequiresProject(p);
        if (onProject) {
            this.initProjectDirs(p);
        } else {
            Dirs.initTaskDirs(p);
        }
    }

    private void initProjectDirs(Properties p) {
        Path workDirPath;
        String pathString = p.getProperty("sonar.projectBaseDir", "");
        Path absoluteProjectPath = Paths.get(pathString, new String[0]).toAbsolutePath().normalize();
        if (!Files.isDirectory(absoluteProjectPath, new LinkOption[0])) {
            throw new IllegalStateException("Project home must be an existing directory: " + pathString);
        }
        p.setProperty("sonar.projectBaseDir", absoluteProjectPath.toString());
        pathString = p.getProperty("sonar.working.directory", "");
        if ("".equals(pathString.trim())) {
            workDirPath = absoluteProjectPath.resolve(".sonar");
        } else {
            workDirPath = Paths.get(pathString, new String[0]);
            if (!workDirPath.isAbsolute()) {
                workDirPath = absoluteProjectPath.resolve(pathString);
            }
        }
        p.setProperty("sonar.working.directory", workDirPath.normalize().toString());
        this.logger.debug("Work directory: " + workDirPath.normalize().toString());
    }

    private static void initTaskDirs(Properties p) {
        String path = p.getProperty("sonar.working.directory", ".");
        File workDir = new File(path);
        p.setProperty("sonar.working.directory", workDir.getAbsolutePath());
    }
}

