/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.scanner.lib.internal.facade;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Dirs {
    private static final Logger LOG = LoggerFactory.getLogger(Dirs.class);

    Dirs() {
    }

    void init(Map<String, String> p) {
        Path workDirPath;
        String pathString = Optional.ofNullable(p.get("sonar.projectBaseDir")).orElse("");
        Path absoluteProjectPath = Paths.get(pathString, new String[0]).toAbsolutePath().normalize();
        if (!Files.isDirectory(absoluteProjectPath, new LinkOption[0])) {
            throw new IllegalStateException("Project home must be an existing directory: " + pathString);
        }
        p.put("sonar.projectBaseDir", absoluteProjectPath.toString());
        pathString = Optional.ofNullable(p.get("sonar.working.directory")).orElse("");
        if (pathString.trim().isEmpty()) {
            workDirPath = absoluteProjectPath.resolve(".scannerwork");
        } else {
            workDirPath = Paths.get(pathString, new String[0]);
            if (!workDirPath.isAbsolute()) {
                workDirPath = absoluteProjectPath.resolve(pathString);
            }
        }
        String normalized = workDirPath.normalize().toString();
        p.put("sonar.working.directory", normalized);
        LOG.debug("Work directory: {}", (Object)normalized);
    }
}

