/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.scanner.lib.internal.cache;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.MessageDigest;

class FileHashes {
    private static final int STREAM_BUFFER_LENGTH = 1024;

    FileHashes() {
    }

    String of(File file, String hashAlgorithm) {
        try {
            return this.of(new FileInputStream(file), hashAlgorithm);
        }
        catch (IOException e) {
            throw new IllegalStateException("Fail to compute hash of: " + file.getAbsolutePath(), e);
        }
    }

    String of(InputStream input, String hashAlgorithm) {
        String string;
        block8: {
            InputStream is = input;
            try {
                MessageDigest digest = MessageDigest.getInstance(hashAlgorithm);
                byte[] hash = FileHashes.digest(is, digest);
                string = FileHashes.toHex(hash);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new IllegalStateException("Fail to compute hash", e);
                }
            }
            is.close();
        }
        return string;
    }

    private static byte[] digest(InputStream input, MessageDigest digest) throws IOException {
        byte[] buffer = new byte[1024];
        int read = input.read(buffer, 0, 1024);
        while (read > -1) {
            digest.update(buffer, 0, read);
            read = input.read(buffer, 0, 1024);
        }
        return digest.digest();
    }

    static String toHex(byte[] bytes) {
        BigInteger bi = new BigInteger(1, bytes);
        String hexFormat = "%0" + (bytes.length << 1) + "x";
        return String.format(hexFormat, bi);
    }
}

