/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.scanner.cli;

import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.sonarsource.scanner.cli.Logs;
import org.sonarsource.scanner.cli.ScannerVersion;

class SystemInfo {
    private static final Set<String> SENSITIVE_JVM_ARGUMENTS = Set.of("-Dsonar.login", "-Dsonar.password", "-Dsonar.token");
    private static final Pattern PATTERN_ARGUMENT_SEPARATOR = Pattern.compile("\\s+");
    private static System2 system = new System2();

    private SystemInfo() {
    }

    static void setSystem(System2 system) {
        SystemInfo.system = system;
    }

    static void print(Logs logger) {
        logger.info("SonarScanner " + ScannerVersion.version());
        logger.info(SystemInfo.java());
        logger.info(SystemInfo.os());
        String scannerOpts = system.getenv("SONAR_SCANNER_OPTS");
        if (scannerOpts != null) {
            logger.info("SONAR_SCANNER_OPTS=" + SystemInfo.redactSensitiveArguments(scannerOpts));
        }
    }

    private static String redactSensitiveArguments(String scannerOpts) {
        return PATTERN_ARGUMENT_SEPARATOR.splitAsStream(scannerOpts).map(SystemInfo::redactArgumentIfSensistive).collect(Collectors.joining(" "));
    }

    private static String redactArgumentIfSensistive(String argument) {
        String[] elems = argument.split("=");
        if (elems.length > 0 && SENSITIVE_JVM_ARGUMENTS.contains(elems[0])) {
            return elems[0] + "=*";
        }
        return argument;
    }

    static String java() {
        StringBuilder sb = new StringBuilder();
        sb.append("Java ").append(system.getProperty("java.version")).append(" ").append(system.getProperty("java.vendor"));
        String bits = system.getProperty("sun.arch.data.model");
        if ("32".equals(bits) || "64".equals(bits)) {
            sb.append(" (").append(bits).append("-bit)");
        }
        return sb.toString();
    }

    static String os() {
        StringBuilder sb = new StringBuilder();
        sb.append(system.getProperty("os.name")).append(" ").append(system.getProperty("os.version")).append(" ").append(system.getProperty("os.arch"));
        return sb.toString();
    }

    static class System2 {
        System2() {
        }

        String getProperty(String key) {
            return System.getProperty(key);
        }

        String getenv(String key) {
            return System.getenv(key);
        }
    }
}

