/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.scanner.cli;

import java.util.Properties;
import org.sonarsource.scanner.api.EmbeddedScanner;
import org.sonarsource.scanner.cli.Cli;
import org.sonarsource.scanner.cli.Conf;
import org.sonarsource.scanner.cli.Exit;
import org.sonarsource.scanner.cli.Logs;
import org.sonarsource.scanner.cli.ScannerFactory;
import org.sonarsource.scanner.cli.Stats;
import org.sonarsource.scanner.cli.SystemInfo;

public class Main {
    private static final String SEPARATOR = "------------------------------------------------------------------------";
    private final Exit exit;
    private final Cli cli;
    private final Conf conf;
    private EmbeddedScanner runner;
    private ScannerFactory runnerFactory;
    private Logs logger;

    Main(Exit exit, Cli cli, Conf conf, ScannerFactory runnerFactory, Logs logger) {
        this.exit = exit;
        this.cli = cli;
        this.conf = conf;
        this.runnerFactory = runnerFactory;
        this.logger = logger;
    }

    public static void main(String[] args) {
        Logs logs = new Logs(System.out, System.err);
        Exit exit = new Exit();
        Cli cli = new Cli(exit, logs).parse(args);
        Main main = new Main(exit, cli, new Conf(cli, logs, System.getenv()), new ScannerFactory(logs), logs);
        main.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void execute() {
        Stats stats = new Stats(this.logger).start();
        int status = 1;
        try {
            Properties p = this.conf.properties();
            this.checkSkip(p);
            this.configureLogging(p);
            this.init(p);
            this.runner.start();
            this.logger.info("SonarQube server " + this.runner.serverVersion());
            this.execute(stats, p);
            status = 0;
        }
        catch (Throwable e) {
            this.displayExecutionResult(stats, "FAILURE");
            this.showError("Error during SonarQube Scanner execution", e, this.cli.isDebugEnabled());
        }
        finally {
            this.exit.exit(status);
        }
    }

    private void checkSkip(Properties properties) {
        if ("true".equalsIgnoreCase(properties.getProperty("sonar.scanner.skip"))) {
            this.logger.info("SonarQube Scanner analysis skipped");
            this.exit.exit(0);
        }
    }

    private void init(Properties p) {
        SystemInfo.print(this.logger);
        if (this.cli.isDisplayVersionOnly()) {
            this.exit.exit(0);
        }
        this.runner = this.runnerFactory.create(p);
    }

    private void configureLogging(Properties props) {
        if ("true".equals(props.getProperty("sonar.verbose")) || "DEBUG".equalsIgnoreCase(props.getProperty("sonar.log.level")) || "TRACE".equalsIgnoreCase(props.getProperty("sonar.log.level"))) {
            this.logger.setDebugEnabled(true);
        }
    }

    private void execute(Stats stats, Properties p) {
        this.runner.execute(p);
        this.displayExecutionResult(stats, "SUCCESS");
    }

    private void displayExecutionResult(Stats stats, String resultMsg) {
        this.logger.info(SEPARATOR);
        this.logger.info("EXECUTION " + resultMsg);
        this.logger.info(SEPARATOR);
        stats.stop();
        this.logger.info(SEPARATOR);
    }

    private void showError(String message, Throwable e, boolean debug) {
        if (Main.showStackTrace(e, debug)) {
            this.logger.error(message, e);
        } else {
            this.logger.error(message);
            this.logger.error(e.getMessage());
            String previousMsg = "";
            for (Throwable cause = e.getCause(); cause != null && cause.getMessage() != null && !cause.getMessage().equals(previousMsg); cause = cause.getCause()) {
                this.logger.error("Caused by: " + cause.getMessage());
                previousMsg = cause.getMessage();
            }
        }
        if (!this.cli.isDebugEnabled()) {
            this.logger.error("");
            this.suggestDebugMode();
        }
    }

    private static boolean showStackTrace(Throwable e, boolean debug) {
        return debug && !"org.sonar.api.utils.MessageException".equals(e.getClass().getName());
    }

    private void suggestDebugMode() {
        this.logger.error("Re-run SonarQube Scanner using the -X switch to enable full debug logging.");
    }
}

