/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.tests;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.collections.MapBuilder;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.UnaryExpressionTree;

@Rule(key="S5785")
public class AssertTrueInsteadOfDedicatedAssertCheck
extends AbstractMethodDetection {
    private static final String JAVA_LANG_OBJECT = "java.lang.Object";
    private static final MethodMatchers EQUALS_METHODS = MethodMatchers.or(MethodMatchers.create().ofAnyType().names("equals").addParametersMatcher("java.lang.Object").build(), MethodMatchers.create().ofTypes("java.util.Objects").names("equals").addParametersMatcher("java.lang.Object", "java.lang.Object").build());
    private static final String[] ASSERT_METHOD_NAMES = new String[]{"assertTrue", "assertFalse"};
    private static final String[] ASSERTION_CLASSES = new String[]{"org.junit.Assert", "junit.framework.TestCase", "junit.framework.Assert", "org.junit.jupiter.api.Assertions"};
    private static final Map<Assertion, Assertion> COMPLEMENTS = MapBuilder.newMap().put(Assertion.NULL, Assertion.NOT_NULL).put(Assertion.NOT_NULL, Assertion.NULL).put(Assertion.SAME, Assertion.NOT_SAME).put(Assertion.NOT_SAME, Assertion.SAME).put(Assertion.EQUALS, Assertion.NOT_EQUALS).put(Assertion.NOT_EQUALS, Assertion.EQUALS).build();

    @Override
    protected MethodMatchers getMethodInvocationMatchers() {
        return MethodMatchers.create().ofTypes(ASSERTION_CLASSES).names(ASSERT_METHOD_NAMES).withAnyParameters().build();
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        mit.arguments().stream().filter(argument -> argument.symbolType().isPrimitive(Type.Primitives.BOOLEAN)).findFirst().ifPresent(argument -> this.checkBooleanExpressionInAssertMethod(ExpressionUtils.methodName(mit), (ExpressionTree)argument));
    }

    private void checkBooleanExpressionInAssertMethod(IdentifierTree problematicAssertionCallIdentifier, ExpressionTree argumentExpression) {
        Optional<Assertion> replacementAssertionOpt = AssertTrueInsteadOfDedicatedAssertCheck.getReplacementAssertion(argumentExpression);
        if (problematicAssertionCallIdentifier.name().equals("assertFalse")) {
            replacementAssertionOpt = replacementAssertionOpt.map(COMPLEMENTS::get);
        }
        replacementAssertionOpt.ifPresent(replacementAssertion -> this.reportIssue(problematicAssertionCallIdentifier, replacementAssertion.useInsteadMessage, Collections.singletonList(new JavaFileScannerContext.Location(replacementAssertion.secondaryExplanationMessage, argumentExpression)), null));
    }

    private static Optional<Assertion> getReplacementAssertion(ExpressionTree argumentExpression) {
        Assertion assertion = null;
        switch (argumentExpression.kind()) {
            case EQUAL_TO: {
                if (AssertTrueInsteadOfDedicatedAssertCheck.isCheckForNull((BinaryExpressionTree)argumentExpression)) {
                    assertion = Assertion.NULL;
                    break;
                }
                if (AssertTrueInsteadOfDedicatedAssertCheck.isPrimitiveComparison((BinaryExpressionTree)argumentExpression)) {
                    assertion = Assertion.EQUALS;
                    break;
                }
                assertion = Assertion.SAME;
                break;
            }
            case NOT_EQUAL_TO: {
                if (AssertTrueInsteadOfDedicatedAssertCheck.isCheckForNull((BinaryExpressionTree)argumentExpression)) {
                    assertion = Assertion.NOT_NULL;
                    break;
                }
                if (AssertTrueInsteadOfDedicatedAssertCheck.isPrimitiveComparison((BinaryExpressionTree)argumentExpression)) {
                    assertion = Assertion.NOT_EQUALS;
                    break;
                }
                assertion = Assertion.NOT_SAME;
                break;
            }
            case METHOD_INVOCATION: {
                if (!EQUALS_METHODS.matches((MethodInvocationTree)argumentExpression)) break;
                assertion = Assertion.EQUALS;
                break;
            }
            case LOGICAL_COMPLEMENT: {
                return AssertTrueInsteadOfDedicatedAssertCheck.getReplacementAssertion(((UnaryExpressionTree)argumentExpression).expression()).map(COMPLEMENTS::get);
            }
        }
        return Optional.ofNullable(assertion);
    }

    private static boolean isCheckForNull(BinaryExpressionTree bet) {
        return bet.leftOperand().is(Tree.Kind.NULL_LITERAL) || bet.rightOperand().is(Tree.Kind.NULL_LITERAL);
    }

    private static boolean isPrimitiveComparison(BinaryExpressionTree bet) {
        return bet.leftOperand().symbolType().isPrimitive() || bet.rightOperand().symbolType().isPrimitive();
    }

    private static enum Assertion {
        NULL("Null", "A null-check"),
        NOT_NULL("NotNull", "A null-check"),
        SAME("Same", "An object reference comparison"),
        NOT_SAME("NotSame", "An object reference comparison"),
        EQUALS("Equals", "An equals check"),
        NOT_EQUALS("NotEquals", "An equals check");

        public final String methodName;
        public final String useInsteadMessage;
        public final String secondaryExplanationMessage;

        private Assertion(String namePostfix, String actionDescription) {
            this.methodName = "assert" + namePostfix;
            this.useInsteadMessage = String.format("Use %s instead.", this.methodName);
            this.secondaryExplanationMessage = String.format("%s is performed here, which is better expressed with %s.", actionDescription, this.methodName);
        }
    }
}

