/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.model.LiteralUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.NewArrayTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S1309")
public class SuppressWarningsCheck
extends IssuableSubscriptionVisitor {
    private static final Pattern FORMER_REPOSITORY_PREFIX = Pattern.compile("^squid:");
    private static final String NEW_REPOSITORY_PREFIX = "java:";
    @RuleProperty(key="listOfWarnings", description="Comma separated list of warnings that can be suppressed (example: unchecked, cast, boxing). An empty list means that no warning can be suppressed.", defaultValue="")
    public String warningsCommaSeparated = "";
    private Set<String> allowedWarnings;

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.ANNOTATION);
    }

    @Override
    public void visitNode(Tree tree) {
        AnnotationTree annotationTree = (AnnotationTree)tree;
        Set<String> ruleWarnings = this.getAllowedWarnings();
        if (SuppressWarningsCheck.isJavaLangSuppressWarnings(annotationTree)) {
            if (ruleWarnings.isEmpty()) {
                this.reportIssue(annotationTree.annotationType(), "Suppressing warnings is not allowed");
            } else {
                List<String> suppressedWarnings = SuppressWarningsCheck.getSuppressedWarnings((ExpressionTree)annotationTree.arguments().get(0));
                List issues = suppressedWarnings.stream().filter(currentWarning -> !ruleWarnings.contains(currentWarning)).collect(Collectors.toList());
                if (!issues.isEmpty()) {
                    StringBuilder sb = new StringBuilder("Suppressing the '").append(String.join((CharSequence)", ", issues)).append("' warning").append(issues.size() > 1 ? "s" : "").append(" is not allowed");
                    this.reportIssue(annotationTree.annotationType(), sb.toString());
                }
            }
        }
    }

    private static boolean isJavaLangSuppressWarnings(AnnotationTree tree) {
        return tree.symbolType().is("java.lang.SuppressWarnings");
    }

    private Set<String> getAllowedWarnings() {
        if (this.allowedWarnings != null) {
            return this.allowedWarnings;
        }
        this.allowedWarnings = Arrays.stream(this.warningsCommaSeparated.split(",")).filter(StringUtils::isNotBlank).map(SuppressWarningsCheck::replaceFormerRepositoryPrefix).collect(Collectors.toSet());
        return this.allowedWarnings;
    }

    private static List<String> getSuppressedWarnings(ExpressionTree argument) {
        ArrayList<String> result = new ArrayList<String>();
        if (argument.is(Tree.Kind.STRING_LITERAL)) {
            result.add(SuppressWarningsCheck.getAnnotationArgument((LiteralTree)argument));
        } else if (argument.is(Tree.Kind.NEW_ARRAY)) {
            NewArrayTree array = (NewArrayTree)argument;
            for (ExpressionTree expressionTree : array.initializers()) {
                if (!expressionTree.is(Tree.Kind.STRING_LITERAL)) continue;
                result.add(SuppressWarningsCheck.getAnnotationArgument((LiteralTree)expressionTree));
            }
        }
        return result;
    }

    private static String getAnnotationArgument(LiteralTree argument) {
        return SuppressWarningsCheck.replaceFormerRepositoryPrefix(LiteralUtils.trimQuotes(argument.value()));
    }

    private static String replaceFormerRepositoryPrefix(String value) {
        return FORMER_REPOSITORY_PREFIX.matcher(value.trim()).replaceFirst(NEW_REPOSITORY_PREFIX);
    }
}

