/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.surefire;

import com.ctc.wstx.stax.WstxInputFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import org.codehaus.staxmate.SMInputFactory;
import org.codehaus.staxmate.in.SMHierarchicCursor;
import org.sonar.plugins.surefire.data.SurefireStaxHandler;
import org.sonar.plugins.surefire.data.UnitTestIndex;

public class StaxParser {
    private SMInputFactory inf;
    private SurefireStaxHandler streamHandler;

    public StaxParser(UnitTestIndex index) {
        this.streamHandler = new SurefireStaxHandler(index);
        XMLInputFactory xmlFactory = XMLInputFactory.newInstance();
        if (xmlFactory instanceof WstxInputFactory) {
            WstxInputFactory wstxInputfactory = (WstxInputFactory)xmlFactory;
            wstxInputfactory.configureForLowMemUsage();
            wstxInputfactory.getConfig().setUndeclaredEntityResolver((publicID, systemID, baseURI, namespace) -> namespace);
        }
        xmlFactory.setProperty("javax.xml.stream.isValidating", false);
        xmlFactory.setProperty("javax.xml.stream.supportDTD", false);
        xmlFactory.setProperty("javax.xml.stream.isNamespaceAware", false);
        this.inf = new SMInputFactory(xmlFactory);
    }

    public void parse(File xmlFile) throws XMLStreamException {
        try (FileInputStream input = new FileInputStream(xmlFile);){
            this.parse(this.inf.rootElementCursor((InputStream)input));
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
    }

    private void parse(SMHierarchicCursor rootCursor) throws XMLStreamException {
        try {
            this.streamHandler.stream(rootCursor);
        }
        finally {
            rootCursor.getStreamReader().closeCompletely();
        }
    }
}

