/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.dom;

import javax.annotation.Nullable;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.BindingResolver;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodBinding;
import org.eclipse.jdt.internal.compiler.env.IBinaryAnnotation;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;

public final class ASTUtils {
    private static final Logger LOG = Loggers.get(ASTUtils.class);
    private static final IAnnotationBinding[] NO_ANNOTATIONS = new IAnnotationBinding[0];

    private ASTUtils() {
    }

    public static void mayTolerateMissingType(AST ast) {
        ast.getBindingResolver().lookupEnvironment().mayTolerateMissingType = true;
    }

    public static void cleanupEnvironment(AST ast) {
        ast.getBindingResolver().lookupEnvironment().nameEnvironment.cleanup();
    }

    @Nullable
    public static ITypeBinding resolveType(AST ast, String name) {
        try {
            BindingResolver bindingResolver = ast.getBindingResolver();
            ReferenceBinding referenceBinding = bindingResolver.lookupEnvironment().getType(CharOperation.splitOn((char)'.', (char[])name.toCharArray()));
            return bindingResolver.getTypeBinding((TypeBinding)referenceBinding);
        }
        catch (Exception e) {
            LOG.error(String.format("ECJ Unable to resolve type %s", name), (Throwable)e);
            return null;
        }
    }

    public static IAnnotationBinding[] resolvePackageAnnotations(AST ast, String packageName) {
        BindingResolver bindingResolver = ast.getBindingResolver();
        LookupEnvironment lookupEnvironment = bindingResolver.lookupEnvironment();
        NameEnvironmentAnswer answer = lookupEnvironment.nameEnvironment.findType(TypeConstants.PACKAGE_INFO_NAME, CharOperation.splitOn((char)'.', (char[])packageName.toCharArray()));
        if (answer == null) {
            return NO_ANNOTATIONS;
        }
        IBinaryType type = answer.getBinaryType();
        if (type == null) {
            return NO_ANNOTATIONS;
        }
        IBinaryAnnotation[] binaryAnnotations = type.getAnnotations();
        AnnotationBinding[] binaryInstances = BinaryTypeBinding.createAnnotations((IBinaryAnnotation[])binaryAnnotations, (LookupEnvironment)lookupEnvironment, (char[][][])type.getMissingTypeNames());
        AnnotationBinding[] allInstances = AnnotationBinding.addStandardAnnotations((AnnotationBinding[])binaryInstances, (long)type.getTagBits(), (LookupEnvironment)lookupEnvironment);
        IAnnotationBinding[] domInstances = new IAnnotationBinding[allInstances.length];
        for (int i = 0; i < allInstances.length; ++i) {
            domInstances[i] = bindingResolver.getAnnotationInstance(allInstances[i]);
        }
        return domInstances;
    }

    public static String signature(IMethodBinding methodBinding) {
        char[] signature = ((MethodBinding)methodBinding).binding.signature();
        return new String(signature);
    }
}

