/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.se.xproc;

import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.sonar.java.model.Sema;
import org.sonar.java.resolve.Symbols;
import org.sonar.java.se.ExplodedGraph;
import org.sonar.java.se.ProgramState;
import org.sonar.java.se.symbolicvalues.SymbolicValue;
import org.sonar.java.se.xproc.MethodBehavior;
import org.sonar.java.se.xproc.MethodYield;
import org.sonar.plugins.java.api.semantic.Type;

public class ExceptionalYield
extends MethodYield {
    @Nullable
    private String exceptionType = null;

    public ExceptionalYield(MethodBehavior behavior) {
        super(behavior);
    }

    public ExceptionalYield(ExplodedGraph.Node node, MethodBehavior behavior) {
        super(node, behavior);
    }

    @Override
    public Stream<ProgramState> statesAfterInvocation(List<SymbolicValue> invocationArguments, List<Type> invocationTypes, ProgramState programState, Supplier<SymbolicValue> svSupplier) {
        return this.parametersAfterInvocation(invocationArguments, invocationTypes, programState).map(s -> s.stackValue((SymbolicValue)svSupplier.get())).distinct();
    }

    public void setExceptionType(@Nullable String exceptionType) {
        this.exceptionType = exceptionType;
    }

    @Nullable
    public String getExceptionType() {
        return this.exceptionType;
    }

    public Type exceptionType(Sema semanticModel) {
        if (this.exceptionType == null) {
            return Symbols.unknownType;
        }
        Type type = semanticModel.getClassType(this.exceptionType);
        return type == null ? Symbols.unknownType : type;
    }

    @Override
    public String toString() {
        return String.format("{params: %s, exceptional%s}", this.parametersConstraints.stream().map(constraints -> constraints.stream().map(Object::toString).collect(Collectors.toList())).collect(Collectors.toList()), this.exceptionType == null ? "" : " (" + this.exceptionType + ")");
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(3, 1295).appendSuper(super.hashCode()).append((Object)this.exceptionType).toHashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ExceptionalYield other = (ExceptionalYield)obj;
        return new EqualsBuilder().appendSuper(super.equals(obj)).append((Object)this.exceptionType, (Object)other.exceptionType).isEquals();
    }
}

