/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.regex.ast;

import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import javax.annotation.CheckForNull;
import org.sonar.java.regex.RegexParseResult;
import org.sonar.java.regex.ast.AtomicGroupTree;
import org.sonar.java.regex.ast.BackReferenceTree;
import org.sonar.java.regex.ast.BoundaryTree;
import org.sonar.java.regex.ast.CapturingGroupTree;
import org.sonar.java.regex.ast.CharacterClassIntersectionTree;
import org.sonar.java.regex.ast.CharacterClassTree;
import org.sonar.java.regex.ast.CharacterClassUnionTree;
import org.sonar.java.regex.ast.CharacterRangeTree;
import org.sonar.java.regex.ast.CharacterTree;
import org.sonar.java.regex.ast.DisjunctionTree;
import org.sonar.java.regex.ast.DotTree;
import org.sonar.java.regex.ast.EscapedCharacterClassTree;
import org.sonar.java.regex.ast.FlagSet;
import org.sonar.java.regex.ast.JavaCharacter;
import org.sonar.java.regex.ast.LookAroundTree;
import org.sonar.java.regex.ast.MiscEscapeSequenceTree;
import org.sonar.java.regex.ast.NonCapturingGroupTree;
import org.sonar.java.regex.ast.PlainCharacterTree;
import org.sonar.java.regex.ast.RegexTree;
import org.sonar.java.regex.ast.RegexVisitor;
import org.sonar.java.regex.ast.RepetitionTree;
import org.sonar.java.regex.ast.SequenceTree;
import org.sonar.java.regex.ast.UnicodeCodePointTree;

public class RegexBaseVisitor
implements RegexVisitor {
    private FlagSet activeFlags;

    @VisibleForTesting
    protected int getActiveFlags() {
        return this.activeFlags.getMask();
    }

    protected boolean flagActive(int flag) {
        return this.activeFlags.contains(flag);
    }

    @CheckForNull
    protected JavaCharacter getJavaCharacterForFlag(int flag) {
        return this.activeFlags.getJavaCharacterForFlag(flag);
    }

    protected void visit(RegexTree tree) {
        tree.accept(this);
    }

    private void visit(List<RegexTree> trees) {
        trees.forEach(this::visit);
    }

    @Override
    public void visit(RegexParseResult regexParseResult) {
        if (!regexParseResult.hasSyntaxErrors()) {
            this.activeFlags = regexParseResult.getInitialFlags();
            this.before(regexParseResult);
            this.visit(regexParseResult.getResult());
            this.after(regexParseResult);
        }
    }

    protected void before(RegexParseResult regexParseResult) {
    }

    protected void after(RegexParseResult regexParseResult) {
    }

    @Override
    public void visitPlainCharacter(PlainCharacterTree tree) {
        this.visitCharacter(tree);
    }

    @Override
    public void visitUnicodeCodePoint(UnicodeCodePointTree tree) {
        this.visitCharacter(tree);
    }

    protected void visitCharacter(CharacterTree tree) {
    }

    @Override
    public void visitSequence(SequenceTree tree) {
        this.visit(tree.getItems());
    }

    @Override
    public void visitDisjunction(DisjunctionTree tree) {
        this.visit(tree.getAlternatives());
    }

    @Override
    public void visitCapturingGroup(CapturingGroupTree tree) {
        this.visitAndRestoreFlags(tree.getElement());
    }

    @Override
    public final void visitNonCapturingGroup(NonCapturingGroupTree tree) {
        FlagSet oldFlags = this.activeFlags;
        this.activeFlags = new FlagSet(this.activeFlags);
        this.activeFlags.addAll(tree.getEnabledFlags());
        this.activeFlags.removeAll(tree.getDisabledFlags());
        this.doVisitNonCapturingGroup(tree);
        if (tree.getElement() != null) {
            this.activeFlags = oldFlags;
        }
    }

    protected void doVisitNonCapturingGroup(NonCapturingGroupTree tree) {
        RegexTree element = tree.getElement();
        if (element != null) {
            this.visit(element);
        }
    }

    @Override
    public void visitAtomicGroup(AtomicGroupTree tree) {
        this.visitAndRestoreFlags(tree.getElement());
    }

    @Override
    public void visitLookAround(LookAroundTree tree) {
        this.visitAndRestoreFlags(tree.getElement());
    }

    private void visitAndRestoreFlags(RegexTree tree) {
        FlagSet oldFlags = this.activeFlags;
        this.activeFlags = new FlagSet(this.activeFlags);
        this.visit(tree);
        this.activeFlags = oldFlags;
    }

    @Override
    public void visitBackReference(BackReferenceTree tree) {
    }

    @Override
    public void visitRepetition(RepetitionTree tree) {
        this.visit(tree.getElement());
    }

    @Override
    public void visitCharacterClass(CharacterClassTree tree) {
        this.visit(tree.getContents());
    }

    @Override
    public void visitCharacterRange(CharacterRangeTree tree) {
    }

    @Override
    public void visitCharacterClassUnion(CharacterClassUnionTree tree) {
        this.visit(tree.getCharacterClasses());
    }

    @Override
    public void visitCharacterClassIntersection(CharacterClassIntersectionTree tree) {
        this.visit(tree.getCharacterClasses());
    }

    @Override
    public void visitDot(DotTree tree) {
    }

    @Override
    public void visitEscapedCharacterClass(EscapedCharacterClassTree tree) {
    }

    @Override
    public void visitBoundary(BoundaryTree boundaryTree) {
    }

    @Override
    public void visitMiscEscapeSequence(MiscEscapeSequenceTree tree) {
    }
}

