/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model;

import com.sonar.sslr.api.RecognitionException;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTUtils;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ArrayAccess;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.AssertStatement;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.BooleanLiteral;
import org.eclipse.jdt.core.dom.BreakStatement;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.CharacterLiteral;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConditionalExpression;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.ContinueStatement;
import org.eclipse.jdt.core.dom.CreationReference;
import org.eclipse.jdt.core.dom.Dimension;
import org.eclipse.jdt.core.dom.DoStatement;
import org.eclipse.jdt.core.dom.EmptyStatement;
import org.eclipse.jdt.core.dom.EnhancedForStatement;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.ExportsDirective;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionMethodReference;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.IfStatement;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.InstanceofExpression;
import org.eclipse.jdt.core.dom.IntersectionType;
import org.eclipse.jdt.core.dom.LabeledStatement;
import org.eclipse.jdt.core.dom.LambdaExpression;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.ModuleDeclaration;
import org.eclipse.jdt.core.dom.ModuleDirective;
import org.eclipse.jdt.core.dom.ModuleModifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NameQualifiedType;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.NullLiteral;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.OpensDirective;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.PostfixExpression;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.ProvidesDirective;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.RecordDeclaration;
import org.eclipse.jdt.core.dom.RequiresDirective;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.SuperMethodReference;
import org.eclipse.jdt.core.dom.SwitchCase;
import org.eclipse.jdt.core.dom.SwitchExpression;
import org.eclipse.jdt.core.dom.SwitchStatement;
import org.eclipse.jdt.core.dom.SynchronizedStatement;
import org.eclipse.jdt.core.dom.TextBlock;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.ThrowStatement;
import org.eclipse.jdt.core.dom.TryStatement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclarationStatement;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.eclipse.jdt.core.dom.TypeMethodReference;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.jdt.core.dom.UnionType;
import org.eclipse.jdt.core.dom.UsesDirective;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.WhileStatement;
import org.eclipse.jdt.core.dom.WildcardType;
import org.eclipse.jdt.core.dom.YieldStatement;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.parser.Scanner;
import org.eclipse.jdt.internal.formatter.DefaultCodeFormatterOptions;
import org.eclipse.jdt.internal.formatter.Token;
import org.eclipse.jdt.internal.formatter.TokenManager;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.java.ast.parser.ArgumentListTreeImpl;
import org.sonar.java.ast.parser.BlockStatementListTreeImpl;
import org.sonar.java.ast.parser.BoundListTreeImpl;
import org.sonar.java.ast.parser.FormalParametersListTreeImpl;
import org.sonar.java.ast.parser.InitializerListTreeImpl;
import org.sonar.java.ast.parser.ModuleNameTreeImpl;
import org.sonar.java.ast.parser.QualifiedIdentifierListTreeImpl;
import org.sonar.java.ast.parser.ResourceListTreeImpl;
import org.sonar.java.ast.parser.StatementExpressionListTreeImpl;
import org.sonar.java.ast.parser.TypeParameterListTreeImpl;
import org.sonar.java.ast.parser.TypeUnionListTreeImpl;
import org.sonar.java.model.AbstractTypedTree;
import org.sonar.java.model.ArrayDimensionTreeImpl;
import org.sonar.java.model.InternalSyntaxToken;
import org.sonar.java.model.InternalSyntaxTrivia;
import org.sonar.java.model.JLabelSymbol;
import org.sonar.java.model.JSema;
import org.sonar.java.model.JavaTree;
import org.sonar.java.model.KeywordSuper;
import org.sonar.java.model.KeywordThis;
import org.sonar.java.model.TypeParameterTreeImpl;
import org.sonar.java.model.declaration.AnnotationTreeImpl;
import org.sonar.java.model.declaration.ClassTreeImpl;
import org.sonar.java.model.declaration.EnumConstantTreeImpl;
import org.sonar.java.model.declaration.ExportsDirectiveTreeImpl;
import org.sonar.java.model.declaration.MethodTreeImpl;
import org.sonar.java.model.declaration.ModifierKeywordTreeImpl;
import org.sonar.java.model.declaration.ModifiersTreeImpl;
import org.sonar.java.model.declaration.ModuleDeclarationTreeImpl;
import org.sonar.java.model.declaration.ModuleNameListTreeImpl;
import org.sonar.java.model.declaration.OpensDirectiveTreeImpl;
import org.sonar.java.model.declaration.ProvidesDirectiveTreeImpl;
import org.sonar.java.model.declaration.RequiresDirectiveTreeImpl;
import org.sonar.java.model.declaration.UsesDirectiveTreeImpl;
import org.sonar.java.model.declaration.VariableTreeImpl;
import org.sonar.java.model.expression.ArrayAccessExpressionTreeImpl;
import org.sonar.java.model.expression.AssessableExpressionTree;
import org.sonar.java.model.expression.AssignmentExpressionTreeImpl;
import org.sonar.java.model.expression.BinaryExpressionTreeImpl;
import org.sonar.java.model.expression.ConditionalExpressionTreeImpl;
import org.sonar.java.model.expression.IdentifierTreeImpl;
import org.sonar.java.model.expression.InstanceOfTreeImpl;
import org.sonar.java.model.expression.InternalPostfixUnaryExpression;
import org.sonar.java.model.expression.InternalPrefixUnaryExpression;
import org.sonar.java.model.expression.LambdaExpressionTreeImpl;
import org.sonar.java.model.expression.LiteralTreeImpl;
import org.sonar.java.model.expression.MemberSelectExpressionTreeImpl;
import org.sonar.java.model.expression.MethodInvocationTreeImpl;
import org.sonar.java.model.expression.MethodReferenceTreeImpl;
import org.sonar.java.model.expression.NewArrayTreeImpl;
import org.sonar.java.model.expression.NewClassTreeImpl;
import org.sonar.java.model.expression.ParenthesizedTreeImpl;
import org.sonar.java.model.expression.TypeArgumentListTreeImpl;
import org.sonar.java.model.expression.TypeCastExpressionTreeImpl;
import org.sonar.java.model.expression.VarTypeTreeImpl;
import org.sonar.java.model.statement.AssertStatementTreeImpl;
import org.sonar.java.model.statement.BlockTreeImpl;
import org.sonar.java.model.statement.BreakStatementTreeImpl;
import org.sonar.java.model.statement.CaseGroupTreeImpl;
import org.sonar.java.model.statement.CaseLabelTreeImpl;
import org.sonar.java.model.statement.CatchTreeImpl;
import org.sonar.java.model.statement.ContinueStatementTreeImpl;
import org.sonar.java.model.statement.DoWhileStatementTreeImpl;
import org.sonar.java.model.statement.EmptyStatementTreeImpl;
import org.sonar.java.model.statement.ExpressionStatementTreeImpl;
import org.sonar.java.model.statement.ForEachStatementImpl;
import org.sonar.java.model.statement.ForStatementTreeImpl;
import org.sonar.java.model.statement.IfStatementTreeImpl;
import org.sonar.java.model.statement.LabeledStatementTreeImpl;
import org.sonar.java.model.statement.ReturnStatementTreeImpl;
import org.sonar.java.model.statement.StaticInitializerTreeImpl;
import org.sonar.java.model.statement.SwitchExpressionTreeImpl;
import org.sonar.java.model.statement.SwitchStatementTreeImpl;
import org.sonar.java.model.statement.SynchronizedStatementTreeImpl;
import org.sonar.java.model.statement.ThrowStatementTreeImpl;
import org.sonar.java.model.statement.TryStatementTreeImpl;
import org.sonar.java.model.statement.WhileStatementTreeImpl;
import org.sonar.java.model.statement.YieldStatementTreeImpl;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.ArrayDimensionTree;
import org.sonar.plugins.java.api.tree.ArrayTypeTree;
import org.sonar.plugins.java.api.tree.CatchTree;
import org.sonar.plugins.java.api.tree.CompilationUnitTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.ImportClauseTree;
import org.sonar.plugins.java.api.tree.InferedTypeTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifierTree;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.ModuleDeclarationTree;
import org.sonar.plugins.java.api.tree.ModuleDirectiveTree;
import org.sonar.plugins.java.api.tree.ModuleNameTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.SyntaxTrivia;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeParameterTree;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.plugins.java.api.tree.VariableTree;

@ParametersAreNonnullByDefault
public class JParser {
    private static final Logger LOG = Loggers.get(JParser.class);
    public static final String MAXIMUM_SUPPORTED_JAVA_VERSION = "14";
    private CompilationUnit compilationUnit;
    private TokenManager tokenManager;
    private JSema sema;
    private final Deque<JLabelSymbol> labels = new LinkedList<JLabelSymbol>();
    private static final int ANY_TOKEN = -1;
    private static final Map<Object, Op> operators = new HashMap<Object, Op>();

    public static CompilationUnitTree parse(String version, String unitName, String source, List<File> classpath) {
        CompilationUnit astNode;
        ASTParser astParser = ASTParser.newParser((int)14);
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("org.eclipse.jdt.core.compiler.compliance", version);
        options.put("org.eclipse.jdt.core.compiler.source", version);
        if (MAXIMUM_SUPPORTED_JAVA_VERSION.equals(version)) {
            options.put("org.eclipse.jdt.core.compiler.problem.enablePreviewFeatures", "enabled");
        }
        astParser.setCompilerOptions(options);
        astParser.setEnvironment((String[])classpath.stream().map(File::getAbsolutePath).toArray(String[]::new), new String[0], new String[0], true);
        astParser.setUnitName(unitName);
        astParser.setResolveBindings(true);
        astParser.setBindingsRecovery(true);
        char[] sourceChars = source.toCharArray();
        astParser.setSource(sourceChars);
        try {
            astNode = (CompilationUnit)astParser.createAST(null);
        }
        catch (Exception e) {
            LOG.error("ECJ: Unable to parse file", (Throwable)e);
            throw new RecognitionException(-1, "ECJ: Unable to parse file.", (Throwable)e);
        }
        for (IProblem problem : astNode.getProblems()) {
            if (!problem.isError() || (problem.getID() & 0x40000000) == 0) continue;
            int line = problem.getSourceLineNumber();
            int column = astNode.getColumnNumber(problem.getSourceStart());
            throw new RecognitionException(line, "Parse error at line " + line + " column " + column + ": " + problem.getMessage());
        }
        JParser converter = new JParser();
        converter.sema = new JSema(astNode.getAST());
        converter.compilationUnit = astNode;
        converter.tokenManager = new TokenManager(JParser.lex(version, unitName, sourceChars), source, new DefaultCodeFormatterOptions(new HashMap()));
        JavaTree.CompilationUnitTreeImpl tree = converter.convertCompilationUnit(astNode);
        tree.sema = converter.sema;
        ASTUtils.mayTolerateMissingType(astNode.getAST());
        JParser.setParents(tree);
        return tree;
    }

    private static void setParents(Tree node) {
        Iterator<Tree> childrenIterator = JParser.iteratorFor(node);
        while (childrenIterator.hasNext()) {
            Tree child = childrenIterator.next();
            ((JavaTree)child).setParent(node);
            JParser.setParents(child);
        }
    }

    private static Iterator<Tree> iteratorFor(Tree node) {
        if (node.kind() == Tree.Kind.INFERED_TYPE || node.kind() == Tree.Kind.TOKEN) {
            return Collections.emptyIterator();
        }
        return ((JavaTree)node).getChildren().iterator();
    }

    private static List<Token> lex(String version, String unitName, char[] sourceChars) {
        ArrayList<Token> tokens = new ArrayList<Token>();
        Scanner scanner = new Scanner(true, false, false, CompilerOptions.versionToJdkLevel((String)version), null, null, false);
        scanner.fakeInModule = "module-info.java".equals(unitName);
        scanner.setSource(sourceChars);
        try {
            int tokenType;
            do {
                tokenType = scanner.getNextToken();
                Token token = Token.fromCurrent((Scanner)scanner, (int)tokenType);
                tokens.add(token);
            } while (tokenType != 62);
        }
        catch (InvalidInputException e) {
            throw new IllegalStateException(e);
        }
        return tokens;
    }

    private void declaration(@Nullable IBinding binding, Tree node) {
        if (binding == null) {
            return;
        }
        this.sema.declarations.put(binding, node);
    }

    private void usage(@Nullable IBinding binding, IdentifierTree node) {
        if (binding == null) {
            return;
        }
        binding = JSema.declarationBinding(binding);
        this.sema.usages.computeIfAbsent(binding, k -> new ArrayList()).add(node);
    }

    private void usageLabel(@Nullable IdentifierTreeImpl node) {
        if (node == null) {
            return;
        }
        this.labels.stream().filter(symbol -> symbol.name().equals(node.name())).findFirst().ifPresent(labelSymbol -> {
            labelSymbol.usages.add(node);
            node.labelSymbol = labelSymbol;
        });
    }

    private int firstTokenIndexAfter(ASTNode e) {
        int index = this.tokenManager.firstIndexAfter(e, -1);
        while (this.tokenManager.get(index).isComment()) {
            ++index;
        }
        return index;
    }

    private int nextTokenIndex(int tokenIndex, int tokenType) {
        assert (tokenType != -1);
        while (this.tokenManager.get((int)(++tokenIndex)).tokenType != tokenType) {
        }
        return tokenIndex;
    }

    private InternalSyntaxToken firstTokenBefore(ASTNode e, int tokenType) {
        return this.createSyntaxToken(this.tokenManager.firstIndexBefore(e, tokenType));
    }

    private InternalSyntaxToken firstTokenAfter(ASTNode e, int tokenType) {
        return this.createSyntaxToken(this.tokenManager.firstIndexAfter(e, tokenType));
    }

    private InternalSyntaxToken firstTokenIn(ASTNode e, int tokenType) {
        return this.createSyntaxToken(this.tokenManager.firstIndexIn(e, tokenType));
    }

    private InternalSyntaxToken lastTokenIn(ASTNode e, int tokenType) {
        return this.createSyntaxToken(this.tokenManager.lastIndexIn(e, tokenType));
    }

    private InternalSyntaxToken createSyntaxToken(int tokenIndex) {
        Token t = this.tokenManager.get(tokenIndex);
        if (t.tokenType == 62) {
            if (t.originalStart == 0) {
                return new InternalSyntaxToken(1, 0, "", this.collectComments(tokenIndex), true);
            }
            int position = t.originalStart - 1;
            char c = this.tokenManager.getSource().charAt(position);
            int line = this.compilationUnit.getLineNumber(position);
            int column = this.compilationUnit.getColumnNumber(position);
            if (c == '\n' || c == '\r') {
                ++line;
                column = 0;
            } else {
                ++column;
            }
            return new InternalSyntaxToken(line, column, "", this.collectComments(tokenIndex), true);
        }
        return new InternalSyntaxToken(this.compilationUnit.getLineNumber(t.originalStart), this.compilationUnit.getColumnNumber(t.originalStart), t.toString(this.tokenManager.getSource()), this.collectComments(tokenIndex), false);
    }

    private InternalSyntaxToken createSpecialToken(int tokenIndex) {
        Token t = this.tokenManager.get(tokenIndex);
        List<SyntaxTrivia> comments = t.tokenType == 15 ? this.collectComments(tokenIndex) : Collections.emptyList();
        return new InternalSyntaxToken(this.compilationUnit.getLineNumber(t.originalEnd), this.compilationUnit.getColumnNumber(t.originalEnd), ">", comments, false);
    }

    private List<SyntaxTrivia> collectComments(int tokenIndex) {
        for (int commentIndex = tokenIndex; commentIndex > 0 && this.tokenManager.get(commentIndex - 1).isComment(); --commentIndex) {
        }
        ArrayList<SyntaxTrivia> comments = new ArrayList<SyntaxTrivia>();
        for (int i = commentIndex; i < tokenIndex; ++i) {
            Token t = this.tokenManager.get(i);
            comments.add(new InternalSyntaxTrivia(t.toString(this.tokenManager.getSource()), this.compilationUnit.getLineNumber(t.originalStart), this.compilationUnit.getColumnNumber(t.originalStart)));
        }
        return comments;
    }

    private void addEmptyDeclarationsToList(int tokenIndex, List list) {
        while (true) {
            Token token;
            if ((token = this.tokenManager.get(++tokenIndex)).isComment()) {
                continue;
            }
            if (token.tokenType != 25) break;
            list.add(new EmptyStatementTreeImpl(this.createSyntaxToken(tokenIndex)));
        }
    }

    private JavaTree.CompilationUnitTreeImpl convertCompilationUnit(CompilationUnit e) {
        JavaTree.PackageDeclarationTreeImpl packageDeclaration = null;
        if (e.getPackage() != null) {
            packageDeclaration = new JavaTree.PackageDeclarationTreeImpl(this.convertAnnotations(e.getPackage().annotations()), this.firstTokenIn((ASTNode)e.getPackage(), 88), this.convertExpression((Expression)e.getPackage().getName()), this.firstTokenIn((ASTNode)e.getPackage(), 25));
        }
        ArrayList<ImportClauseTree> imports = new ArrayList<ImportClauseTree>();
        for (int i = 0; i < e.imports().size(); ++i) {
            ImportDeclaration e2 = (ImportDeclaration)e.imports().get(i);
            ExpressionTree name = this.convertName(e2.getName());
            if (e2.isOnDemand()) {
                name = new MemberSelectExpressionTreeImpl(name, this.lastTokenIn((ASTNode)e2, 1), new IdentifierTreeImpl(this.lastTokenIn((ASTNode)e2, 8)));
            }
            JavaTree.ImportTreeImpl t = new JavaTree.ImportTreeImpl(this.firstTokenIn((ASTNode)e2, 109), e2.isStatic() ? this.firstTokenIn((ASTNode)e2, 39) : null, name, this.lastTokenIn((ASTNode)e2, 25));
            t.binding = e2.resolveBinding();
            imports.add(t);
            this.addEmptyDeclarationsToList(this.tokenManager.lastIndexIn((ASTNode)e2, 25), imports);
        }
        ArrayList<Tree> types = new ArrayList<Tree>();
        for (Object type : e.types()) {
            this.processBodyDeclaration((ASTNode)((AbstractTypeDeclaration)type), types);
        }
        if (e.imports().isEmpty() && e.types().isEmpty()) {
            this.addEmptyDeclarationsToList(-1, imports);
        }
        return new JavaTree.CompilationUnitTreeImpl(packageDeclaration, imports, types, this.convertModuleDeclaration(this.compilationUnit.getModule()), this.firstTokenAfter((ASTNode)e, 62));
    }

    @Nullable
    private ModuleDeclarationTree convertModuleDeclaration(@Nullable ModuleDeclaration e) {
        if (e == null) {
            return null;
        }
        ArrayList<ModuleDirectiveTree> moduleDirectives = new ArrayList<ModuleDirectiveTree>();
        for (Object o : e.moduleStatements()) {
            moduleDirectives.add(this.convertModuleDirective((ModuleDirective)o));
        }
        return new ModuleDeclarationTreeImpl(this.convertAnnotations(e.annotations()), e.isOpen() ? this.firstTokenIn((ASTNode)e, 119) : null, this.firstTokenBefore((ASTNode)e.getName(), 118), this.convertModuleName(e.getName()), this.firstTokenAfter((ASTNode)e.getName(), 37), moduleDirectives, this.lastTokenIn((ASTNode)e, 33));
    }

    private ModuleNameTreeImpl convertModuleName(Name node) {
        switch (node.getNodeType()) {
            case 40: {
                QualifiedName e = (QualifiedName)node;
                ModuleNameTreeImpl t = this.convertModuleName(e.getQualifier());
                t.add(new IdentifierTreeImpl(this.firstTokenIn((ASTNode)e.getName(), 21)));
                return t;
            }
            case 42: {
                SimpleName e = (SimpleName)node;
                ModuleNameTreeImpl t = new ModuleNameTreeImpl((List<IdentifierTree>)new ArrayList<IdentifierTree>(), Collections.emptyList());
                t.add(new IdentifierTreeImpl(this.firstTokenIn((ASTNode)e, 21)));
                return t;
            }
        }
        throw new IllegalStateException(ASTNode.nodeClassForType((int)node.getNodeType()).toString());
    }

    private ModuleNameListTreeImpl convertModuleNames(List<?> list) {
        ModuleNameListTreeImpl t = new ModuleNameListTreeImpl((List<ModuleNameTree>)new ArrayList<ModuleNameTree>(), (List<SyntaxToken>)new ArrayList<SyntaxToken>());
        for (int i = 0; i < list.size(); ++i) {
            Name o = (Name)list.get(i);
            if (i > 0) {
                t.separators().add(this.firstTokenBefore((ASTNode)o, 32));
            }
            t.add(this.convertModuleName(o));
        }
        return t;
    }

    private ModuleDirectiveTree convertModuleDirective(ModuleDirective node) {
        switch (node.getNodeType()) {
            case 94: {
                RequiresDirective e = (RequiresDirective)node;
                ArrayList<ModifierTree> modifiers = new ArrayList<ModifierTree>();
                block15: for (Object o : e.modifiers()) {
                    switch (((ModuleModifier)o).getKeyword().toString()) {
                        case "static": {
                            modifiers.add(new ModifierKeywordTreeImpl(Modifier.STATIC, this.firstTokenIn((ASTNode)o, -1)));
                            continue block15;
                        }
                        case "transitive": {
                            modifiers.add(new ModifierKeywordTreeImpl(Modifier.TRANSITIVE, this.firstTokenIn((ASTNode)o, -1)));
                            continue block15;
                        }
                    }
                    throw new IllegalStateException();
                }
                return new RequiresDirectiveTreeImpl(this.firstTokenIn((ASTNode)e, 120), new ModifiersTreeImpl((List<ModifierTree>)modifiers), this.convertModuleName(e.getName()), this.lastTokenIn((ASTNode)e, 25));
            }
            case 95: {
                ExportsDirective e = (ExportsDirective)node;
                return new ExportsDirectiveTreeImpl(this.firstTokenIn((ASTNode)e, 121), this.convertExpression((Expression)e.getName()), e.modules().isEmpty() ? null : this.firstTokenAfter((ASTNode)e.getName(), 128), this.convertModuleNames(e.modules()), this.lastTokenIn((ASTNode)e, 25));
            }
            case 96: {
                OpensDirective e = (OpensDirective)node;
                return new OpensDirectiveTreeImpl(this.firstTokenIn((ASTNode)e, 122), this.convertExpression((Expression)e.getName()), e.modules().isEmpty() ? null : this.firstTokenAfter((ASTNode)e.getName(), 128), this.convertModuleNames(e.modules()), this.lastTokenIn((ASTNode)e, 25));
            }
            case 97: {
                UsesDirective e = (UsesDirective)node;
                return new UsesDirectiveTreeImpl(this.firstTokenIn((ASTNode)e, 123), (TypeTree)((Object)this.convertExpression((Expression)e.getName())), this.lastTokenIn((ASTNode)e, 25));
            }
            case 98: {
                ProvidesDirective e = (ProvidesDirective)node;
                QualifiedIdentifierListTreeImpl typeNames = new QualifiedIdentifierListTreeImpl((List<TypeTree>)new ArrayList<TypeTree>(), (List<SyntaxToken>)new ArrayList<SyntaxToken>());
                for (int i = 0; i < e.implementations().size(); ++i) {
                    Name o = (Name)e.implementations().get(i);
                    if (i > 0) {
                        typeNames.separators().add(this.firstTokenBefore((ASTNode)o, 32));
                    }
                    typeNames.add((TypeTree)((Object)this.convertExpression((Expression)o)));
                }
                return new ProvidesDirectiveTreeImpl(this.firstTokenIn((ASTNode)e, 124), (TypeTree)((Object)this.convertExpression((Expression)e.getName())), this.firstTokenAfter((ASTNode)e.getName(), 129), typeNames, this.lastTokenIn((ASTNode)e, 25));
            }
        }
        throw new IllegalStateException(ASTNode.nodeClassForType((int)node.getNodeType()).toString());
    }

    private ClassTreeImpl convertTypeDeclaration(AbstractTypeDeclaration e) {
        SingleVariableDeclaration o;
        int i;
        TypeDeclaration ee;
        Tree.Kind kind;
        Object enumDeclaration;
        ArrayList<Tree> members = new ArrayList<Tree>();
        if (e.getNodeType() == 71) {
            for (Object o2 : ((EnumDeclaration)e).enumConstants()) {
                members.add(this.processEnumConstantDeclaration((EnumConstantDeclaration)o2));
            }
        }
        int leftBraceTokenIndex = e.getNodeType() == 71 ? (!(enumDeclaration = (EnumDeclaration)e).enumConstants().isEmpty() ? this.tokenManager.firstIndexBefore((ASTNode)enumDeclaration.enumConstants().get(0), 37) : (!enumDeclaration.bodyDeclarations().isEmpty() ? this.tokenManager.firstIndexBefore((ASTNode)e.bodyDeclarations().get(0), 37) : this.tokenManager.lastIndexIn((ASTNode)e, 37))) : (!e.bodyDeclarations().isEmpty() ? this.tokenManager.firstIndexBefore((ASTNode)e.bodyDeclarations().get(0), 37) : this.tokenManager.lastIndexIn((ASTNode)e, 37));
        this.addEmptyDeclarationsToList(leftBraceTokenIndex, members);
        for (Object o3 : e.bodyDeclarations()) {
            this.processBodyDeclaration((ASTNode)((BodyDeclaration)o3), members);
        }
        switch (e.getNodeType()) {
            case 71: {
                kind = Tree.Kind.ENUM;
                break;
            }
            case 81: {
                kind = Tree.Kind.ANNOTATION_TYPE;
                break;
            }
            case 55: {
                kind = ((TypeDeclaration)e).isInterface() ? Tree.Kind.INTERFACE : Tree.Kind.CLASS;
                break;
            }
            case 103: {
                kind = Tree.Kind.RECORD;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        ClassTreeImpl t = new ClassTreeImpl(kind, (SyntaxToken)this.createSyntaxToken(leftBraceTokenIndex), members, (SyntaxToken)this.lastTokenIn((ASTNode)e, 33)).completeModifiers(this.convertModifiers(e.modifiers()));
        switch (kind) {
            case ENUM: {
                t.completeDeclarationKeyword(this.firstTokenBefore((ASTNode)e.getName(), 72));
                t.completeIdentifier(this.convertSimpleName(e.getName()));
                break;
            }
            case CLASS: {
                t.completeDeclarationKeyword(this.firstTokenBefore((ASTNode)e.getName(), 68));
                t.completeIdentifier(this.convertSimpleName(e.getName()));
                break;
            }
            case INTERFACE: {
                t.completeDeclarationKeyword(this.firstTokenBefore((ASTNode)e.getName(), 71));
                t.completeIdentifier(this.convertSimpleName(e.getName()));
                break;
            }
            case RECORD: {
                t.completeDeclarationKeyword(this.firstTokenBefore((ASTNode)e.getName(), 21));
                t.completeIdentifier(this.convertSimpleName(e.getName()));
                break;
            }
            case ANNOTATION_TYPE: {
                t.complete(this.firstTokenBefore((ASTNode)e.getName(), 38), this.firstTokenBefore((ASTNode)e.getName(), 71), this.convertSimpleName(e.getName()));
                break;
            }
        }
        if (kind == Tree.Kind.CLASS || kind == Tree.Kind.INTERFACE) {
            ee = (TypeDeclaration)e;
            t.completeTypeParameters(this.convertTypeParameters(ee.typeParameters()));
        } else if (kind == Tree.Kind.RECORD) {
            ee = (RecordDeclaration)e;
            t.completeTypeParameters(this.convertTypeParameters(ee.typeParameters()));
            ArrayList<VariableTree> recordComponents = new ArrayList<VariableTree>();
            for (i = 0; i < ee.recordComponents().size(); ++i) {
                o = (SingleVariableDeclaration)ee.recordComponents().get(i);
                VariableTreeImpl recordComponent = this.createVariable(o);
                if (i < ee.recordComponents().size() - 1) {
                    recordComponent.setEndToken(this.firstTokenAfter((ASTNode)o, 32));
                }
                recordComponents.add(recordComponent);
            }
            t.completeRecordComponents(recordComponents);
        }
        switch (kind) {
            case CLASS: {
                ee = (TypeDeclaration)e;
                Type superclassType = ee.getSuperclassType();
                if (superclassType != null) {
                    t.completeSuperclass(this.firstTokenBefore((ASTNode)superclassType, 90), this.convertType(superclassType));
                }
            }
            case ENUM: 
            case INTERFACE: 
            case RECORD: {
                List<?> superInterfaceTypes = JParser.superInterfaceTypes(e);
                if (superInterfaceTypes.isEmpty()) break;
                QualifiedIdentifierListTreeImpl superInterfaces = new QualifiedIdentifierListTreeImpl((List<TypeTree>)new ArrayList<TypeTree>(), (List<SyntaxToken>)new ArrayList<SyntaxToken>());
                for (i = 0; i < superInterfaceTypes.size(); ++i) {
                    o = (Type)superInterfaceTypes.get(i);
                    if (i > 0) {
                        superInterfaces.separators().add(this.firstTokenBefore((ASTNode)o, 32));
                    }
                    superInterfaces.add(this.convertType((Type)o));
                }
                t.completeInterfaces(this.firstTokenBefore((ASTNode)superInterfaceTypes.get(0), kind == Tree.Kind.INTERFACE ? 90 : 127), superInterfaces);
                break;
            }
        }
        t.typeBinding = e.resolveBinding();
        this.declaration((IBinding)t.typeBinding, t);
        return t;
    }

    private static List<?> superInterfaceTypes(AbstractTypeDeclaration e) {
        switch (e.getNodeType()) {
            case 55: {
                return ((TypeDeclaration)e).superInterfaceTypes();
            }
            case 71: {
                return ((EnumDeclaration)e).superInterfaceTypes();
            }
            case 103: {
                return ((RecordDeclaration)e).superInterfaceTypes();
            }
        }
        throw new IllegalStateException();
    }

    private EnumConstantTreeImpl processEnumConstantDeclaration(EnumConstantDeclaration e) {
        InternalSyntaxToken separatorToken;
        InternalSyntaxToken closeParToken;
        InternalSyntaxToken openParToken;
        int openParTokenIndex = this.firstTokenIndexAfter((ASTNode)e.getName());
        if (this.tokenManager.get((int)openParTokenIndex).tokenType == 23) {
            openParToken = this.createSyntaxToken(openParTokenIndex);
            closeParToken = e.arguments().isEmpty() ? this.firstTokenAfter((ASTNode)e.getName(), 26) : this.firstTokenAfter((ASTNode)e.arguments().get(e.arguments().size() - 1), 26);
        } else {
            openParToken = null;
            closeParToken = null;
        }
        ArgumentListTreeImpl arguments = this.convertArguments(openParToken, e.arguments(), closeParToken);
        ClassTreeImpl classBody = null;
        if (e.getAnonymousClassDeclaration() != null) {
            ArrayList<Tree> members = new ArrayList<Tree>();
            for (Object o : e.getAnonymousClassDeclaration().bodyDeclarations()) {
                this.processBodyDeclaration((ASTNode)((BodyDeclaration)o), members);
            }
            classBody = new ClassTreeImpl(Tree.Kind.CLASS, (SyntaxToken)this.firstTokenIn((ASTNode)e.getAnonymousClassDeclaration(), 37), members, (SyntaxToken)this.lastTokenIn((ASTNode)e.getAnonymousClassDeclaration(), 33));
            classBody.typeBinding = e.getAnonymousClassDeclaration().resolveBinding();
            this.declaration((IBinding)classBody.typeBinding, classBody);
        }
        int separatorTokenIndex = this.firstTokenIndexAfter((ASTNode)e);
        switch (this.tokenManager.get((int)separatorTokenIndex).tokenType) {
            case 25: 
            case 32: {
                separatorToken = this.createSyntaxToken(separatorTokenIndex);
                break;
            }
            case 33: {
                separatorToken = null;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        IdentifierTreeImpl identifier = this.convertSimpleName(e.getName());
        identifier.binding = e.getAnonymousClassDeclaration() == null ? JParser.excludeRecovery(e.resolveConstructorBinding(), arguments.size()) : JParser.findConstructorForAnonymousClass(e.getAST(), identifier.typeBinding, e.resolveConstructorBinding());
        this.usage(identifier.binding, identifier);
        EnumConstantTreeImpl t = new EnumConstantTreeImpl(this.convertModifiers(e.modifiers()), identifier, new NewClassTreeImpl(arguments, classBody).completeWithIdentifier(identifier), separatorToken);
        t.variableBinding = e.resolveVariable();
        this.declaration((IBinding)t.variableBinding, t);
        return t;
    }

    private void processBodyDeclaration(ASTNode node, List<Tree> members) {
        int lastTokenIndex;
        switch (node.getNodeType()) {
            case 55: 
            case 71: 
            case 81: 
            case 103: {
                members.add(this.convertTypeDeclaration((AbstractTypeDeclaration)node));
                lastTokenIndex = this.tokenManager.lastIndexIn(node, 33);
                break;
            }
            case 82: {
                AnnotationTypeMemberDeclaration e = (AnnotationTypeMemberDeclaration)node;
                MethodTreeImpl t = new MethodTreeImpl(new FormalParametersListTreeImpl(this.firstTokenAfter((ASTNode)e.getName(), 23), this.firstTokenAfter((ASTNode)e.getName(), 26)), e.getDefault() == null ? null : this.firstTokenBefore((ASTNode)e.getDefault(), 74), e.getDefault() == null ? null : this.convertExpression(e.getDefault())).complete(this.convertType(e.getType()), this.convertSimpleName(e.getName()), this.lastTokenIn((ASTNode)e, 25)).completeWithModifiers(this.convertModifiers(e.modifiers()));
                t.methodBinding = e.resolveBinding();
                this.declaration((IBinding)t.methodBinding, t);
                members.add(t);
                lastTokenIndex = this.tokenManager.lastIndexIn(node, 25);
                break;
            }
            case 28: {
                Initializer e = (Initializer)node;
                BlockTreeImpl blockTree = this.convertBlock(e.getBody());
                if (org.eclipse.jdt.core.dom.Modifier.isStatic((int)e.getModifiers())) {
                    members.add(new StaticInitializerTreeImpl(this.firstTokenIn((ASTNode)e, 39), (InternalSyntaxToken)blockTree.openBraceToken(), blockTree.body(), (InternalSyntaxToken)blockTree.closeBraceToken()));
                } else {
                    members.add(new BlockTreeImpl(Tree.Kind.INITIALIZER, (InternalSyntaxToken)blockTree.openBraceToken(), blockTree.body(), (InternalSyntaxToken)blockTree.closeBraceToken()));
                }
                lastTokenIndex = this.tokenManager.lastIndexIn(node, 33);
                break;
            }
            case 31: {
                MethodDeclaration e = (MethodDeclaration)node;
                FormalParametersListTreeImpl parameters = e.getAST().isPreviewEnabled() && e.isCompactConstructor() ? new FormalParametersListTreeImpl(null, null) : new FormalParametersListTreeImpl(this.firstTokenAfter((ASTNode)e.getName(), 23), this.firstTokenAfter((ASTNode)(e.parameters().isEmpty() ? e.getName() : (ASTNode)e.parameters().get(e.parameters().size() - 1)), 26));
                for (int i = 0; i < e.parameters().size(); ++i) {
                    SingleVariableDeclaration o = (SingleVariableDeclaration)e.parameters().get(i);
                    VariableTreeImpl parameter = this.createVariable(o);
                    if (i < e.parameters().size() - 1) {
                        parameter.setEndToken(this.firstTokenAfter((ASTNode)o, 32));
                    }
                    parameters.add(parameter);
                }
                QualifiedIdentifierListTreeImpl thrownExceptionTypes = new QualifiedIdentifierListTreeImpl((List<TypeTree>)new ArrayList<TypeTree>(), (List<SyntaxToken>)new ArrayList<SyntaxToken>());
                for (int i = 0; i < e.thrownExceptionTypes().size(); ++i) {
                    Type o = (Type)e.thrownExceptionTypes().get(i);
                    if (i > 0) {
                        thrownExceptionTypes.separators().add(this.firstTokenBefore((ASTNode)o, 32));
                    }
                    thrownExceptionTypes.add(this.convertType(o));
                }
                Block body = e.getBody();
                Type returnType = e.getReturnType2();
                MethodTreeImpl t = new MethodTreeImpl(returnType == null ? null : this.applyExtraDimensions(this.convertType(returnType), e.extraDimensions()), this.convertSimpleName(e.getName()), parameters, e.thrownExceptionTypes().isEmpty() ? null : this.firstTokenBefore((ASTNode)((Type)e.thrownExceptionTypes().get(0)), 115), thrownExceptionTypes, body == null ? null : this.convertBlock(body), body == null ? this.lastTokenIn((ASTNode)e, 25) : null).completeWithModifiers(this.convertModifiers(e.modifiers())).completeWithTypeParameters(this.convertTypeParameters(e.typeParameters()));
                t.methodBinding = e.resolveBinding();
                this.declaration((IBinding)t.methodBinding, t);
                members.add(t);
                lastTokenIndex = this.tokenManager.lastIndexIn(node, body == null ? 25 : 33);
                break;
            }
            case 23: {
                FieldDeclaration fieldDeclaration = (FieldDeclaration)node;
                ModifiersTreeImpl modifiers = this.convertModifiers(fieldDeclaration.modifiers());
                TypeTree type = this.convertType(fieldDeclaration.getType());
                for (int i = 0; i < fieldDeclaration.fragments().size(); ++i) {
                    VariableDeclarationFragment fragment = (VariableDeclarationFragment)fieldDeclaration.fragments().get(i);
                    VariableTreeImpl t = new VariableTreeImpl(this.convertSimpleName(fragment.getName())).completeModifiersAndType(modifiers, this.applyExtraDimensions(type, fragment.extraDimensions()));
                    if (fragment.getInitializer() != null) {
                        t.completeTypeAndInitializer(t.type(), this.firstTokenAfter((ASTNode)fragment.getName(), 75), this.convertExpression(fragment.getInitializer()));
                    }
                    t.setEndToken(this.firstTokenAfter((ASTNode)fragment, i + 1 < fieldDeclaration.fragments().size() ? 32 : 25));
                    t.variableBinding = fragment.resolveBinding();
                    this.declaration((IBinding)t.variableBinding, t);
                    members.add(t);
                }
                lastTokenIndex = this.tokenManager.lastIndexIn(node, 25);
                break;
            }
            default: {
                throw new IllegalStateException(ASTNode.nodeClassForType((int)node.getNodeType()).toString());
            }
        }
        this.addEmptyDeclarationsToList(lastTokenIndex, members);
    }

    private ArgumentListTreeImpl convertArguments(InternalSyntaxToken openParen, List<?> list, InternalSyntaxToken closeParen) {
        ArgumentListTreeImpl arguments = new ArgumentListTreeImpl((List<ExpressionTree>)new ArrayList<ExpressionTree>(), (List<SyntaxToken>)new ArrayList<SyntaxToken>()).complete(openParen, closeParen);
        for (int i = 0; i < list.size(); ++i) {
            Expression o = (Expression)list.get(i);
            arguments.add(this.convertExpression(o));
            if (i >= list.size() - 1) continue;
            arguments.separators().add(this.firstTokenAfter((ASTNode)o, 32));
        }
        return arguments;
    }

    @Nullable
    private TypeArgumentListTreeImpl convertTypeArguments(List<?> list) {
        if (list.isEmpty()) {
            return null;
        }
        ASTNode last = (ASTNode)list.get(list.size() - 1);
        int tokenIndex = this.tokenManager.firstIndexAfter(last, -1);
        while (this.tokenManager.get(tokenIndex).isComment()) {
            ++tokenIndex;
        }
        return this.convertTypeArguments(this.firstTokenBefore((ASTNode)list.get(0), 11), list, this.createSpecialToken(tokenIndex));
    }

    private TypeArgumentListTreeImpl convertTypeArguments(InternalSyntaxToken l, List<?> list, InternalSyntaxToken g) {
        TypeArgumentListTreeImpl typeArguments = new TypeArgumentListTreeImpl(l, new ArrayList<Tree>(), new ArrayList<SyntaxToken>(), g);
        for (int i = 0; i < list.size(); ++i) {
            Type o = (Type)list.get(i);
            if (i > 0) {
                typeArguments.separators().add(this.firstTokenBefore((ASTNode)o, 32));
            }
            typeArguments.add(this.convertType(o));
        }
        return typeArguments;
    }

    private TypeParameterListTreeImpl convertTypeParameters(List<?> list) {
        if (list.isEmpty()) {
            return new TypeParameterListTreeImpl();
        }
        ASTNode last = (ASTNode)list.get(list.size() - 1);
        int tokenIndex = this.tokenManager.firstIndexAfter(last, -1);
        while (this.tokenManager.get(tokenIndex).isComment()) {
            ++tokenIndex;
        }
        TypeParameterListTreeImpl t = new TypeParameterListTreeImpl(this.firstTokenBefore((ASTNode)list.get(0), 11), new ArrayList<TypeParameterTree>(), new ArrayList<SyntaxToken>(), this.createSpecialToken(tokenIndex));
        for (int i = 0; i < list.size(); ++i) {
            TypeParameter o = (TypeParameter)list.get(i);
            if (i > 0) {
                t.separators().add(this.firstTokenBefore((ASTNode)o, 32));
            }
            t.add(this.convertTypeParameter(o));
        }
        return t;
    }

    private TypeParameterTree convertTypeParameter(TypeParameter e) {
        TypeParameterTreeImpl t;
        IdentifierTreeImpl i = this.convertSimpleName(e.getName());
        i.complete(this.convertAnnotations(e.modifiers()));
        List typeBounds = e.typeBounds();
        if (typeBounds.isEmpty()) {
            t = new TypeParameterTreeImpl(i);
        } else {
            BoundListTreeImpl bounds = new BoundListTreeImpl(new ArrayList(), (List<SyntaxToken>)new ArrayList<SyntaxToken>());
            for (int j = 0; j < typeBounds.size(); ++j) {
                Object o = typeBounds.get(j);
                bounds.add(this.convertType((Type)o));
                if (j >= typeBounds.size() - 1) continue;
                bounds.separators().add(this.firstTokenAfter((ASTNode)o, 22));
            }
            t = new TypeParameterTreeImpl(this.firstTokenAfter((ASTNode)e.getName(), 90), bounds).complete(i);
        }
        t.typeBinding = e.resolveBinding();
        return t;
    }

    private TypeTree applyExtraDimensions(TypeTree type, List<?> extraDimensions) {
        ITypeBinding typeBinding = ((AbstractTypedTree)((Object)type)).typeBinding;
        for (int i = 0; i < extraDimensions.size(); ++i) {
            Dimension e = (Dimension)extraDimensions.get(i);
            type = new JavaTree.ArrayTypeTreeImpl(type, this.convertAnnotations(e.annotations()), this.firstTokenIn((ASTNode)e, 6), this.firstTokenIn((ASTNode)e, 67));
            if (typeBinding == null) continue;
            ((JavaTree.ArrayTypeTreeImpl)type).typeBinding = typeBinding.createArrayType(i + 1);
        }
        return type;
    }

    private VariableTreeImpl createVariable(SingleVariableDeclaration e) {
        TypeTree type = this.convertType(e.getType());
        type = this.applyExtraDimensions(type, e.extraDimensions());
        if (e.isVarargs()) {
            ITypeBinding typeBinding = ((AbstractTypedTree)((Object)type)).typeBinding;
            type = new JavaTree.ArrayTypeTreeImpl(type, this.convertAnnotations(e.varargsAnnotations()), this.firstTokenAfter((ASTNode)e.getType(), 116));
            if (typeBinding != null) {
                ((JavaTree.ArrayTypeTreeImpl)type).typeBinding = typeBinding.createArrayType(1);
            }
        }
        VariableTreeImpl t = new VariableTreeImpl((ModifiersTree)this.convertModifiers(e.modifiers()), type, this.convertSimpleName(e.getName()));
        if (e.getInitializer() != null) {
            t.completeTypeAndInitializer(t.type(), this.firstTokenAfter((ASTNode)e.getName(), 75), this.convertExpression(e.getInitializer()));
        }
        t.variableBinding = e.resolveBinding();
        this.declaration((IBinding)t.variableBinding, t);
        return t;
    }

    private void addVariableToList(VariableDeclarationExpression e2, List list) {
        ModifiersTreeImpl modifiers = this.convertModifiers(e2.modifiers());
        TypeTree type = this.convertType(e2.getType());
        for (int i = 0; i < e2.fragments().size(); ++i) {
            VariableDeclarationFragment fragment = (VariableDeclarationFragment)e2.fragments().get(i);
            VariableTreeImpl t = new VariableTreeImpl(this.convertSimpleName(fragment.getName()));
            t.completeModifiers(modifiers);
            if (fragment.getInitializer() == null) {
                t.completeType(type);
            } else {
                t.completeTypeAndInitializer(type, this.firstTokenBefore((ASTNode)fragment.getInitializer(), 75), this.convertExpression(fragment.getInitializer()));
            }
            if (i < e2.fragments().size() - 1) {
                t.setEndToken(this.firstTokenAfter((ASTNode)fragment, 32));
            }
            t.variableBinding = fragment.resolveBinding();
            this.declaration((IBinding)t.variableBinding, t);
            list.add(t);
        }
    }

    private VarTypeTreeImpl convertVarType(SimpleType simpleType) {
        VarTypeTreeImpl varTree = new VarTypeTreeImpl(this.firstTokenIn((ASTNode)simpleType.getName(), 21));
        varTree.typeBinding = simpleType.resolveBinding();
        return varTree;
    }

    private IdentifierTreeImpl convertSimpleName(SimpleName e) {
        IdentifierTreeImpl t = new IdentifierTreeImpl(this.firstTokenIn((ASTNode)e, 21));
        t.typeBinding = e.resolveTypeBinding();
        t.binding = e.resolveBinding();
        return t;
    }

    private ExpressionTree convertName(Name node) {
        switch (node.getNodeType()) {
            case 42: {
                SimpleName e = (SimpleName)node;
                return new IdentifierTreeImpl(this.firstTokenIn((ASTNode)e, 21));
            }
            case 40: {
                QualifiedName e = (QualifiedName)node;
                IdentifierTreeImpl rhs = (IdentifierTreeImpl)this.convertName((Name)e.getName());
                return new MemberSelectExpressionTreeImpl(this.convertName(e.getQualifier()), this.firstTokenAfter((ASTNode)e.getQualifier(), 1), rhs);
            }
        }
        throw new IllegalStateException(ASTNode.nodeClassForType((int)node.getNodeType()).toString());
    }

    private BlockTreeImpl convertBlock(Block e) {
        ArrayList<StatementTree> statements = new ArrayList<StatementTree>();
        for (Object o : e.statements()) {
            this.addStatementToList((Statement)o, statements);
        }
        return new BlockTreeImpl(this.firstTokenIn((ASTNode)e, 37), statements, this.lastTokenIn((ASTNode)e, 33));
    }

    private void addStatementToList(Statement node, List<StatementTree> statements) {
        if (node.getNodeType() == 60) {
            VariableDeclarationStatement e = (VariableDeclarationStatement)node;
            TypeTree tType = this.convertType(e.getType());
            ModifiersTreeImpl modifiers = this.convertModifiers(e.modifiers());
            for (int i = 0; i < e.fragments().size(); ++i) {
                VariableDeclarationFragment fragment = (VariableDeclarationFragment)e.fragments().get(i);
                VariableTreeImpl t = new VariableTreeImpl(this.convertSimpleName(fragment.getName())).completeType(this.applyExtraDimensions(tType, fragment.extraDimensions())).completeModifiers(modifiers);
                Expression initalizer = fragment.getInitializer();
                if (initalizer != null) {
                    t.completeTypeAndInitializer(t.type(), this.firstTokenAfter((ASTNode)fragment.getName(), 75), this.convertExpression(initalizer));
                }
                t.setEndToken(this.firstTokenAfter((ASTNode)fragment, i < e.fragments().size() - 1 ? 32 : 25));
                t.variableBinding = fragment.resolveBinding();
                this.declaration((IBinding)t.variableBinding, t);
                statements.add(t);
            }
        } else if (node.getNodeType() != 10 || node.getLength() >= "break".length()) {
            statements.add(this.convertStatement(node));
        }
    }

    private StatementTree convertStatement(Statement node) {
        switch (node.getNodeType()) {
            case 8: {
                return this.convertBlock((Block)node);
            }
            case 20: {
                EmptyStatement e = (EmptyStatement)node;
                return new EmptyStatementTreeImpl(this.lastTokenIn((ASTNode)e, 25));
            }
            case 41: {
                ReturnStatement e = (ReturnStatement)node;
                Expression expression = e.getExpression();
                return new ReturnStatementTreeImpl(this.firstTokenIn((ASTNode)e, 85), expression == null ? null : this.convertExpression(expression), this.lastTokenIn((ASTNode)e, 25));
            }
            case 24: {
                ForStatement e = (ForStatement)node;
                StatementExpressionListTreeImpl forInitStatement = new StatementExpressionListTreeImpl(new ArrayList(), (List<SyntaxToken>)new ArrayList<SyntaxToken>());
                for (int i = 0; i < e.initializers().size(); ++i) {
                    Expression o = (Expression)e.initializers().get(i);
                    if (i > 0) {
                        forInitStatement.separators().add(this.firstTokenBefore((ASTNode)o, 32));
                    }
                    if (58 == o.getNodeType()) {
                        this.addVariableToList((VariableDeclarationExpression)o, forInitStatement);
                        continue;
                    }
                    forInitStatement.add(new ExpressionStatementTreeImpl(this.convertExpression(o), null));
                }
                StatementExpressionListTreeImpl forUpdateStatement = new StatementExpressionListTreeImpl(new ArrayList(), (List<SyntaxToken>)new ArrayList<SyntaxToken>());
                for (int i = 0; i < e.updaters().size(); ++i) {
                    Expression o = (Expression)e.updaters().get(i);
                    if (i > 0) {
                        forUpdateStatement.separators().add(this.firstTokenBefore((ASTNode)o, 32));
                    }
                    forUpdateStatement.add(new ExpressionStatementTreeImpl(this.convertExpression(o), null));
                }
                int firstSemicolonTokenIndex = e.initializers().isEmpty() ? this.tokenManager.firstIndexIn((ASTNode)e, 25) : this.tokenManager.firstIndexAfter((ASTNode)e.initializers().get(e.initializers().size() - 1), 25);
                Expression expression = e.getExpression();
                int secondSemicolonTokenIndex = expression == null ? this.nextTokenIndex(firstSemicolonTokenIndex, 25) : this.tokenManager.firstIndexAfter((ASTNode)expression, 25);
                return new ForStatementTreeImpl(this.firstTokenIn((ASTNode)e, 83), this.firstTokenIn((ASTNode)e, 23), forInitStatement, this.createSyntaxToken(firstSemicolonTokenIndex), expression == null ? null : this.convertExpression(expression), this.createSyntaxToken(secondSemicolonTokenIndex), forUpdateStatement, this.firstTokenBefore((ASTNode)e.getBody(), 26), this.convertStatement(e.getBody()));
            }
            case 61: {
                WhileStatement e = (WhileStatement)node;
                return new WhileStatementTreeImpl(this.firstTokenIn((ASTNode)e, 77), this.firstTokenBefore((ASTNode)e.getExpression(), 23), this.convertExpression(e.getExpression()), this.firstTokenAfter((ASTNode)e.getExpression(), 26), this.convertStatement(e.getBody()));
            }
            case 25: {
                IfStatement e = (IfStatement)node;
                Expression expression = e.getExpression();
                Statement elseStatement = e.getElseStatement();
                if (elseStatement != null) {
                    return new IfStatementTreeImpl(this.firstTokenAfter((ASTNode)e.getThenStatement(), 117), this.convertStatement(elseStatement)).complete(this.firstTokenIn((ASTNode)e, 84), this.firstTokenBefore((ASTNode)expression, 23), this.convertExpression(expression), this.firstTokenAfter((ASTNode)expression, 26), this.convertStatement(e.getThenStatement()));
                }
                return new IfStatementTreeImpl(this.firstTokenIn((ASTNode)e, 84), this.firstTokenBefore((ASTNode)expression, 23), this.convertExpression(expression), this.firstTokenAfter((ASTNode)expression, 26), this.convertStatement(e.getThenStatement()));
            }
            case 10: {
                BreakStatement e = (BreakStatement)node;
                IdentifierTreeImpl identifier = e.getLabel() == null ? null : this.convertSimpleName(e.getLabel());
                this.usageLabel(identifier);
                return new BreakStatementTreeImpl(this.firstTokenIn((ASTNode)e, 80), identifier, this.lastTokenIn((ASTNode)e, 25));
            }
            case 19: {
                DoStatement e = (DoStatement)node;
                return new DoWhileStatementTreeImpl(this.firstTokenIn((ASTNode)e, 82), this.convertStatement(e.getBody()), this.firstTokenAfter((ASTNode)e.getBody(), 77), this.firstTokenBefore((ASTNode)e.getExpression(), 23), this.convertExpression(e.getExpression()), this.firstTokenAfter((ASTNode)e.getExpression(), 26), this.lastTokenIn((ASTNode)e, 25));
            }
            case 6: {
                AssertStatement e = (AssertStatement)node;
                if (e.getMessage() != null) {
                    return new AssertStatementTreeImpl(this.firstTokenBefore((ASTNode)e.getMessage(), 63), this.convertExpression(e.getMessage())).complete(this.firstTokenIn((ASTNode)e, 79), this.convertExpression(e.getExpression()), this.lastTokenIn((ASTNode)e, 25));
                }
                return new AssertStatementTreeImpl(this.firstTokenIn((ASTNode)e, 79), this.convertExpression(e.getExpression()), this.lastTokenIn((ASTNode)e, 25));
            }
            case 50: {
                SwitchStatement e = (SwitchStatement)node;
                return new SwitchStatementTreeImpl(new SwitchExpressionTreeImpl(this.firstTokenIn((ASTNode)e, 61), this.firstTokenBefore((ASTNode)e.getExpression(), 23), this.convertExpression(e.getExpression()), this.firstTokenAfter((ASTNode)e.getExpression(), 26), this.firstTokenAfter((ASTNode)e.getExpression(), 37), this.convertSwitchStatements(e.statements()), this.lastTokenIn((ASTNode)e, 33)));
            }
            case 51: {
                SynchronizedStatement e = (SynchronizedStatement)node;
                return new SynchronizedStatementTreeImpl(this.firstTokenIn((ASTNode)e, 40), this.firstTokenBefore((ASTNode)e.getExpression(), 23), this.convertExpression(e.getExpression()), this.firstTokenAfter((ASTNode)e.getExpression(), 26), this.convertBlock(e.getBody()));
            }
            case 21: {
                ExpressionStatement e = (ExpressionStatement)node;
                return new ExpressionStatementTreeImpl(this.convertExpression(e.getExpression()), this.lastTokenIn((ASTNode)e, 25));
            }
            case 18: {
                ContinueStatement e = (ContinueStatement)node;
                SimpleName label = e.getLabel();
                IdentifierTreeImpl i = label == null ? null : this.convertSimpleName(label);
                this.usageLabel(i);
                return new ContinueStatementTreeImpl(this.firstTokenIn((ASTNode)e, 81), i, this.lastTokenIn((ASTNode)e, 25));
            }
            case 30: {
                LabeledStatement e = (LabeledStatement)node;
                IdentifierTreeImpl i = this.convertSimpleName(e.getLabel());
                JLabelSymbol symbol = new JLabelSymbol(i.name());
                this.labels.push(symbol);
                LabeledStatementTreeImpl t = new LabeledStatementTreeImpl(i, this.firstTokenAfter((ASTNode)e.getLabel(), 63), this.convertStatement(e.getBody()));
                this.labels.pop();
                symbol.declaration = t;
                t.labelSymbol = symbol;
                return t;
            }
            case 70: {
                EnhancedForStatement e = (EnhancedForStatement)node;
                return new ForEachStatementImpl(this.firstTokenIn((ASTNode)e, 83), this.firstTokenBefore((ASTNode)e.getParameter(), 23), this.createVariable(e.getParameter()), this.firstTokenAfter((ASTNode)e.getParameter(), 63), this.convertExpression(e.getExpression()), this.firstTokenAfter((ASTNode)e.getExpression(), 26), this.convertStatement(e.getBody()));
            }
            case 53: {
                ThrowStatement e = (ThrowStatement)node;
                return new ThrowStatementTreeImpl(this.firstTokenIn((ASTNode)e, 76), this.convertExpression(e.getExpression()), this.firstTokenAfter((ASTNode)e.getExpression(), 25));
            }
            case 54: {
                TryStatement e = (TryStatement)node;
                ArrayList<CatchTree> catches = new ArrayList<CatchTree>();
                for (Object o : e.catchClauses()) {
                    CatchClause e2 = (CatchClause)o;
                    catches.add(new CatchTreeImpl(this.firstTokenIn((ASTNode)e2, 105), this.firstTokenBefore((ASTNode)e2.getException(), 23), this.createVariable(e2.getException()), this.firstTokenAfter((ASTNode)e2.getException(), 26), this.convertBlock(e2.getBody())));
                }
                ResourceListTreeImpl resources = new ResourceListTreeImpl((List<Tree>)new ArrayList<Tree>(), (List<SyntaxToken>)new ArrayList<SyntaxToken>());
                block26: for (int i = 0; i < e.resources().size(); ++i) {
                    Expression o = (Expression)e.resources().get(i);
                    if (58 == o.getNodeType()) {
                        this.addVariableToList((VariableDeclarationExpression)o, resources);
                    } else {
                        resources.add(this.convertExpression(o));
                    }
                    if (i < e.resources().size() - 1) {
                        resources.separators().add(this.firstTokenAfter((ASTNode)o, 25));
                        continue;
                    }
                    int tokenIndex = this.tokenManager.firstIndexBefore((ASTNode)e.getBody(), 26);
                    while (true) {
                        Token token;
                        if ((token = this.tokenManager.get(--tokenIndex)).isComment()) {
                            continue;
                        }
                        if (token.tokenType != 25) continue block26;
                        resources.separators().add(this.createSyntaxToken(tokenIndex));
                    }
                }
                Block f = e.getFinally();
                return new TryStatementTreeImpl(this.firstTokenIn((ASTNode)e, 86), e.resources().isEmpty() ? null : this.firstTokenIn((ASTNode)e, 23), resources, e.resources().isEmpty() ? null : this.firstTokenBefore((ASTNode)e.getBody(), 26), this.convertBlock(e.getBody()), catches, f == null ? null : this.firstTokenBefore((ASTNode)f, 114), f == null ? null : this.convertBlock(f));
            }
            case 56: {
                TypeDeclarationStatement e = (TypeDeclarationStatement)node;
                return this.convertTypeDeclaration(e.getDeclaration());
            }
            case 17: {
                ConstructorInvocation e = (ConstructorInvocation)node;
                ArgumentListTreeImpl arguments = this.convertArguments(e.arguments().isEmpty() ? this.lastTokenIn((ASTNode)e, 23) : this.firstTokenBefore((ASTNode)e.arguments().get(0), 23), e.arguments(), this.lastTokenIn((ASTNode)e, 26));
                IdentifierTreeImpl i = new IdentifierTreeImpl(e.arguments().isEmpty() ? this.lastTokenIn((ASTNode)e, 35) : this.firstTokenBefore((ASTNode)e.arguments().get(0), 35));
                MethodInvocationTreeImpl t = new MethodInvocationTreeImpl(i, this.convertTypeArguments(e.typeArguments()), arguments);
                t.methodBinding = e.resolveConstructorBinding();
                if (t.methodBinding != null) {
                    t.typeBinding = t.methodBinding.getDeclaringClass();
                    t.methodBinding = JParser.excludeRecovery(t.methodBinding, arguments.size());
                }
                i.binding = t.methodBinding;
                this.usage(i.binding, i);
                return new ExpressionStatementTreeImpl(t, this.lastTokenIn((ASTNode)e, 25));
            }
            case 46: {
                IdentifierTreeImpl i;
                SuperConstructorInvocation e = (SuperConstructorInvocation)node;
                AssessableExpressionTree methodSelect = i = new IdentifierTreeImpl(this.firstTokenIn((ASTNode)e, 34));
                if (e.getExpression() != null) {
                    methodSelect = new MemberSelectExpressionTreeImpl(this.convertExpression(e.getExpression()), this.firstTokenAfter((ASTNode)e.getExpression(), 1), i);
                }
                ArgumentListTreeImpl arguments = this.convertArguments(this.firstTokenIn((ASTNode)e, 23), e.arguments(), this.lastTokenIn((ASTNode)e, 26));
                MethodInvocationTreeImpl t = new MethodInvocationTreeImpl(methodSelect, this.convertTypeArguments(e.typeArguments()), arguments);
                t.methodBinding = e.resolveConstructorBinding();
                if (t.methodBinding != null) {
                    t.typeBinding = t.methodBinding.getDeclaringClass();
                    t.methodBinding = JParser.excludeRecovery(t.methodBinding, arguments.size());
                }
                i.binding = t.methodBinding;
                this.usage(i.binding, i);
                return new ExpressionStatementTreeImpl(t, this.lastTokenIn((ASTNode)e, 25));
            }
            case 101: {
                YieldStatement e = (YieldStatement)node;
                return new YieldStatementTreeImpl(e.isImplicit() ? null : this.firstTokenIn((ASTNode)e, -1), this.convertExpression(e.getExpression()), this.lastTokenIn((ASTNode)e, 25));
            }
        }
        throw new IllegalStateException(ASTNode.nodeClassForType((int)node.getNodeType()).toString());
    }

    private List<CaseGroupTreeImpl> convertSwitchStatements(List<?> list) {
        ArrayList<CaseGroupTreeImpl> groups = new ArrayList<CaseGroupTreeImpl>();
        ArrayList<CaseLabelTreeImpl> caselabels = null;
        BlockStatementListTreeImpl body = null;
        for (Object o : list) {
            if (o instanceof SwitchCase) {
                if (caselabels == null) {
                    caselabels = new ArrayList<CaseLabelTreeImpl>();
                    body = new BlockStatementListTreeImpl(new ArrayList());
                }
                SwitchCase c = (SwitchCase)o;
                ArrayList<ExpressionTree> expressions = new ArrayList<ExpressionTree>();
                for (Object oo : c.expressions()) {
                    expressions.add(this.convertExpression((Expression)oo));
                }
                caselabels.add(new CaseLabelTreeImpl(this.firstTokenIn((ASTNode)c, c.isDefault() ? 74 : 89), expressions, this.lastTokenIn((ASTNode)c, -1)));
                continue;
            }
            if (caselabels != null) {
                groups.add(new CaseGroupTreeImpl(caselabels, body));
            }
            caselabels = null;
            this.addStatementToList((Statement)o, body);
        }
        if (caselabels != null) {
            groups.add(new CaseGroupTreeImpl(caselabels, body));
        }
        return groups;
    }

    private ExpressionTree convertExpression(Expression node) {
        ExpressionTree t = this.createExpression(node);
        ((AbstractTypedTree)((Object)t)).typeBinding = node.resolveTypeBinding();
        return t;
    }

    private ExpressionTree createExpression(Expression node) {
        switch (node.getNodeType()) {
            case 42: {
                SimpleName e = (SimpleName)node;
                IdentifierTreeImpl t = this.convertSimpleName(e);
                this.usage(t.binding, t);
                return t;
            }
            case 40: {
                QualifiedName e = (QualifiedName)node;
                IdentifierTreeImpl rhs = this.convertSimpleName(e.getName());
                this.usage(rhs.binding, rhs);
                return new MemberSelectExpressionTreeImpl(this.convertExpression((Expression)e.getQualifier()), this.firstTokenAfter((ASTNode)e.getQualifier(), 1), rhs);
            }
            case 22: {
                FieldAccess e = (FieldAccess)node;
                IdentifierTreeImpl rhs = this.convertSimpleName(e.getName());
                this.usage(rhs.binding, rhs);
                return new MemberSelectExpressionTreeImpl(this.convertExpression(e.getExpression()), this.firstTokenAfter((ASTNode)e.getExpression(), 1), rhs);
            }
            case 47: {
                SuperFieldAccess e = (SuperFieldAccess)node;
                IdentifierTreeImpl rhs = this.convertSimpleName(e.getName());
                this.usage(rhs.binding, rhs);
                if (e.getQualifier() == null) {
                    return new MemberSelectExpressionTreeImpl(this.unqualifiedKeywordSuper((ASTNode)e), this.firstTokenIn((ASTNode)e, 1), rhs);
                }
                AbstractTypedTree qualifier = (AbstractTypedTree)((Object)this.convertExpression((Expression)e.getQualifier()));
                KeywordSuper keywordSuper = new KeywordSuper(this.firstTokenAfter((ASTNode)e.getQualifier(), 34), null);
                MemberSelectExpressionTreeImpl qualifiedSuper = new MemberSelectExpressionTreeImpl((ExpressionTree)((Object)qualifier), this.firstTokenAfter((ASTNode)e.getQualifier(), 1), keywordSuper);
                if (qualifier.typeBinding != null) {
                    keywordSuper.typeBinding = qualifier.typeBinding;
                    qualifiedSuper.typeBinding = keywordSuper.typeBinding.getSuperclass();
                }
                return new MemberSelectExpressionTreeImpl(qualifiedSuper, this.firstTokenBefore((ASTNode)e.getName(), 1), rhs);
            }
            case 52: {
                ThisExpression e = (ThisExpression)node;
                if (e.getQualifier() == null) {
                    return new KeywordThis(this.firstTokenIn((ASTNode)e, 35), null);
                }
                KeywordThis keywordThis = new KeywordThis(this.firstTokenAfter((ASTNode)e.getQualifier(), 35), e.resolveTypeBinding());
                return new MemberSelectExpressionTreeImpl(this.convertExpression((Expression)e.getQualifier()), this.firstTokenAfter((ASTNode)e.getQualifier(), 1), keywordThis);
            }
            case 57: {
                TypeLiteral e = (TypeLiteral)node;
                return new MemberSelectExpressionTreeImpl((ExpressionTree)((Object)this.convertType(e.getType())), this.lastTokenIn((ASTNode)e, 1), new IdentifierTreeImpl(this.lastTokenIn((ASTNode)e, 68)));
            }
            case 2: {
                ArrayAccess e = (ArrayAccess)node;
                return new ArrayAccessExpressionTreeImpl(new ArrayDimensionTreeImpl(this.firstTokenBefore((ASTNode)e.getIndex(), 6), this.convertExpression(e.getIndex()), this.firstTokenAfter((ASTNode)e.getIndex(), 67))).complete(this.convertExpression(e.getArray()));
            }
            case 3: {
                TypeTree type;
                ArrayCreation e = (ArrayCreation)node;
                ArrayList<ArrayDimensionTree> dimensions = new ArrayList<ArrayDimensionTree>();
                for (Object o : e.dimensions()) {
                    dimensions.add(new ArrayDimensionTreeImpl(this.firstTokenBefore((ASTNode)((Expression)o), 6), this.convertExpression((Expression)o), this.firstTokenAfter((ASTNode)((Expression)o), 67)));
                }
                InitializerListTreeImpl initializers = new InitializerListTreeImpl((List<ExpressionTree>)new ArrayList<ExpressionTree>(), (List<SyntaxToken>)new ArrayList<SyntaxToken>());
                if (e.getInitializer() != null) {
                    assert (dimensions.isEmpty());
                    type = this.convertType((Type)e.getType());
                    while (type.is(Tree.Kind.ARRAY_TYPE)) {
                        ArrayTypeTree arrayType = (ArrayTypeTree)type;
                        ArrayDimensionTreeImpl dimension = new ArrayDimensionTreeImpl(arrayType.openBracketToken(), null, arrayType.closeBracketToken()).completeAnnotations(arrayType.annotations());
                        dimensions.add(0, dimension);
                        type = arrayType.type();
                    }
                    return ((NewArrayTreeImpl)this.convertExpression((Expression)e.getInitializer())).completeWithNewKeyword(this.firstTokenIn((ASTNode)e, 36)).complete(type).completeDimensions(dimensions);
                }
                type = this.convertType((Type)e.getType());
                int index = dimensions.size() - 1;
                while (type.is(Tree.Kind.ARRAY_TYPE)) {
                    if (!type.annotations().isEmpty()) {
                        ((ArrayDimensionTreeImpl)dimensions.get(index)).completeAnnotations(type.annotations());
                    }
                    --index;
                    type = ((ArrayTypeTree)type).type();
                }
                return new NewArrayTreeImpl(dimensions, initializers).complete(type).completeWithNewKeyword(this.firstTokenIn((ASTNode)e, 36));
            }
            case 4: {
                ArrayInitializer e = (ArrayInitializer)node;
                InitializerListTreeImpl initializers = new InitializerListTreeImpl((List<ExpressionTree>)new ArrayList<ExpressionTree>(), (List<SyntaxToken>)new ArrayList<SyntaxToken>());
                for (int i = 0; i < e.expressions().size(); ++i) {
                    Expression o = (Expression)e.expressions().get(i);
                    initializers.add(this.convertExpression(o));
                    int commaTokenIndex = this.firstTokenIndexAfter((ASTNode)o);
                    if (this.tokenManager.get((int)commaTokenIndex).tokenType != 32) continue;
                    initializers.separators().add(this.firstTokenAfter((ASTNode)o, 32));
                }
                return new NewArrayTreeImpl(Collections.emptyList(), initializers).completeWithCurlyBraces(this.firstTokenIn((ASTNode)e, 37), this.lastTokenIn((ASTNode)e, 33));
            }
            case 7: {
                Assignment e = (Assignment)node;
                Op op = operators.get(e.getOperator());
                return new AssignmentExpressionTreeImpl(op.kind, this.convertExpression(e.getLeftHandSide()), this.firstTokenAfter((ASTNode)e.getLeftHandSide(), op.tokenType), this.convertExpression(e.getRightHandSide()));
            }
            case 11: {
                CastExpression e = (CastExpression)node;
                if (e.getType().getNodeType() == 87) {
                    IntersectionType intersectionType = (IntersectionType)e.getType();
                    TypeTree type = this.convertType((Type)intersectionType.types().get(0));
                    BoundListTreeImpl bounds = new BoundListTreeImpl(new ArrayList(), (List<SyntaxToken>)new ArrayList<SyntaxToken>());
                    for (int i = 1; i < intersectionType.types().size(); ++i) {
                        Type o = (Type)intersectionType.types().get(i);
                        bounds.add(this.convertType(o));
                        if (i >= intersectionType.types().size() - 1) continue;
                        bounds.separators().add(this.firstTokenAfter((ASTNode)o, 22));
                    }
                    return new TypeCastExpressionTreeImpl(type, this.firstTokenAfter((ASTNode)((Type)intersectionType.types().get(0)), 22), bounds, this.firstTokenAfter((ASTNode)e.getType(), 26), this.convertExpression(e.getExpression())).complete(this.firstTokenBefore((ASTNode)e.getType(), 23));
                }
                return new TypeCastExpressionTreeImpl(this.convertType(e.getType()), this.firstTokenAfter((ASTNode)e.getType(), 26), this.convertExpression(e.getExpression())).complete(this.firstTokenIn((ASTNode)e, 23));
            }
            case 14: {
                ClassInstanceCreation e = (ClassInstanceCreation)node;
                ArgumentListTreeImpl arguments = this.convertArguments(this.firstTokenAfter((ASTNode)e.getType(), 23), e.arguments(), this.firstTokenAfter((ASTNode)(e.arguments().isEmpty() ? e.getType() : (ASTNode)e.arguments().get(e.arguments().size() - 1)), 26));
                ClassTreeImpl classBody = null;
                if (e.getAnonymousClassDeclaration() != null) {
                    ArrayList<Tree> members = new ArrayList<Tree>();
                    for (Object o : e.getAnonymousClassDeclaration().bodyDeclarations()) {
                        this.processBodyDeclaration((ASTNode)((BodyDeclaration)o), members);
                    }
                    classBody = new ClassTreeImpl(Tree.Kind.CLASS, (SyntaxToken)this.firstTokenIn((ASTNode)e.getAnonymousClassDeclaration(), 37), members, (SyntaxToken)this.lastTokenIn((ASTNode)e.getAnonymousClassDeclaration(), 33));
                    classBody.typeBinding = e.getAnonymousClassDeclaration().resolveBinding();
                    this.declaration((IBinding)classBody.typeBinding, classBody);
                }
                NewClassTreeImpl t = new NewClassTreeImpl(arguments, classBody).completeWithNewKeyword(e.getExpression() == null ? this.firstTokenIn((ASTNode)e, 36) : this.firstTokenAfter((ASTNode)e.getExpression(), 36)).completeWithIdentifier(this.convertType(e.getType())).completeWithTypeArguments(this.convertTypeArguments(e.typeArguments()));
                if (e.getExpression() != null) {
                    t.completeWithEnclosingExpression(this.convertExpression(e.getExpression()));
                    t.completeWithDotToken(this.firstTokenAfter((ASTNode)e.getExpression(), 1));
                }
                IdentifierTreeImpl i = (IdentifierTreeImpl)t.getConstructorIdentifier();
                int nbArguments = arguments.size();
                i.binding = e.getAnonymousClassDeclaration() == null ? JParser.excludeRecovery(e.resolveConstructorBinding(), nbArguments) : JParser.excludeRecovery(JParser.findConstructorForAnonymousClass(e.getAST(), i.typeBinding, e.resolveConstructorBinding()), nbArguments);
                this.usage(i.binding, i);
                return t;
            }
            case 16: {
                ConditionalExpression e = (ConditionalExpression)node;
                return new ConditionalExpressionTreeImpl(this.firstTokenAfter((ASTNode)e.getExpression(), 29), this.convertExpression(e.getThenExpression()), this.firstTokenAfter((ASTNode)e.getThenExpression(), 63), this.convertExpression(e.getElseExpression())).complete(this.convertExpression(e.getExpression()));
            }
            case 27: {
                InfixExpression e = (InfixExpression)node;
                Op op = operators.get(e.getOperator());
                BinaryExpressionTreeImpl t = new BinaryExpressionTreeImpl(op.kind, this.convertExpression(e.getLeftOperand()), this.firstTokenAfter((ASTNode)e.getLeftOperand(), op.tokenType), this.convertExpression(e.getRightOperand()));
                for (Object o : e.extendedOperands()) {
                    Expression e2 = (Expression)o;
                    t.typeBinding = e.resolveTypeBinding();
                    t = new BinaryExpressionTreeImpl(op.kind, t, this.firstTokenBefore((ASTNode)e2, op.tokenType), this.convertExpression(e2));
                }
                return t;
            }
            case 32: {
                MethodInvocation e = (MethodInvocation)node;
                ArgumentListTreeImpl arguments = this.convertArguments(this.firstTokenAfter((ASTNode)e.getName(), 23), e.arguments(), this.lastTokenIn((ASTNode)e, 26));
                IdentifierTreeImpl rhs = this.convertSimpleName(e.getName());
                AssessableExpressionTree memberSelect = e.getExpression() == null ? rhs : new MemberSelectExpressionTreeImpl(this.convertExpression(e.getExpression()), this.firstTokenAfter((ASTNode)e.getExpression(), 1), rhs);
                MethodInvocationTreeImpl t = new MethodInvocationTreeImpl(memberSelect, this.convertTypeArguments(e.typeArguments()), arguments);
                t.methodBinding = JParser.excludeRecovery(e.resolveMethodBinding(), arguments.size());
                rhs.binding = t.methodBinding;
                this.usage(rhs.binding, rhs);
                return t;
            }
            case 48: {
                MemberSelectExpressionTreeImpl outermostSelect;
                SuperMethodInvocation e = (SuperMethodInvocation)node;
                ArgumentListTreeImpl arguments = this.convertArguments(this.firstTokenIn((ASTNode)e, 23), e.arguments(), this.lastTokenIn((ASTNode)e, 26));
                IdentifierTreeImpl rhs = this.convertSimpleName(e.getName());
                if (e.getQualifier() == null) {
                    outermostSelect = new MemberSelectExpressionTreeImpl(this.unqualifiedKeywordSuper((ASTNode)e), this.firstTokenIn((ASTNode)e, 1), rhs);
                } else {
                    int firstDotTokenIndex = this.tokenManager.firstIndexAfter((ASTNode)e.getQualifier(), 1);
                    AbstractTypedTree qualifier = (AbstractTypedTree)((Object)this.convertExpression((Expression)e.getQualifier()));
                    KeywordSuper keywordSuper = new KeywordSuper(this.firstTokenAfter((ASTNode)e.getQualifier(), 34), null);
                    MemberSelectExpressionTreeImpl qualifiedSuper = new MemberSelectExpressionTreeImpl((ExpressionTree)((Object)qualifier), this.createSyntaxToken(firstDotTokenIndex), keywordSuper);
                    if (qualifier.typeBinding != null) {
                        keywordSuper.typeBinding = qualifier.typeBinding;
                        qualifiedSuper.typeBinding = keywordSuper.typeBinding.getSuperclass();
                    }
                    outermostSelect = new MemberSelectExpressionTreeImpl(qualifiedSuper, this.createSyntaxToken(this.nextTokenIndex(firstDotTokenIndex, 1)), rhs);
                }
                MethodInvocationTreeImpl t = new MethodInvocationTreeImpl(outermostSelect, null, arguments);
                t.methodBinding = JParser.excludeRecovery(e.resolveMethodBinding(), arguments.size());
                rhs.binding = t.methodBinding;
                this.usage(rhs.binding, rhs);
                return t;
            }
            case 36: {
                ParenthesizedExpression e = (ParenthesizedExpression)node;
                return new ParenthesizedTreeImpl(this.firstTokenIn((ASTNode)e, 23), this.convertExpression(e.getExpression()), this.firstTokenAfter((ASTNode)e.getExpression(), 26));
            }
            case 37: {
                PostfixExpression e = (PostfixExpression)node;
                Op op = operators.get(e.getOperator());
                return new InternalPostfixUnaryExpression(op.kind, this.convertExpression(e.getOperand()), this.firstTokenAfter((ASTNode)e.getOperand(), op.tokenType));
            }
            case 38: {
                PrefixExpression e = (PrefixExpression)node;
                Op op = operators.get(e.getOperator());
                return new InternalPrefixUnaryExpression(op.kind, this.firstTokenIn((ASTNode)e, op.tokenType), this.convertExpression(e.getOperand()));
            }
            case 62: {
                InstanceofExpression e = (InstanceofExpression)node;
                return new InstanceOfTreeImpl(this.firstTokenAfter((ASTNode)e.getLeftOperand(), 17), this.convertType(e.getRightOperand()), e.getAST().isPreviewEnabled() && e.getPatternVariable() != null ? this.createVariable(e.getPatternVariable()) : null).complete(this.convertExpression(e.getLeftOperand()));
            }
            case 86: {
                LambdaExpression e = (LambdaExpression)node;
                ArrayList<VariableTree> parameters = new ArrayList<VariableTree>();
                for (int i = 0; i < e.parameters().size(); ++i) {
                    VariableTreeImpl t;
                    VariableDeclaration o = (VariableDeclaration)e.parameters().get(i);
                    if (o.getNodeType() == 59) {
                        t = new VariableTreeImpl(this.convertSimpleName(o.getName()));
                        IVariableBinding variableBinding = o.resolveBinding();
                        if (variableBinding != null) {
                            t.variableBinding = variableBinding;
                            ((InferedTypeTree)t.type()).typeBinding = variableBinding.getType();
                            this.declaration((IBinding)t.variableBinding, t);
                        }
                    } else {
                        t = this.createVariable((SingleVariableDeclaration)o);
                    }
                    parameters.add(t);
                    if (i >= e.parameters().size() - 1) continue;
                    t.setEndToken(this.firstTokenAfter((ASTNode)o, 32));
                }
                ASTNode body = e.getBody();
                return new LambdaExpressionTreeImpl(e.hasParentheses() ? this.firstTokenIn((ASTNode)e, 23) : null, parameters, e.hasParentheses() ? this.firstTokenBefore(body, 26) : null, this.firstTokenBefore(body, 102), body.getNodeType() == 8 ? this.convertBlock((Block)body) : this.convertExpression((Expression)body));
            }
            case 89: {
                CreationReference e = (CreationReference)node;
                MethodReferenceTreeImpl t = new MethodReferenceTreeImpl(this.convertType(e.getType()), this.lastTokenIn((ASTNode)e, 7));
                IdentifierTreeImpl i = new IdentifierTreeImpl(this.lastTokenIn((ASTNode)e, 36));
                i.binding = e.resolveMethodBinding();
                this.usage(i.binding, i);
                t.complete(this.convertTypeArguments(e.typeArguments()), i);
                return t;
            }
            case 90: {
                ExpressionMethodReference e = (ExpressionMethodReference)node;
                MethodReferenceTreeImpl t = new MethodReferenceTreeImpl(this.convertExpression(e.getExpression()), this.firstTokenAfter((ASTNode)e.getExpression(), 7));
                IdentifierTreeImpl i = this.convertSimpleName(e.getName());
                this.usage(i.binding, i);
                t.complete(this.convertTypeArguments(e.typeArguments()), i);
                return t;
            }
            case 92: {
                TypeMethodReference e = (TypeMethodReference)node;
                MethodReferenceTreeImpl t = new MethodReferenceTreeImpl(this.convertType(e.getType()), this.firstTokenAfter((ASTNode)e.getType(), 7));
                IdentifierTreeImpl i = this.convertSimpleName(e.getName());
                this.usage(i.binding, i);
                t.complete(this.convertTypeArguments(e.typeArguments()), i);
                return t;
            }
            case 91: {
                SuperMethodReference e = (SuperMethodReference)node;
                MethodReferenceTreeImpl t = e.getQualifier() != null ? new MethodReferenceTreeImpl(new MemberSelectExpressionTreeImpl(this.convertExpression((Expression)e.getQualifier()), this.firstTokenAfter((ASTNode)e.getQualifier(), 1), new IdentifierTreeImpl(this.firstTokenAfter((ASTNode)e.getQualifier(), 34))), this.firstTokenAfter((ASTNode)e.getQualifier(), 7)) : new MethodReferenceTreeImpl(this.unqualifiedKeywordSuper((ASTNode)e), this.firstTokenIn((ASTNode)e, 7));
                IdentifierTreeImpl i = this.convertSimpleName(e.getName());
                this.usage(i.binding, i);
                t.complete(this.convertTypeArguments(e.typeArguments()), i);
                return t;
            }
            case 100: {
                SwitchExpression e = (SwitchExpression)node;
                return new SwitchExpressionTreeImpl(this.firstTokenIn((ASTNode)e, 61), this.firstTokenIn((ASTNode)e, 23), this.convertExpression(e.getExpression()), this.firstTokenAfter((ASTNode)e.getExpression(), 26), this.firstTokenAfter((ASTNode)e.getExpression(), 37), this.convertSwitchStatements(e.statements()), this.lastTokenIn((ASTNode)e, 33));
            }
            case 33: {
                NullLiteral e = (NullLiteral)node;
                return new LiteralTreeImpl(Tree.Kind.NULL_LITERAL, this.firstTokenIn((ASTNode)e, 42));
            }
            case 34: {
                AssessableExpressionTree result;
                boolean unaryMinus;
                NumberLiteral e = (NumberLiteral)node;
                int tokenIndex = this.tokenManager.findIndex(e.getStartPosition(), -1, true);
                int tokenType = this.tokenManager.get((int)tokenIndex).tokenType;
                boolean bl = unaryMinus = tokenType == 5;
                if (unaryMinus) {
                    tokenType = this.tokenManager.get((int)(++tokenIndex)).tokenType;
                }
                switch (tokenType) {
                    case 44: {
                        result = new LiteralTreeImpl(Tree.Kind.INT_LITERAL, this.createSyntaxToken(tokenIndex));
                        break;
                    }
                    case 45: {
                        result = new LiteralTreeImpl(Tree.Kind.LONG_LITERAL, this.createSyntaxToken(tokenIndex));
                        break;
                    }
                    case 46: {
                        result = new LiteralTreeImpl(Tree.Kind.FLOAT_LITERAL, this.createSyntaxToken(tokenIndex));
                        break;
                    }
                    case 47: {
                        result = new LiteralTreeImpl(Tree.Kind.DOUBLE_LITERAL, this.createSyntaxToken(tokenIndex));
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                result.typeBinding = e.resolveTypeBinding();
                if (unaryMinus) {
                    result = new InternalPrefixUnaryExpression(Tree.Kind.UNARY_MINUS, this.createSyntaxToken(tokenIndex - 1), result);
                }
                return result;
            }
            case 13: {
                CharacterLiteral e = (CharacterLiteral)node;
                return new LiteralTreeImpl(Tree.Kind.CHAR_LITERAL, this.firstTokenIn((ASTNode)e, 48));
            }
            case 9: {
                BooleanLiteral e = (BooleanLiteral)node;
                return new LiteralTreeImpl(Tree.Kind.BOOLEAN_LITERAL, this.firstTokenIn((ASTNode)e, e.booleanValue() ? 43 : 41));
            }
            case 45: {
                StringLiteral e = (StringLiteral)node;
                return new LiteralTreeImpl(Tree.Kind.STRING_LITERAL, this.firstTokenIn((ASTNode)e, 49));
            }
            case 102: {
                TextBlock e = (TextBlock)node;
                return new LiteralTreeImpl(Tree.Kind.STRING_LITERAL, this.firstTokenIn((ASTNode)e, 50));
            }
            case 77: 
            case 78: 
            case 79: {
                Annotation e = (Annotation)node;
                ArgumentListTreeImpl arguments = new ArgumentListTreeImpl((List<ExpressionTree>)new ArrayList<ExpressionTree>(), (List<SyntaxToken>)new ArrayList<SyntaxToken>());
                if (e.getNodeType() == 79) {
                    arguments.add(this.convertExpression(((SingleMemberAnnotation)e).getValue()));
                    arguments.complete(this.firstTokenIn((ASTNode)e, 23), this.lastTokenIn((ASTNode)e, 26));
                } else if (e.getNodeType() == 77) {
                    for (int i = 0; i < ((NormalAnnotation)e).values().size(); ++i) {
                        MemberValuePair o = (MemberValuePair)((NormalAnnotation)e).values().get(i);
                        arguments.add(new AssignmentExpressionTreeImpl(Tree.Kind.ASSIGNMENT, this.convertSimpleName(o.getName()), this.firstTokenAfter((ASTNode)o.getName(), 75), this.convertExpression(o.getValue())));
                        if (i >= ((NormalAnnotation)e).values().size() - 1) continue;
                        arguments.separators().add(this.firstTokenAfter((ASTNode)o, 32));
                    }
                    arguments.complete(this.firstTokenIn((ASTNode)e, 23), this.lastTokenIn((ASTNode)e, 26));
                }
                return new AnnotationTreeImpl(this.firstTokenIn((ASTNode)e, 38), (TypeTree)((Object)this.convertExpression((Expression)e.getTypeName())), arguments);
            }
        }
        throw new IllegalStateException(ASTNode.nodeClassForType((int)node.getNodeType()).toString());
    }

    private KeywordSuper unqualifiedKeywordSuper(ASTNode node) {
        InternalSyntaxToken token = this.firstTokenIn(node, 34);
        while (!(node instanceof AbstractTypeDeclaration)) {
            if (node instanceof AnonymousClassDeclaration) {
                return new KeywordSuper(token, ((AnonymousClassDeclaration)node).resolveBinding());
            }
            node = node.getParent();
        }
        return new KeywordSuper(token, ((AbstractTypeDeclaration)node).resolveBinding());
    }

    private TypeTree convertType(Type node) {
        switch (node.getNodeType()) {
            case 39: {
                JavaTree.PrimitiveTypeTreeImpl t;
                PrimitiveType e = (PrimitiveType)node;
                switch (e.getPrimitiveTypeCode().toString()) {
                    case "byte": {
                        t = new JavaTree.PrimitiveTypeTreeImpl(this.lastTokenIn((ASTNode)e, 104));
                        break;
                    }
                    case "short": {
                        t = new JavaTree.PrimitiveTypeTreeImpl(this.lastTokenIn((ASTNode)e, 112));
                        break;
                    }
                    case "char": {
                        t = new JavaTree.PrimitiveTypeTreeImpl(this.lastTokenIn((ASTNode)e, 106));
                        break;
                    }
                    case "int": {
                        t = new JavaTree.PrimitiveTypeTreeImpl(this.lastTokenIn((ASTNode)e, 110));
                        break;
                    }
                    case "long": {
                        t = new JavaTree.PrimitiveTypeTreeImpl(this.lastTokenIn((ASTNode)e, 111));
                        break;
                    }
                    case "float": {
                        t = new JavaTree.PrimitiveTypeTreeImpl(this.lastTokenIn((ASTNode)e, 108));
                        break;
                    }
                    case "double": {
                        t = new JavaTree.PrimitiveTypeTreeImpl(this.lastTokenIn((ASTNode)e, 107));
                        break;
                    }
                    case "boolean": {
                        t = new JavaTree.PrimitiveTypeTreeImpl(this.lastTokenIn((ASTNode)e, 103));
                        break;
                    }
                    case "void": {
                        t = new JavaTree.PrimitiveTypeTreeImpl(this.lastTokenIn((ASTNode)e, 113));
                        break;
                    }
                    default: {
                        throw new IllegalStateException(e.getPrimitiveTypeCode().toString());
                    }
                }
                t.complete(this.convertAnnotations(e.annotations()));
                t.typeBinding = e.resolveBinding();
                return t;
            }
            case 43: {
                SimpleType e = (SimpleType)node;
                ArrayList<AnnotationTree> annotations = new ArrayList<AnnotationTree>();
                for (Object o : e.annotations()) {
                    annotations.add((AnnotationTree)this.convertExpression((Expression)((Annotation)o)));
                }
                VarTypeTreeImpl t = e.isVar() ? this.convertVarType(e) : (JavaTree.AnnotatedTypeTree)((Object)this.convertExpression((Expression)e.getName()));
                t.complete(annotations);
                return t;
            }
            case 84: {
                UnionType e = (UnionType)node;
                TypeUnionListTreeImpl alternatives = new TypeUnionListTreeImpl((List<TypeTree>)new ArrayList<TypeTree>(), (List<SyntaxToken>)new ArrayList<SyntaxToken>());
                for (int i = 0; i < e.types().size(); ++i) {
                    Type o = (Type)e.types().get(i);
                    alternatives.add(this.convertType(o));
                    if (i >= e.types().size() - 1) continue;
                    alternatives.separators().add(this.firstTokenAfter((ASTNode)o, 28));
                }
                JavaTree.UnionTypeTreeImpl t = new JavaTree.UnionTypeTreeImpl(alternatives);
                t.typeBinding = e.resolveBinding();
                return t;
            }
            case 5: {
                ArrayType e = (ArrayType)node;
                ITypeBinding elementTypeBinding = e.getElementType().resolveBinding();
                TypeTree t = this.convertType(e.getElementType());
                int tokenIndex = this.tokenManager.firstIndexAfter((ASTNode)e.getElementType(), 6);
                for (int i = 0; i < e.dimensions().size(); ++i) {
                    if (i > 0) {
                        tokenIndex = this.nextTokenIndex(tokenIndex, 6);
                    }
                    t = new JavaTree.ArrayTypeTreeImpl(t, this.convertAnnotations(((Dimension)e.dimensions().get(i)).annotations()), this.createSyntaxToken(tokenIndex), this.createSyntaxToken(this.nextTokenIndex(tokenIndex, 67)));
                    if (elementTypeBinding == null) continue;
                    ((JavaTree.ArrayTypeTreeImpl)t).typeBinding = elementTypeBinding.createArrayType(i + 1);
                }
                return t;
            }
            case 74: {
                ParameterizedType e = (ParameterizedType)node;
                int pos = e.getStartPosition() + e.getLength() - 1;
                JavaTree.ParameterizedTypeTreeImpl t = new JavaTree.ParameterizedTypeTreeImpl(this.convertType(e.getType()), this.convertTypeArguments(this.firstTokenAfter((ASTNode)e.getType(), 11), e.typeArguments(), new InternalSyntaxToken(this.compilationUnit.getLineNumber(pos), this.compilationUnit.getColumnNumber(pos), ">", Collections.emptyList(), false)));
                t.typeBinding = e.resolveBinding();
                return t;
            }
            case 75: {
                QualifiedType e = (QualifiedType)node;
                MemberSelectExpressionTreeImpl t = new MemberSelectExpressionTreeImpl((ExpressionTree)((Object)this.convertType(e.getQualifier())), this.firstTokenAfter((ASTNode)e.getQualifier(), 1), this.convertSimpleName(e.getName()));
                ((IdentifierTreeImpl)t.identifier()).complete(this.convertAnnotations(e.annotations()));
                t.typeBinding = e.resolveBinding();
                return t;
            }
            case 88: {
                NameQualifiedType e = (NameQualifiedType)node;
                MemberSelectExpressionTreeImpl t = new MemberSelectExpressionTreeImpl(this.convertExpression((Expression)e.getQualifier()), this.firstTokenAfter((ASTNode)e.getQualifier(), 1), this.convertSimpleName(e.getName()));
                ((IdentifierTreeImpl)t.identifier()).complete(this.convertAnnotations(e.annotations()));
                t.typeBinding = e.resolveBinding();
                return t;
            }
            case 76: {
                WildcardType e = (WildcardType)node;
                InternalSyntaxToken questionToken = e.annotations().isEmpty() ? this.firstTokenIn((ASTNode)e, 29) : this.firstTokenAfter((ASTNode)e.annotations().get(e.annotations().size() - 1), 29);
                Type bound = e.getBound();
                JavaTree.WildcardTreeImpl t = bound == null ? new JavaTree.WildcardTreeImpl(questionToken) : new JavaTree.WildcardTreeImpl(e.isUpperBound() ? Tree.Kind.EXTENDS_WILDCARD : Tree.Kind.SUPER_WILDCARD, e.isUpperBound() ? this.firstTokenBefore((ASTNode)bound, 90) : this.firstTokenBefore((ASTNode)bound, 34), this.convertType(bound)).complete(questionToken);
                t.complete(this.convertAnnotations(e.annotations()));
                t.typeBinding = e.resolveBinding();
                return t;
            }
        }
        throw new IllegalStateException(ASTNode.nodeClassForType((int)node.getNodeType()).toString());
    }

    @Nullable
    private static IMethodBinding excludeRecovery(@Nullable IMethodBinding methodBinding, int arguments) {
        if (methodBinding == null) {
            return null;
        }
        if (methodBinding.isVarargs() ? arguments + 1 < methodBinding.getParameterTypes().length : arguments != methodBinding.getParameterTypes().length) {
            return null;
        }
        return methodBinding;
    }

    @Nullable
    private static IMethodBinding findConstructorForAnonymousClass(AST ast, @Nullable ITypeBinding typeBinding, @Nullable IMethodBinding methodBinding) {
        if (typeBinding == null || methodBinding == null) {
            return null;
        }
        if (typeBinding.isInterface()) {
            typeBinding = ast.resolveWellKnownType("java.lang.Object");
        }
        for (IMethodBinding m : typeBinding.getDeclaredMethods()) {
            if (!methodBinding.isSubsignature(m)) continue;
            return m;
        }
        return null;
    }

    private List<AnnotationTree> convertAnnotations(List<?> e) {
        ArrayList<AnnotationTree> annotations = new ArrayList<AnnotationTree>();
        for (Object o : e) {
            annotations.add((AnnotationTree)this.convertExpression((Expression)((Annotation)o)));
        }
        return annotations;
    }

    private ModifiersTreeImpl convertModifiers(List<?> source) {
        ArrayList<ModifierTree> modifiers = new ArrayList<ModifierTree>();
        for (Object o : source) {
            modifiers.add(this.convertModifier((IExtendedModifier)o));
        }
        return new ModifiersTreeImpl((List<ModifierTree>)modifiers);
    }

    private ModifierTree convertModifier(IExtendedModifier node) {
        switch (((ASTNode)node).getNodeType()) {
            case 77: 
            case 78: 
            case 79: {
                return (AnnotationTree)this.convertExpression((Expression)node);
            }
            case 83: {
                return this.convertModifier((org.eclipse.jdt.core.dom.Modifier)node);
            }
        }
        throw new IllegalStateException();
    }

    private ModifierTree convertModifier(org.eclipse.jdt.core.dom.Modifier node) {
        switch (node.getKeyword().toString()) {
            case "public": {
                return new ModifierKeywordTreeImpl(Modifier.PUBLIC, this.firstTokenIn((ASTNode)node, 57));
            }
            case "protected": {
                return new ModifierKeywordTreeImpl(Modifier.PROTECTED, this.firstTokenIn((ASTNode)node, 56));
            }
            case "private": {
                return new ModifierKeywordTreeImpl(Modifier.PRIVATE, this.firstTokenIn((ASTNode)node, 55));
            }
            case "static": {
                return new ModifierKeywordTreeImpl(Modifier.STATIC, this.firstTokenIn((ASTNode)node, 39));
            }
            case "abstract": {
                return new ModifierKeywordTreeImpl(Modifier.ABSTRACT, this.firstTokenIn((ASTNode)node, 52));
            }
            case "final": {
                return new ModifierKeywordTreeImpl(Modifier.FINAL, this.firstTokenIn((ASTNode)node, 53));
            }
            case "native": {
                return new ModifierKeywordTreeImpl(Modifier.NATIVE, this.firstTokenIn((ASTNode)node, 54));
            }
            case "synchronized": {
                return new ModifierKeywordTreeImpl(Modifier.SYNCHRONIZED, this.firstTokenIn((ASTNode)node, 40));
            }
            case "transient": {
                return new ModifierKeywordTreeImpl(Modifier.TRANSIENT, this.firstTokenIn((ASTNode)node, 59));
            }
            case "volatile": {
                return new ModifierKeywordTreeImpl(Modifier.VOLATILE, this.firstTokenIn((ASTNode)node, 60));
            }
            case "strictfp": {
                return new ModifierKeywordTreeImpl(Modifier.STRICTFP, this.firstTokenIn((ASTNode)node, 58));
            }
            case "default": {
                return new ModifierKeywordTreeImpl(Modifier.DEFAULT, this.firstTokenIn((ASTNode)node, 74));
            }
        }
        throw new IllegalStateException(node.getKeyword().toString());
    }

    static {
        operators.put(PrefixExpression.Operator.PLUS, new Op(Tree.Kind.UNARY_PLUS, 4));
        operators.put(PrefixExpression.Operator.MINUS, new Op(Tree.Kind.UNARY_MINUS, 5));
        operators.put(PrefixExpression.Operator.NOT, new Op(Tree.Kind.LOGICAL_COMPLEMENT, 64));
        operators.put(PrefixExpression.Operator.COMPLEMENT, new Op(Tree.Kind.BITWISE_COMPLEMENT, 65));
        operators.put(PrefixExpression.Operator.DECREMENT, new Op(Tree.Kind.PREFIX_DECREMENT, 3));
        operators.put(PrefixExpression.Operator.INCREMENT, new Op(Tree.Kind.PREFIX_INCREMENT, 2));
        operators.put(PostfixExpression.Operator.DECREMENT, new Op(Tree.Kind.POSTFIX_DECREMENT, 3));
        operators.put(PostfixExpression.Operator.INCREMENT, new Op(Tree.Kind.POSTFIX_INCREMENT, 2));
        operators.put(InfixExpression.Operator.TIMES, new Op(Tree.Kind.MULTIPLY, 8));
        operators.put(InfixExpression.Operator.DIVIDE, new Op(Tree.Kind.DIVIDE, 10));
        operators.put(InfixExpression.Operator.REMAINDER, new Op(Tree.Kind.REMAINDER, 9));
        operators.put(InfixExpression.Operator.PLUS, new Op(Tree.Kind.PLUS, 4));
        operators.put(InfixExpression.Operator.MINUS, new Op(Tree.Kind.MINUS, 5));
        operators.put(InfixExpression.Operator.LEFT_SHIFT, new Op(Tree.Kind.LEFT_SHIFT, 18));
        operators.put(InfixExpression.Operator.RIGHT_SHIFT_SIGNED, new Op(Tree.Kind.RIGHT_SHIFT, 14));
        operators.put(InfixExpression.Operator.RIGHT_SHIFT_UNSIGNED, new Op(Tree.Kind.UNSIGNED_RIGHT_SHIFT, 16));
        operators.put(InfixExpression.Operator.LESS, new Op(Tree.Kind.LESS_THAN, 11));
        operators.put(InfixExpression.Operator.GREATER, new Op(Tree.Kind.GREATER_THAN, 15));
        operators.put(InfixExpression.Operator.LESS_EQUALS, new Op(Tree.Kind.LESS_THAN_OR_EQUAL_TO, 12));
        operators.put(InfixExpression.Operator.GREATER_EQUALS, new Op(Tree.Kind.GREATER_THAN_OR_EQUAL_TO, 13));
        operators.put(InfixExpression.Operator.EQUALS, new Op(Tree.Kind.EQUAL_TO, 19));
        operators.put(InfixExpression.Operator.NOT_EQUALS, new Op(Tree.Kind.NOT_EQUAL_TO, 20));
        operators.put(InfixExpression.Operator.XOR, new Op(Tree.Kind.XOR, 24));
        operators.put(InfixExpression.Operator.OR, new Op(Tree.Kind.OR, 28));
        operators.put(InfixExpression.Operator.AND, new Op(Tree.Kind.AND, 22));
        operators.put(InfixExpression.Operator.CONDITIONAL_OR, new Op(Tree.Kind.CONDITIONAL_OR, 31));
        operators.put(InfixExpression.Operator.CONDITIONAL_AND, new Op(Tree.Kind.CONDITIONAL_AND, 30));
        operators.put(Assignment.Operator.ASSIGN, new Op(Tree.Kind.ASSIGNMENT, 75));
        operators.put(Assignment.Operator.PLUS_ASSIGN, new Op(Tree.Kind.PLUS_ASSIGNMENT, 91));
        operators.put(Assignment.Operator.MINUS_ASSIGN, new Op(Tree.Kind.MINUS_ASSIGNMENT, 92));
        operators.put(Assignment.Operator.TIMES_ASSIGN, new Op(Tree.Kind.MULTIPLY_ASSIGNMENT, 93));
        operators.put(Assignment.Operator.DIVIDE_ASSIGN, new Op(Tree.Kind.DIVIDE_ASSIGNMENT, 94));
        operators.put(Assignment.Operator.BIT_AND_ASSIGN, new Op(Tree.Kind.AND_ASSIGNMENT, 95));
        operators.put(Assignment.Operator.BIT_OR_ASSIGN, new Op(Tree.Kind.OR_ASSIGNMENT, 96));
        operators.put(Assignment.Operator.BIT_XOR_ASSIGN, new Op(Tree.Kind.XOR_ASSIGNMENT, 97));
        operators.put(Assignment.Operator.REMAINDER_ASSIGN, new Op(Tree.Kind.REMAINDER_ASSIGNMENT, 98));
        operators.put(Assignment.Operator.LEFT_SHIFT_ASSIGN, new Op(Tree.Kind.LEFT_SHIFT_ASSIGNMENT, 99));
        operators.put(Assignment.Operator.RIGHT_SHIFT_SIGNED_ASSIGN, new Op(Tree.Kind.RIGHT_SHIFT_ASSIGNMENT, 100));
        operators.put(Assignment.Operator.RIGHT_SHIFT_UNSIGNED_ASSIGN, new Op(Tree.Kind.UNSIGNED_RIGHT_SHIFT_ASSIGNMENT, 101));
    }

    private static class Op {
        final Tree.Kind kind;
        final int tokenType;

        Op(Tree.Kind kind, int tokenType) {
            this.kind = kind;
            this.tokenType = tokenType;
        }
    }
}

