/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.spring;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.SymbolMetadata;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S3751")
public class RequestMappingMethodPublicCheck
extends IssuableSubscriptionVisitor {
    private static final List<String> CONTROLLER_ANNOTATIONS = Arrays.asList("org.springframework.stereotype.Controller", "org.springframework.web.bind.annotation.RestController");
    private static final List<String> REQUEST_ANNOTATIONS = Arrays.asList("org.springframework.web.bind.annotation.RequestMapping", "org.springframework.web.bind.annotation.GetMapping", "org.springframework.web.bind.annotation.PostMapping", "org.springframework.web.bind.annotation.PutMapping", "org.springframework.web.bind.annotation.DeleteMapping", "org.springframework.web.bind.annotation.PatchMapping");

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        MethodTree methodTree = (MethodTree)tree;
        Symbol.MethodSymbol methodSymbol = methodTree.symbol();
        if (RequestMappingMethodPublicCheck.isClassController(methodSymbol) && RequestMappingMethodPublicCheck.isRequestMappingAnnotated(methodSymbol) && methodSymbol.isPrivate()) {
            this.reportIssue((Tree)methodTree.simpleName(), "Make this method non \"private\".");
        }
    }

    private static boolean isClassController(Symbol.MethodSymbol methodSymbol) {
        return CONTROLLER_ANNOTATIONS.stream().anyMatch(arg_0 -> ((SymbolMetadata)methodSymbol.owner().metadata()).isAnnotatedWith(arg_0));
    }

    private static boolean isRequestMappingAnnotated(Symbol.MethodSymbol methodSymbol) {
        return REQUEST_ANNOTATIONS.stream().anyMatch(arg_0 -> ((SymbolMetadata)methodSymbol.metadata()).isAnnotatedWith(arg_0));
    }
}

