/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

public abstract class AbstractCallToDeprecatedCodeChecker
extends IssuableSubscriptionVisitor {
    private int nestedDeprecationLevel = 0;

    public final void leaveFile(JavaFileScannerContext context) {
        this.nestedDeprecationLevel = 0;
    }

    public final List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.IDENTIFIER, Tree.Kind.CLASS, Tree.Kind.ENUM, Tree.Kind.INTERFACE, Tree.Kind.ANNOTATION_TYPE, Tree.Kind.METHOD, Tree.Kind.CONSTRUCTOR);
    }

    public final void visitNode(Tree tree) {
        if (this.nestedDeprecationLevel == 0) {
            MethodTree methodTree;
            List<Symbol.MethodSymbol> deprectatedMethods;
            if (tree.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
                IdentifierTree identifierTree = (IdentifierTree)tree;
                if (AbstractCallToDeprecatedCodeChecker.isSimpleNameOfVariableTreeOrVariableIsDeprecated(identifierTree)) {
                    return;
                }
                AbstractCallToDeprecatedCodeChecker.tryGetDeprecatedSymbol(identifierTree).ifPresent(deprecatedSymbol -> this.checkDeprecatedIdentifier(identifierTree, (Symbol)deprecatedSymbol));
            } else if (tree.is(new Tree.Kind[]{Tree.Kind.METHOD}) && !(deprectatedMethods = AbstractCallToDeprecatedCodeChecker.deprecatedMethodSymbols(methodTree = (MethodTree)tree)).isEmpty()) {
                this.checkOverridingMethod(methodTree, deprectatedMethods);
            }
        }
        if (AbstractCallToDeprecatedCodeChecker.isDeprecatedMethod(tree) || AbstractCallToDeprecatedCodeChecker.isDeprecatedClassTree(tree)) {
            ++this.nestedDeprecationLevel;
        }
    }

    public final void leaveNode(Tree tree) {
        if (AbstractCallToDeprecatedCodeChecker.isDeprecatedMethod(tree) || AbstractCallToDeprecatedCodeChecker.isDeprecatedClassTree(tree)) {
            --this.nestedDeprecationLevel;
        }
    }

    private static Optional<Symbol> tryGetDeprecatedSymbol(IdentifierTree identifierTree) {
        Symbol symbol = identifierTree.symbol();
        if (symbol.isDeprecated()) {
            return Optional.of(symbol);
        }
        if (AbstractCallToDeprecatedCodeChecker.isConstructor(symbol) && symbol.owner().isDeprecated()) {
            return Optional.of(symbol.owner());
        }
        if (AbstractCallToDeprecatedCodeChecker.isDeprecatedEnumConstant(symbol)) {
            return Optional.of(symbol.type().symbol());
        }
        return Optional.empty();
    }

    public static boolean isConstructor(Symbol symbol) {
        return symbol.isMethodSymbol() && "<init>".equals(symbol.name());
    }

    private static boolean isDeprecatedEnumConstant(Symbol symbol) {
        return symbol.isVariableSymbol() && symbol.isEnum() && symbol.type().symbol().isDeprecated();
    }

    abstract void checkDeprecatedIdentifier(IdentifierTree var1, Symbol var2);

    private static boolean isSimpleNameOfVariableTreeOrVariableIsDeprecated(IdentifierTree identifierTree) {
        Tree parent = identifierTree.parent();
        return parent.is(new Tree.Kind[]{Tree.Kind.VARIABLE}) && (identifierTree.equals((Object)((VariableTree)parent).simpleName()) || ((VariableTree)parent).symbol().isDeprecated());
    }

    private static List<Symbol.MethodSymbol> deprecatedMethodSymbols(MethodTree methodTree) {
        Symbol.MethodSymbol methodSymbol = methodTree.symbol();
        if (methodSymbol.isDeprecated()) {
            return Collections.emptyList();
        }
        return methodSymbol.overriddenSymbols().stream().filter(Symbol::isDeprecated).collect(Collectors.toList());
    }

    abstract void checkOverridingMethod(MethodTree var1, List<Symbol.MethodSymbol> var2);

    private static boolean isDeprecatedMethod(Tree tree) {
        return tree.is(new Tree.Kind[]{Tree.Kind.METHOD, Tree.Kind.CONSTRUCTOR}) && ((MethodTree)tree).symbol().isDeprecated();
    }

    private static boolean isDeprecatedClassTree(Tree tree) {
        return tree.is(new Tree.Kind[]{Tree.Kind.CLASS, Tree.Kind.ENUM, Tree.Kind.INTERFACE, Tree.Kind.ANNOTATION_TYPE}) && ((ClassTree)tree).symbol().isDeprecated();
    }

    boolean isFlaggedForRemoval(Symbol deprecatedSymbol) {
        List valuesForAnnotation = deprecatedSymbol.metadata().valuesForAnnotation("java.lang.Deprecated");
        if (valuesForAnnotation == null) {
            return false;
        }
        return valuesForAnnotation.stream().filter(annotationValue -> "forRemoval".equals(annotationValue.name())).anyMatch(annotationValue -> Boolean.TRUE.equals(annotationValue.value()));
    }
}

