/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.filters;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.scan.issue.filter.FilterableIssue;
import org.sonar.api.utils.AnnotationUtils;
import org.sonar.check.Rule;
import org.sonar.java.checks.CheckList;
import org.sonar.java.checks.SuppressWarningsCheck;
import org.sonar.java.collections.MapBuilder;
import org.sonar.java.collections.SetUtils;
import org.sonar.java.filters.BaseTreeVisitorIssueFilter;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.NewArrayTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.SyntaxTrivia;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonarsource.analyzer.commons.annotations.DeprecatedRuleKey;

public class SuppressWarningFilter
extends BaseTreeVisitorIssueFilter {
    private static final Map<String, Set<String>> JAVAC_WARNING_SUPPRESSING_RULES = MapBuilder.newMap().put((Object)"cast", Collections.singleton("java:S1905")).put((Object)"deprecation", Collections.singleton("java:S1874")).put((Object)"dep-ann", Collections.singleton("java:S1123")).put((Object)"divzero", Collections.singleton("java:S3518")).put((Object)"empty", (Object)SetUtils.immutableSetOf((Object[])new String[]{"java:S1116", "java:S108"})).put((Object)"fallthrough", Collections.singleton("java:S128")).put((Object)"finally", Collections.singleton("java:S1143")).put((Object)"overrides", Collections.singleton("java:S1206")).put((Object)"removal", Collections.singleton("java:S5738")).put((Object)"serial", Collections.singleton("java:S2057")).put((Object)"static", (Object)SetUtils.immutableSetOf((Object[])new String[]{"java:S2696", "java:S2209"})).put((Object)"rawtypes", Collections.singleton("java:S3740")).put((Object)"boxing", (Object)SetUtils.immutableSetOf((Object[])new String[]{"java:S2153", "java:S5411"})).put((Object)"hiding", Collections.singleton("java:S4977")).put((Object)"javadoc", Collections.singleton("java:S1176")).put((Object)"null", Collections.singleton("java:S2259")).put((Object)"resource", (Object)SetUtils.immutableSetOf((Object[])new String[]{"java:S2093", "java:S2095"})).put((Object)"serial", Collections.singleton("java:S2057")).put((Object)"static-access", (Object)SetUtils.immutableSetOf((Object[])new String[]{"java:S2696", "java:S2209"})).put((Object)"static-method", Collections.singleton("java:S2325")).put((Object)"sync-override", Collections.singleton("java:S3551")).put((Object)"unused", (Object)SetUtils.immutableSetOf((Object[])new String[]{"java:S1481", "java:S1065", "java:S1854", "java:S1068", "java:S3985", "java:S2326", "java:S1144", "java:S1128", "java:S2583"})).build();
    private final Map<String, Map<String, Set<Integer>>> excludedLinesByComponent = new HashMap<String, Map<String, Set<Integer>>>();
    private static final String SUPPRESS_WARNING_RULE_KEY = SuppressWarningFilter.getSuppressWarningRuleKey();
    private static final Map<String, RuleKey> DEPRRECATED_RULE_KEYS = SuppressWarningFilter.getDeprecatedRuleKeys();

    private static String getSuppressWarningRuleKey() {
        return ((Rule)AnnotationUtils.getAnnotation(SuppressWarningsCheck.class, Rule.class)).key();
    }

    @Override
    public Set<Class<? extends JavaCheck>> filteredRules() {
        return Collections.emptySet();
    }

    @Override
    public void scanFile(JavaFileScannerContext context) {
        super.scanFile(context);
        this.excludedLinesByComponent.put(this.getComponentKey(), new HashMap<String, Set<Integer>>(this.excludedLinesByRule()));
    }

    private static Map<String, RuleKey> getDeprecatedRuleKeys() {
        HashMap<String, RuleKey> deprecatedRuleKeys = new HashMap<String, RuleKey>();
        CheckList.getChecks().forEach(c -> {
            String key = ((Rule)AnnotationUtils.getAnnotation((Object)c, Rule.class)).key();
            DeprecatedRuleKey deprecatedRuleKeyAnnotation = (DeprecatedRuleKey)AnnotationUtils.getAnnotation((Object)c, DeprecatedRuleKey.class);
            if (deprecatedRuleKeyAnnotation != null) {
                deprecatedRuleKeys.put(key, RuleKey.of((String)deprecatedRuleKeyAnnotation.repositoryKey(), (String)deprecatedRuleKeyAnnotation.ruleKey()));
            }
        });
        return deprecatedRuleKeys;
    }

    @Override
    public boolean accept(FilterableIssue issue) {
        return !SuppressWarningFilter.issueShouldNotBeReported(issue, this.excludedLinesByComponent.getOrDefault(issue.componentKey(), Collections.emptyMap()));
    }

    private static boolean issueShouldNotBeReported(FilterableIssue issue, Map<String, Set<Integer>> excludedLineByRule) {
        RuleKey issueRuleKey = issue.ruleKey();
        return excludedLineByRule.entrySet().stream().anyMatch(excludedRule -> {
            String suppressedWarning = (String)excludedRule.getKey();
            return ("all".equals(suppressedWarning) || SuppressWarningFilter.isRuleKey(suppressedWarning, issueRuleKey)) && !SuppressWarningFilter.isSuppressWarningRule(issueRuleKey) && ((Set)excludedRule.getValue()).contains(issue.line());
        });
    }

    private static boolean isRuleKey(String rule, RuleKey ruleKey) {
        try {
            RuleKey parsed = RuleKey.parse((String)rule);
            RuleKey deprecatedRuleKey = DEPRRECATED_RULE_KEYS.get(ruleKey.rule());
            RuleKey squidRuleKey = RuleKey.of((String)"squid", (String)ruleKey.rule());
            return ruleKey.equals((Object)parsed) || squidRuleKey.equals((Object)parsed) || parsed.equals((Object)deprecatedRuleKey);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    private static boolean isSuppressWarningRule(RuleKey ruleKey) {
        return SUPPRESS_WARNING_RULE_KEY.equals(ruleKey.rule());
    }

    public void visitClass(ClassTree tree) {
        this.handleSuppressWarning(tree.modifiers().annotations(), (Tree)tree);
        super.visitClass(tree);
    }

    public void visitMethod(MethodTree tree) {
        this.handleSuppressWarning(tree.modifiers().annotations(), (Tree)tree);
        super.visitMethod(tree);
    }

    public void visitVariable(VariableTree tree) {
        this.handleSuppressWarning(tree.modifiers().annotations(), (Tree)tree);
        super.visitVariable(tree);
    }

    private void handleSuppressWarning(List<AnnotationTree> annotationTrees, Tree tree) {
        int startLine = -1;
        ArrayList<String> rules = new ArrayList<String>();
        for (AnnotationTree annotationTree : annotationTrees) {
            if (!SuppressWarningFilter.isSuppressWarningsAnnotation(annotationTree)) continue;
            startLine = SuppressWarningFilter.startLineIncludingTrivia(tree);
            rules.addAll(SuppressWarningFilter.getRules(annotationTree));
            break;
        }
        if (startLine != -1) {
            int endLine = tree.lastToken().line();
            Set<Integer> filteredlines = IntStream.rangeClosed(startLine, endLine).boxed().collect(Collectors.toSet());
            for (String rule : rules) {
                this.excludeLines(filteredlines, rule);
            }
        }
    }

    private static int startLineIncludingTrivia(Tree tree) {
        SyntaxToken firstToken = tree.firstToken();
        if (!firstToken.trivias().isEmpty()) {
            return ((SyntaxTrivia)firstToken.trivias().get(0)).startLine();
        }
        return firstToken.line();
    }

    private static boolean isSuppressWarningsAnnotation(AnnotationTree annotationTree) {
        return annotationTree.annotationType().symbolType().is("java.lang.SuppressWarnings") && !annotationTree.arguments().isEmpty();
    }

    private static List<String> getRules(AnnotationTree annotationTree) {
        return SuppressWarningFilter.getRulesFromExpression((ExpressionTree)annotationTree.arguments().get(0));
    }

    private static List<String> getRulesFromExpression(ExpressionTree expression) {
        ArrayList<String> args = new ArrayList<String>();
        if (expression.is(new Tree.Kind[]{Tree.Kind.NEW_ARRAY})) {
            for (ExpressionTree initializer : ((NewArrayTree)expression).initializers()) {
                args.addAll(SuppressWarningFilter.getRulesFromExpression(initializer));
            }
        } else {
            expression.asConstant(String.class).ifPresent(rule -> {
                if (JAVAC_WARNING_SUPPRESSING_RULES.containsKey(rule)) {
                    args.addAll((Collection)JAVAC_WARNING_SUPPRESSING_RULES.get(rule));
                } else {
                    args.add((String)rule);
                }
            });
        }
        return args;
    }
}

