/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.unused;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S3984")
public class UnusedThrowableCheck
extends IssuableSubscriptionVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.NEW_CLASS);
    }

    public void visitNode(Tree tree) {
        NewClassTree newClassTree = (NewClassTree)tree;
        if (newClassTree.symbolType().isSubtypeOf("java.lang.Throwable") && newClassTree.parent().is(new Tree.Kind[]{Tree.Kind.EXPRESSION_STATEMENT})) {
            this.reportIssue((Tree)newClassTree, "Throw this exception or remove this useless statement");
        }
    }
}

