/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.unused;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.Javadoc;
import org.sonar.java.checks.helpers.MethodTreeUtils;
import org.sonar.java.checks.helpers.UnresolvedIdentifiersVisitor;
import org.sonar.java.collections.SetUtils;
import org.sonar.java.model.JUtils;
import org.sonar.java.model.ModifiersUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.NewArrayTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S1172")
public class UnusedMethodParameterCheck
extends IssuableSubscriptionVisitor {
    private static final String AUTHORIZED_ANNOTATION = "javax.enterprise.event.Observes";
    private static final String SUPPRESS_WARNINGS_ANNOTATION = "java.lang.SuppressWarnings";
    private static final Set<String> EXCLUDED_WARNINGS_SUPPRESSIONS = SetUtils.immutableSetOf((Object[])new String[]{"\"rawtypes\"", "\"unchecked\""});
    private static final MethodMatchers SERIALIZABLE_METHODS = MethodMatchers.or((MethodMatchers[])new MethodMatchers[]{MethodMatchers.create().ofAnyType().names(new String[]{"writeObject"}).addParametersMatcher(new String[]{"java.io.ObjectOutputStream"}).build(), MethodMatchers.create().ofAnyType().names(new String[]{"readObject"}).addParametersMatcher(new String[]{"java.io.ObjectInputStream"}).build()});
    private static final String STRUTS_ACTION_SUPERCLASS = "org.apache.struts.action.Action";
    private static final Set<String> EXCLUDED_STRUTS_ACTION_PARAMETER_TYPES = SetUtils.immutableSetOf((Object[])new String[]{"org.apache.struts.action.ActionMapping", "org.apache.struts.action.ActionForm", "javax.servlet.http.HttpServletRequest", "javax.servlet.http.HttpServletResponse"});
    private static final UnresolvedIdentifiersVisitor UNRESOLVED_IDENTIFIERS_VISITOR = new UnresolvedIdentifiersVisitor();

    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.METHOD, Tree.Kind.CONSTRUCTOR);
    }

    public void visitNode(Tree tree) {
        MethodTree methodTree = (MethodTree)tree;
        if (methodTree.block() == null || methodTree.parameters().isEmpty() || UnusedMethodParameterCheck.isExcluded(methodTree)) {
            return;
        }
        HashSet<String> undocumentedParameters = new HashSet<String>(new Javadoc((Tree)methodTree).undocumentedParameters());
        boolean overridableMethod = JUtils.isOverridable((Symbol.MethodSymbol)methodTree.symbol());
        List<Object> unused = new ArrayList();
        for (VariableTree parameter : methodTree.parameters()) {
            Symbol symbol = parameter.symbol();
            if (!symbol.usages().isEmpty() || symbol.metadata().isAnnotatedWith(AUTHORIZED_ANNOTATION) || UnusedMethodParameterCheck.isStrutsActionParameter(parameter) || overridableMethod && !undocumentedParameters.contains(symbol.name())) continue;
            unused.add(parameter.simpleName());
        }
        Set<String> unresolvedIdentifierNames = UNRESOLVED_IDENTIFIERS_VISITOR.check((Tree)methodTree.block());
        if (!(unused = unused.stream().filter(id -> !unresolvedIdentifierNames.contains(id.name())).collect(Collectors.toList())).isEmpty()) {
            this.reportUnusedParameters(unused);
        }
    }

    private void reportUnusedParameters(List<IdentifierTree> unused) {
        ArrayList<JavaFileScannerContext.Location> locations = new ArrayList<JavaFileScannerContext.Location>();
        for (IdentifierTree identifier : unused) {
            locations.add(new JavaFileScannerContext.Location("Remove this unused method parameter " + identifier.name() + "\".", (Tree)identifier));
        }
        IdentifierTree firstUnused = unused.get(0);
        String msg = unused.size() > 1 ? "Remove these unused method parameters." : "Remove this unused method parameter \"" + firstUnused.name() + "\".";
        this.reportIssue((Tree)firstUnused, msg, locations, null);
    }

    private static boolean isExcluded(MethodTree tree) {
        return MethodTreeUtils.isMainMethod(tree) || UnusedMethodParameterCheck.isAnnotated(tree) || UnusedMethodParameterCheck.isOverriding(tree) || UnusedMethodParameterCheck.isSerializableMethod(tree) || UnusedMethodParameterCheck.isDesignedForExtension(tree) || UnusedMethodParameterCheck.isUsedAsMethodReference(tree);
    }

    private static boolean isAnnotated(MethodTree tree) {
        return tree.modifiers().annotations().stream().anyMatch(annotation -> !UnusedMethodParameterCheck.isExcludedLiteral((Tree)annotation));
    }

    private static boolean isExcludedLiteral(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.ANNOTATION})) {
            AnnotationTree annotationTree = (AnnotationTree)tree;
            return annotationTree.annotationType().symbolType().is(SUPPRESS_WARNINGS_ANNOTATION) && annotationTree.arguments().stream().allMatch(UnusedMethodParameterCheck::isExcludedLiteral);
        }
        if (tree.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL})) {
            return EXCLUDED_WARNINGS_SUPPRESSIONS.contains(((LiteralTree)tree).value());
        }
        if (tree.is(new Tree.Kind[]{Tree.Kind.NEW_ARRAY})) {
            return ((NewArrayTree)tree).initializers().stream().allMatch(UnusedMethodParameterCheck::isExcludedLiteral);
        }
        return false;
    }

    private static boolean isDesignedForExtension(MethodTree tree) {
        if (tree.symbol().enclosingClass().isFinal()) {
            return false;
        }
        ModifiersTree modifiers = tree.modifiers();
        return ModifiersUtils.hasModifier((ModifiersTree)modifiers, (Modifier)Modifier.DEFAULT) || !ModifiersUtils.hasModifier((ModifiersTree)modifiers, (Modifier)Modifier.PRIVATE) && UnusedMethodParameterCheck.isEmptyOrThrowStatement(tree.block());
    }

    private static boolean isStrutsActionParameter(VariableTree variableTree) {
        Type superClass = variableTree.symbol().enclosingClass().superClass();
        return superClass != null && superClass.isSubtypeOf(STRUTS_ACTION_SUPERCLASS) && EXCLUDED_STRUTS_ACTION_PARAMETER_TYPES.contains(variableTree.symbol().type().fullyQualifiedName());
    }

    private static boolean isEmptyOrThrowStatement(BlockTree block) {
        return block.body().isEmpty() || block.body().size() == 1 && ((StatementTree)block.body().get(0)).is(new Tree.Kind[]{Tree.Kind.THROW_STATEMENT});
    }

    private static boolean isSerializableMethod(MethodTree methodTree) {
        return ModifiersUtils.hasModifier((ModifiersTree)methodTree.modifiers(), (Modifier)Modifier.PRIVATE) && SERIALIZABLE_METHODS.matches(methodTree);
    }

    private static boolean isOverriding(MethodTree tree) {
        return !Boolean.FALSE.equals(tree.isOverriding());
    }

    private static boolean isUsedAsMethodReference(MethodTree tree) {
        return tree.symbol().usages().stream().anyMatch(identifier -> identifier.parent().is(new Tree.Kind[]{Tree.Kind.METHOD_REFERENCE}));
    }
}

