/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.java.collections.SetUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.SyntaxToken;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2757")
public class WrongAssignmentOperatorCheck
extends IssuableSubscriptionVisitor {
    private static final Set<String> SUSPICIOUS_TOKEN_VALUES = SetUtils.immutableSetOf((Object[])new String[]{"!", "+", "-"});

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.ASSIGNMENT);
    }

    public void visitNode(Tree tree) {
        AssignmentExpressionTree aeTree = (AssignmentExpressionTree)tree;
        SyntaxToken operatorToken = aeTree.operatorToken();
        SyntaxToken expressionFirstToken = aeTree.expression().firstToken();
        SyntaxToken variableLastToken = aeTree.variable().lastToken();
        if (WrongAssignmentOperatorCheck.isSuspiciousToken(expressionFirstToken) && WrongAssignmentOperatorCheck.noSpacingBetween(operatorToken, expressionFirstToken) && !WrongAssignmentOperatorCheck.noSpacingBetween(variableLastToken, operatorToken)) {
            this.reportIssue((Tree)operatorToken, (Tree)expressionFirstToken, WrongAssignmentOperatorCheck.getMessage(expressionFirstToken, aeTree));
        }
    }

    private static String getMessage(SyntaxToken expressionFirstToken, AssignmentExpressionTree aeTree) {
        if (WrongAssignmentOperatorCheck.isSingleNegationAssignment(expressionFirstToken, aeTree)) {
            return "Add a space between \"=\" and \"!\" to avoid confusion.";
        }
        return "Was \"" + expressionFirstToken.text() + "=\" meant instead?";
    }

    private static boolean isSingleNegationAssignment(SyntaxToken firstToken, AssignmentExpressionTree aeTree) {
        return "!".equals(firstToken.text()) && (aeTree.parent() == null || !aeTree.parent().is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT}));
    }

    private static boolean noSpacingBetween(SyntaxToken firstToken, SyntaxToken secondToken) {
        return firstToken.line() == secondToken.line() && firstToken.column() + firstToken.text().length() == secondToken.column();
    }

    private static boolean isSuspiciousToken(SyntaxToken firstToken) {
        return SUSPICIOUS_TOKEN_VALUES.contains(firstToken.text());
    }
}

