/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.tests;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.java.checks.helpers.ExpressionsHelper;
import org.sonar.java.checks.helpers.MethodTreeUtils;
import org.sonar.java.checks.helpers.UnitTestUtils;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.model.SyntacticEquivalence;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.ExpressionStatementTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S5853")
public class AssertJConsecutiveAssertionCheck
extends IssuableSubscriptionVisitor {
    private static final MethodMatchers ASSERT_THAT_MATCHER = MethodMatchers.create().ofSubTypes(new String[]{"org.assertj.core.api.Assertions", "org.assertj.core.api.Assert"}).names(new String[]{"assertThat"}).addParametersMatcher(new String[]{"*"}).build();
    public static final MethodMatchers ASSERTJ_SET_CONTEXT_METHODS = MethodMatchers.create().ofSubTypes(new String[]{"org.assertj.core.api.AbstractAssert"}).name(name -> name.startsWith("extracting") || name.startsWith("using") || name.startsWith("filtered")).withAnyParameters().build();

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        BlockTree block;
        MethodTree methodTree = (MethodTree)tree;
        if (UnitTestUtils.hasTestAnnotation(methodTree) && (block = methodTree.block()) != null) {
            this.reportConsecutiveAssertions(block.body());
        }
    }

    private void reportConsecutiveAssertions(List<StatementTree> statements) {
        AssertSubject currentSubject = null;
        ArrayList<AssertSubject> equivalentInvocations = new ArrayList<AssertSubject>();
        for (StatementTree statement : statements) {
            Optional<AssertSubject> assertThatInvocation = AssertJConsecutiveAssertionCheck.getSimpleAssertSubject(statement);
            if (assertThatInvocation.isPresent()) {
                AssertSubject assertSubject = assertThatInvocation.get();
                if (currentSubject == null) {
                    currentSubject = assertSubject;
                    continue;
                }
                if (currentSubject.hasEquivalentArgument(assertSubject)) {
                    equivalentInvocations.add(assertSubject);
                    continue;
                }
                this.reportIssueIfMultipleCalls(currentSubject, equivalentInvocations);
                currentSubject = assertSubject;
                equivalentInvocations.clear();
                continue;
            }
            this.reportIssueIfMultipleCalls(currentSubject, equivalentInvocations);
            currentSubject = null;
            equivalentInvocations.clear();
        }
        this.reportIssueIfMultipleCalls(currentSubject, equivalentInvocations);
    }

    private static Optional<AssertSubject> getSimpleAssertSubject(StatementTree statement) {
        if (statement.is(new Tree.Kind[]{Tree.Kind.EXPRESSION_STATEMENT})) {
            ExpressionTree expression = ((ExpressionStatementTree)statement).expression();
            if (expression.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
                return AssertJConsecutiveAssertionCheck.getSimpleAssertSubject(((MethodInvocationTree)expression).methodSelect());
            }
        }
        return Optional.empty();
    }

    private static Optional<AssertSubject> getSimpleAssertSubject(ExpressionTree expressionTree) {
        if (expressionTree.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            ExpressionTree memberSelectExpression = ((MemberSelectExpressionTree)expressionTree).expression();
            if (memberSelectExpression.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
                MethodInvocationTree mit = (MethodInvocationTree)memberSelectExpression;
                if (ASSERT_THAT_MATCHER.matches(mit)) {
                    ExpressionTree arg = (ExpressionTree)mit.arguments().get(0);
                    if (ExpressionsHelper.alwaysReturnSameValue(arg)) {
                        return Optional.of(new AssertSubject(mit, arg));
                    }
                } else {
                    if (ASSERTJ_SET_CONTEXT_METHODS.matches(mit)) {
                        return Optional.empty();
                    }
                    return AssertJConsecutiveAssertionCheck.getSimpleAssertSubject(mit.methodSelect());
                }
            }
        }
        return Optional.empty();
    }

    private void reportIssueIfMultipleCalls(@Nullable AssertSubject assertSubject, List<AssertSubject> equivalentAssertions) {
        if (assertSubject != null && !equivalentAssertions.isEmpty()) {
            this.reportIssue((Tree)assertSubject.methodName(), "Join these multiple assertions subject to one assertion chain.", equivalentAssertions.stream().map(AssertSubject::toSecondaryLocation).collect(Collectors.toList()), null);
        }
    }

    private static class AssertSubject {
        final MethodInvocationTree mit;
        final Type assertionType;
        final ExpressionTree arg;

        AssertSubject(MethodInvocationTree mit, ExpressionTree arg) {
            this.mit = mit;
            this.assertionType = mit.symbolType().erasure();
            this.arg = arg;
        }

        boolean hasEquivalentArgument(AssertSubject other) {
            return SyntacticEquivalence.areEquivalent((Tree)this.arg, (Tree)other.arg) && (other.assertionType.isSubtypeOf(this.assertionType) || this.couldBeChained(other));
        }

        boolean couldBeChained(AssertSubject other) {
            return MethodTreeUtils.consecutiveMethodInvocation((Tree)other.mit).map(chainedNextMethod -> chainedNextMethod.symbol().owner().type().erasure()).map(arg_0 -> ((Type)this.mit.symbol().owner().type().erasure()).isSubtypeOf(arg_0)).orElse(false);
        }

        IdentifierTree methodName() {
            return ExpressionUtils.methodName((MethodInvocationTree)this.mit);
        }

        JavaFileScannerContext.Location toSecondaryLocation() {
            return new JavaFileScannerContext.Location("Other assertThat", (Tree)this.methodName());
        }
    }
}

