/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import org.sonar.check.Rule;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.java.model.JUtils;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.Arguments;
import org.sonar.plugins.java.api.tree.ArrayAccessExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodReferenceTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeCastTree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S1905")
public class RedundantTypeCastCheck
extends IssuableSubscriptionVisitor {
    private static final Predicate<Symbol.MethodSymbol> NON_DEFAULT_METHOD_PREDICATE = method -> !JUtils.isDefaultMethod((Symbol.MethodSymbol)method);

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.TYPE_CAST);
    }

    public void visitNode(Tree tree) {
        TypeCastTree typeCastTree = (TypeCastTree)tree;
        Type expressionType = typeCastTree.expression().symbolType();
        if (RedundantTypeCastCheck.isPrimitiveWrapperInConditional(expressionType, typeCastTree) || RedundantTypeCastCheck.requiredForMemberAccess(typeCastTree)) {
            return;
        }
        Type cast = typeCastTree.type().symbolType();
        Type target = RedundantTypeCastCheck.targetType(typeCastTree);
        if (target != null && (RedundantTypeCastCheck.isRedundantNumericalCast(cast, expressionType) || RedundantTypeCastCheck.isUnnecessarySubtypeCast(expressionType, typeCastTree, target))) {
            this.reportIssue((Tree)typeCastTree.type(), "Remove this unnecessary cast to \"" + cast.erasure() + "\".");
        }
    }

    private static boolean requiredForMemberAccess(TypeCastTree typeCastTree) {
        ExpressionTree expression = typeCastTree.expression();
        if (!expression.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
            Tree parent = typeCastTree.parent();
            return expression.is(new Tree.Kind[]{Tree.Kind.METHOD_REFERENCE}) && parent != null && RedundantTypeCastCheck.skipParentheses(parent).is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT});
        }
        Symbol symbol = ((MethodInvocationTree)expression).symbol();
        if (!symbol.isMethodSymbol()) {
            return false;
        }
        return RedundantTypeCastCheck.skipParentheses(typeCastTree.parent()).is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT});
    }

    private static boolean isPrimitiveWrapperInConditional(Type expressionType, TypeCastTree typeCastTree) {
        Tree parent = RedundantTypeCastCheck.skipParentheses(typeCastTree.parent());
        return parent.is(new Tree.Kind[]{Tree.Kind.CONDITIONAL_EXPRESSION}) && (JUtils.isPrimitiveWrapper((Type)expressionType) || expressionType.isPrimitive());
    }

    @CheckForNull
    private static Type targetType(TypeCastTree typeCastTree) {
        Tree parent = RedundantTypeCastCheck.skipParentheses(typeCastTree.parent());
        switch (parent.kind()) {
            case RETURN_STATEMENT: {
                Tree method = parent;
                while (!method.is(new Tree.Kind[]{Tree.Kind.METHOD, Tree.Kind.LAMBDA_EXPRESSION})) {
                    method = method.parent();
                }
                if (method.is(new Tree.Kind[]{Tree.Kind.METHOD})) {
                    return ((MethodTree)method).symbol().returnType().type();
                }
                return null;
            }
            case VARIABLE: {
                return ((VariableTree)parent).symbol().type();
            }
            case ARGUMENTS: {
                Arguments arguments = (Arguments)parent;
                Tree invocation = arguments.parent();
                if (invocation.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
                    return RedundantTypeCastCheck.targetTypeFromMethodSymbol(((MethodInvocationTree)invocation).symbol(), arguments, typeCastTree);
                }
                if (invocation.is(new Tree.Kind[]{Tree.Kind.NEW_CLASS})) {
                    return RedundantTypeCastCheck.targetTypeFromMethodSymbol(((NewClassTree)invocation).constructorSymbol(), arguments, typeCastTree);
                }
                return null;
            }
            case MEMBER_SELECT: 
            case CONDITIONAL_EXPRESSION: {
                return typeCastTree.type().symbolType();
            }
            case ARRAY_ACCESS_EXPRESSION: {
                return ((ArrayAccessExpressionTree)parent).expression().symbolType();
            }
        }
        if (parent instanceof ExpressionTree) {
            return ((ExpressionTree)parent).symbolType();
        }
        return null;
    }

    @CheckForNull
    private static Type targetTypeFromMethodSymbol(Symbol symbol, Arguments arguments, TypeCastTree typeCastTree) {
        if (symbol.isMethodSymbol()) {
            Symbol.MethodSymbol sym = (Symbol.MethodSymbol)symbol;
            int castArgIndex = RedundantTypeCastCheck.indexOfTypeCast(arguments, typeCastTree);
            List parameterTypes = sym.parameterTypes();
            int nbParameters = parameterTypes.size();
            return nbParameters > castArgIndex ? (Type)parameterTypes.get(castArgIndex) : (Type)parameterTypes.get(nbParameters - 1);
        }
        return null;
    }

    private static int indexOfTypeCast(Arguments arguments, TypeCastTree typeCastTree) {
        int i = 0;
        ExpressionTree arg;
        while (!typeCastTree.equals(arg = ExpressionUtils.skipParentheses((ExpressionTree)((ExpressionTree)arguments.get(i))))) {
            ++i;
        }
        return i;
    }

    private static Tree skipParentheses(Tree parent) {
        Tree skip = parent;
        while (skip.is(new Tree.Kind[]{Tree.Kind.PARENTHESIZED_EXPRESSION})) {
            skip = skip.parent();
        }
        return skip;
    }

    private static boolean isUnnecessarySubtypeCast(Type childType, TypeCastTree typeCastTree, Type parentType) {
        Tree parentTree = RedundantTypeCastCheck.skipParentheses(typeCastTree.parent());
        boolean isArgument = parentTree.is(new Tree.Kind[]{Tree.Kind.ARGUMENTS});
        return !childType.isPrimitive() && (typeCastTree.type().symbolType().equals(childType) || isArgument && childType.equals(parentType) || !isArgument && childType.isSubtypeOf(parentType)) && (!ExpressionUtils.skipParentheses((ExpressionTree)typeCastTree.expression()).is(new Tree.Kind[]{Tree.Kind.LAMBDA_EXPRESSION}) || RedundantTypeCastCheck.isUnnecessaryLambdaCast(childType, parentType)) && (!isArgument || !RedundantTypeCastCheck.isMandatoryMethodReferenceCast(typeCastTree, parentTree));
    }

    private static boolean isMandatoryMethodReferenceCast(TypeCastTree typeCastTree, Tree parentTree) {
        Tree preParent = RedundantTypeCastCheck.skipParentheses(parentTree.parent());
        ExpressionTree castExpression = typeCastTree.expression();
        if (castExpression.is(new Tree.Kind[]{Tree.Kind.METHOD_REFERENCE}) && preParent.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
            MethodReferenceTree expression = (MethodReferenceTree)castExpression;
            MethodInvocationTree methodInvocationTree = (MethodInvocationTree)preParent;
            Symbol methodAsArg = expression.method().symbol();
            Symbol methodCaller = methodInvocationTree.symbol();
            return RedundantTypeCastCheck.hasOverloads(methodAsArg) && RedundantTypeCastCheck.hasOverloads(methodCaller);
        }
        return false;
    }

    private static boolean hasOverloads(Symbol symbol) {
        Symbol owner = symbol.owner();
        return owner.isTypeSymbol() && RedundantTypeCastCheck.calcOverloads((Symbol.TypeSymbol)owner, symbol.name()) > 1L;
    }

    private static long calcOverloads(Symbol.TypeSymbol owner, String methodName) {
        return owner.memberSymbols().stream().filter(member -> member.isMethodSymbol() && member.name().equals(methodName)).count();
    }

    private static boolean isUnnecessaryLambdaCast(Type childType, Type parentType) {
        if (parentType.isSubtypeOf(childType) && !RedundantTypeCastCheck.isRawTypeOfParameterizedType(parentType, childType)) {
            return true;
        }
        if (JUtils.isIntersectionType((Type)childType)) {
            return false;
        }
        List childMethods = RedundantTypeCastCheck.getMethodSymbolsOf(childType).collect(Collectors.toList());
        return childMethods.isEmpty() || childMethods.size() == 1 && RedundantTypeCastCheck.isSingleAbstractMethodOverride((Symbol.MethodSymbol)childMethods.get(0), parentType);
    }

    private static boolean isRawTypeOfParameterizedType(Type parentType, Type childType) {
        return childType.isParameterized() && !parentType.isParameterized() && parentType.erasure().equals(childType.erasure());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isSingleAbstractMethodOverride(Symbol.MethodSymbol childMethod, Type parentType) {
        Symbol.MethodSymbol overriddenSymbol = childMethod.overriddenSymbol();
        if (JUtils.isDefaultMethod((Symbol.MethodSymbol)childMethod)) return false;
        if (overriddenSymbol == null) return false;
        if (!RedundantTypeCastCheck.getMethodSymbolsOf(parentType).filter(NON_DEFAULT_METHOD_PREDICATE).anyMatch(overriddenSymbol::equals)) return false;
        return true;
    }

    private static Stream<Symbol.MethodSymbol> getMethodSymbolsOf(Type type) {
        return type.symbol().memberSymbols().stream().filter(Symbol::isMethodSymbol).map(Symbol.MethodSymbol.class::cast);
    }

    private static boolean isRedundantNumericalCast(Type cast, Type expressionType) {
        return cast.isNumerical() && cast.equals(expressionType);
    }
}

