/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.tests;

import java.util.List;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.java.checks.tests.AbstractOneExpectedExceptionRule;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;

@Rule(key="S5783")
public class OneExpectedCheckedExceptionCheck
extends AbstractOneExpectedExceptionRule {
    @Override
    void reportMultipleCallInTree(List<Type> expectedExceptions, Tree treeToVisit, Tree reportLocation, String placeToRefactor) {
        List checkedTypes = expectedExceptions.stream().filter(AbstractOneExpectedExceptionRule::isChecked).collect(Collectors.toList());
        if (checkedTypes.isEmpty()) {
            return;
        }
        AbstractOneExpectedExceptionRule.MethodInvocationCollector visitor = new AbstractOneExpectedExceptionRule.MethodInvocationCollector(symbol -> OneExpectedCheckedExceptionCheck.throwExpectedException(symbol, checkedTypes));
        treeToVisit.accept((TreeVisitor)visitor);
        List<Tree> invocationTree = visitor.invocationTree;
        if (invocationTree.size() > 1) {
            this.reportIssue(reportLocation, String.format("Refactor the %s to have only one invocation throwing an exception.", placeToRefactor), OneExpectedCheckedExceptionCheck.secondaryLocations(invocationTree), null);
        }
    }

    private static boolean throwExpectedException(Symbol symbol, List<Type> checkedTypes) {
        return symbol.isMethodSymbol() && ((Symbol.MethodSymbol)symbol).thrownTypes().stream().anyMatch(t -> checkedTypes.stream().anyMatch(arg_0 -> ((Type)t).isSubtypeOf(arg_0)));
    }
}

