/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.security;

import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S4425")
public class IntegerToHexStringCheck
extends AbstractMethodDetection {
    private static final MethodMatchers APPEND_MATCHER = MethodMatchers.create().ofSubTypes(new String[]{"java.lang.AbstractStringBuilder"}).names(new String[]{"append"}).addParametersMatcher(new String[]{"java.lang.String"}).build();
    private static final MethodMatchers PRINT_MATCHER = MethodMatchers.create().ofSubTypes(new String[]{"java.io.PrintStream"}).names(new String[]{"print"}).addParametersMatcher(new String[]{"java.lang.String"}).build();
    private static final MethodMatchers JOINER_MATCHER = MethodMatchers.create().ofSubTypes(new String[]{"java.util.StringJoiner"}).names(new String[]{"add"}).addParametersMatcher(new String[]{"java.lang.CharSequence"}).build();

    @Override
    protected MethodMatchers getMethodInvocationMatchers() {
        return MethodMatchers.create().ofTypes(new String[]{"java.lang.Integer"}).names(new String[]{"toHexString"}).addParametersMatcher(new String[]{"int"}).build();
    }

    @Override
    protected void onMethodInvocationFound(MethodInvocationTree method) {
        if (IntegerToHexStringCheck.isArgumentAppended(method) && IntegerToHexStringCheck.typeIsByte((ExpressionTree)method.arguments().get(0))) {
            this.reportIssue((Tree)method.methodSelect(), "Use String.format( \"%02X\", ...) instead.");
        }
    }

    private static boolean isArgumentAppended(MethodInvocationTree method) {
        return Optional.of(method).map(Tree::parent).filter(tree -> tree.is(new Tree.Kind[]{Tree.Kind.ARGUMENTS})).map(Tree::parent).filter(tree -> tree.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})).map(MethodInvocationTree.class::cast).filter(parentMethod -> APPEND_MATCHER.matches(parentMethod) || PRINT_MATCHER.matches(parentMethod) || JOINER_MATCHER.matches(parentMethod)).isPresent();
    }

    private static boolean typeIsByte(ExpressionTree expression) {
        return expression.symbolType().isSubtypeOf("byte") || ExpressionUtils.isSecuringByte((ExpressionTree)expression);
    }
}

