/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.regex;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.java.checks.regex.AbstractRegexCheck;
import org.sonar.java.regex.RegexCheck;
import org.sonar.java.regex.RegexParseResult;
import org.sonar.java.regex.SyntaxError;
import org.sonar.java.regex.ast.BackReferenceTree;
import org.sonar.java.regex.ast.CapturingGroupTree;
import org.sonar.java.regex.ast.RegexBaseVisitor;
import org.sonar.java.regex.ast.RegexSyntaxElement;
import org.sonar.java.regex.ast.RegexTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;

@Rule(key="S5856")
public class InvalidRegexCheck
extends AbstractRegexCheck {
    private static final String ERROR_MESSAGE = "Fix the %s error%s inside this regex.";

    @Override
    public void checkRegex(RegexParseResult regexForLiterals, MethodInvocationTree mit) {
        List syntaxErrors = regexForLiterals.getSyntaxErrors();
        new GroupVisitor().visit(regexForLiterals);
        if (!syntaxErrors.isEmpty()) {
            this.reportSyntaxErrors(syntaxErrors);
        }
    }

    private void reportSyntaxErrors(List<SyntaxError> syntaxErrors) {
        RegexSyntaxElement tree = syntaxErrors.get(0).getOffendingSyntaxElement();
        List<RegexCheck.RegexIssueLocation> secondaries = syntaxErrors.stream().map(error -> new RegexCheck.RegexIssueLocation(error.getOffendingSyntaxElement(), error.getMessage())).collect(Collectors.toList());
        this.reportIssue(tree, secondaries, "syntax");
    }

    private void reportIssue(RegexSyntaxElement tree, List<RegexCheck.RegexIssueLocation> secondaries, String errorKind) {
        String msg = String.format(ERROR_MESSAGE, errorKind, secondaries.size() > 1 ? "s" : "");
        this.reportIssue(tree, msg, null, secondaries);
    }

    private final class GroupVisitor
    extends RegexBaseVisitor {
        final Map<String, CapturingGroupTree> groupNames = new HashMap<String, CapturingGroupTree>();
        final Map<String, BackReferenceTree> backReferenceNames = new HashMap<String, BackReferenceTree>();

        private GroupVisitor() {
        }

        public void visitCapturingGroup(CapturingGroupTree tree) {
            super.visitCapturingGroup(tree);
            tree.getName().ifPresent(groupName -> this.groupNames.put((String)groupName, tree));
        }

        public void visitBackReference(BackReferenceTree tree) {
            super.visitBackReference(tree);
            if (tree.isNamedGroup()) {
                this.backReferenceNames.put(tree.groupName(), tree);
            }
        }

        protected void after(RegexParseResult regexParseResult) {
            BackReferenceTree firstWrongBackReference = null;
            ArrayList<RegexCheck.RegexIssueLocation> secondaries = new ArrayList<RegexCheck.RegexIssueLocation>();
            for (Map.Entry<String, BackReferenceTree> backReference : this.backReferenceNames.entrySet()) {
                String key = backReference.getKey();
                BackReferenceTree backReferenceTree = backReference.getValue();
                CapturingGroupTree capturingGroupTree = this.groupNames.get(key);
                String groupName = backReferenceTree.groupName();
                boolean reported = false;
                if (capturingGroupTree == null) {
                    secondaries.add(new RegexCheck.RegexIssueLocation((RegexSyntaxElement)backReferenceTree, String.format("There is no group named '%s'.", groupName)));
                    reported = true;
                } else if (this.isBefore((RegexTree)backReferenceTree, (RegexTree)capturingGroupTree)) {
                    secondaries.add(new RegexCheck.RegexIssueLocation((RegexSyntaxElement)backReferenceTree, String.format("The group named '%s' is not yet declared at this position.", groupName)));
                    reported = true;
                }
                if (!reported || firstWrongBackReference != null) continue;
                firstWrongBackReference = backReferenceTree;
            }
            if (firstWrongBackReference != null) {
                InvalidRegexCheck.this.reportIssue(firstWrongBackReference, secondaries, "back reference");
            }
        }

        private boolean isBefore(RegexTree t1, RegexTree t2) {
            return t1.getRange().getBeginningOffset() < t2.getRange().getBeginningOffset();
        }
    }
}

