/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.check.Rule;
import org.sonar.java.checks.AbstractInSynchronizeChecker;
import org.sonar.java.model.ExpressionUtils;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S2276")
public class ThreadSleepCheck
extends AbstractInSynchronizeChecker {
    @Override
    protected void onMethodInvocationFound(MethodInvocationTree mit) {
        if (this.isInSyncBlock()) {
            this.reportIssue((Tree)ExpressionUtils.methodName((MethodInvocationTree)mit), "Replace the call to \"Thread.sleep(...)\" with a call to \"wait(...)\".");
        }
    }

    @Override
    protected MethodMatchers getMethodInvocationMatchers() {
        return MethodMatchers.create().ofTypes(new String[]{"java.lang.Thread"}).names(new String[]{"sleep"}).withAnyParameters().build();
    }
}

