/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S4531")
public class Struts2EndpointCheck
extends IssuableSubscriptionVisitor {
    private static final MethodMatchers STRUTS2_METHOD = MethodMatchers.create().ofAnyType().names(new String[]{"execute"}).addWithoutParametersMatcher().build();

    public List<Tree.Kind> nodesToVisit() {
        return Collections.singletonList(Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        List<JavaFileScannerContext.Location> settersLocation;
        if (!this.hasSemantic()) {
            return;
        }
        MethodTree methodTree = (MethodTree)tree;
        Symbol owner = methodTree.symbol().owner();
        if (owner.type().isSubtypeOf("com.opensymphony.xwork2.ActionSupport") && STRUTS2_METHOD.matches(methodTree) && !(settersLocation = Struts2EndpointCheck.getSetters(owner)).isEmpty()) {
            this.reportIssue((Tree)methodTree.simpleName(), "Make sure that executing this ActionSupport is safe.", settersLocation, null);
        }
    }

    private static List<JavaFileScannerContext.Location> getSetters(Symbol owner) {
        if (!owner.isTypeSymbol()) {
            return Collections.emptyList();
        }
        return ((Symbol.TypeSymbol)owner).memberSymbols().stream().filter(Symbol::isMethodSymbol).filter(s -> s.name().startsWith("set")).filter(s -> ((Symbol.MethodSymbol)s).parameterTypes().size() == 1).map(Symbol::declaration).map(mt -> new JavaFileScannerContext.Location("", mt)).collect(Collectors.toList());
    }
}

