/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.plugins.java.api.semantic.MethodMatchers;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;

@Rule(key="S2119")
public class ReuseRandomCheck
extends AbstractMethodDetection {
    @Override
    protected MethodMatchers getMethodInvocationMatchers() {
        return MethodMatchers.create().ofTypes(new String[]{"java.util.Random"}).constructor().addWithoutParametersMatcher().build();
    }

    @Override
    protected void onConstructorFound(NewClassTree newClassTree) {
        if (ReuseRandomCheck.assignedToLocalVariablesNotInConstructorOrStaticMain((Tree)newClassTree)) {
            this.reportIssue((Tree)newClassTree.identifier(), "Save and re-use this \"Random\".");
        }
    }

    private static boolean assignedToLocalVariablesNotInConstructorOrStaticMain(Tree tree) {
        Tree parent = tree.parent();
        if (parent.is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT})) {
            return ReuseRandomCheck.isLocalVariableNotInConstructorOrStaticMain(((AssignmentExpressionTree)parent).variable()) && ReuseRandomCheck.assignedToLocalVariablesNotInConstructorOrStaticMain(parent);
        }
        if (parent.is(new Tree.Kind[]{Tree.Kind.VARIABLE})) {
            return ReuseRandomCheck.isLocalVariableNotInConstructorOrStaticMain((ExpressionTree)((VariableTree)parent).simpleName());
        }
        if (parent.is(new Tree.Kind[]{Tree.Kind.PARENTHESIZED_EXPRESSION})) {
            return ReuseRandomCheck.assignedToLocalVariablesNotInConstructorOrStaticMain(parent);
        }
        return parent.is(new Tree.Kind[]{Tree.Kind.EXPRESSION_STATEMENT});
    }

    private static boolean isLocalVariableNotInConstructorOrStaticMain(ExpressionTree expression) {
        if (expression.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            Symbol symbol = ((IdentifierTree)expression).symbol().owner();
            return symbol.isMethodSymbol() && !"<init>".equals(symbol.name()) && (!"main".equals(symbol.name()) || !symbol.isStatic());
        }
        return false;
    }
}

